/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import java.util.concurrent.ExecutionException;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.calcite.com.google.common.cache.CacheLoader;
import org.apache.flink.shaded.calcite.com.google.common.cache.LoadingCache;
import org.apache.flink.shaded.calcite.com.google.common.util.concurrent.UncheckedExecutionException;

class CachingLatticeStatisticProvider
implements LatticeStatisticProvider {
    private final LoadingCache<Pair<Lattice, Lattice.Column>, Integer> cache;

    public CachingLatticeStatisticProvider(final LatticeStatisticProvider provider) {
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<Pair<Lattice, Lattice.Column>, Integer>(){

            @Override
            public Integer load(Pair<Lattice, Lattice.Column> key) throws Exception {
                return provider.cardinality((Lattice)key.left, (Lattice.Column)key.right);
            }
        });
    }

    @Override
    public int cardinality(Lattice lattice, Lattice.Column column) {
        try {
            return this.cache.get(Pair.of(lattice, column));
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            Util.throwIfUnchecked(e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

