/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.AbstractCursor;

public abstract class PositionedCursor<T>
extends AbstractCursor {
    protected abstract T current();

    protected class MapGetter<K>
    extends AbstractCursor.AbstractGetter {
        protected final K key;

        public MapGetter(K key) {
            this.key = key;
        }

        @Override
        public Object getObject() {
            Map map2 = (Map)PositionedCursor.this.current();
            Object o = map2.get(this.key);
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class FieldGetter
    extends AbstractCursor.AbstractGetter {
        protected final Field field;

        public FieldGetter(Field field) {
            this.field = field;
        }

        @Override
        public Object getObject() {
            Object o;
            try {
                o = this.field.get(PositionedCursor.this.current());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class ObjectGetter
    extends AbstractCursor.AbstractGetter {
        public ObjectGetter(int field) {
            assert (field == 0);
        }

        @Override
        public Object getObject() {
            Object o = PositionedCursor.this.current();
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class ListGetter
    extends AbstractCursor.AbstractGetter {
        protected final int index;

        public ListGetter(int index) {
            this.index = index;
        }

        @Override
        public Object getObject() {
            Object o = ((List)PositionedCursor.this.current()).get(this.index);
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }

    protected class ArrayGetter
    extends AbstractCursor.AbstractGetter {
        protected final int field;

        public ArrayGetter(int field) {
            this.field = field;
        }

        @Override
        public Object getObject() {
            Object o = ((Object[])PositionedCursor.this.current())[this.field];
            PositionedCursor.this.wasNull[0] = o == null;
            return o;
        }
    }
}

