/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.AbstractCursor;

public class ArrayImpl
implements Array {
    private final List list;
    private final AbstractCursor.ArrayAccessor accessor;

    public ArrayImpl(List list, AbstractCursor.ArrayAccessor accessor) {
        this.list = list;
        this.accessor = accessor;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.accessor.componentType.name;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.accessor.componentType.id;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArray(this.list);
    }

    public String toString() {
        Iterator iterator = this.list.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder("[");
        while (true) {
            this.accessor.componentSlotGetter.slot = iterator.next();
            try {
                this.append(buf, this.accessor.componentAccessor.getString());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            this.accessor.componentSlotGetter.slot = null;
            if (!iterator.hasNext()) {
                return buf.append("]").toString();
            }
            buf.append(", ");
        }
    }

    private void append(StringBuilder buf, Object o) {
        if (o == null) {
            buf.append("null");
        } else if (o.getClass().isArray()) {
            this.append(buf, AvaticaUtils.primitiveList(o));
        } else {
            buf.append(o);
        }
    }

    protected Object getArray(List list) throws SQLException {
        int i = 0;
        switch (this.accessor.componentType.rep) {
            case PRIMITIVE_DOUBLE: {
                double[] doubles = new double[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    double v = (Double)i$.next();
                    doubles[i++] = v;
                }
                return doubles;
            }
            case PRIMITIVE_FLOAT: {
                float[] floats = new float[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    float v = ((Float)i$.next()).floatValue();
                    floats[i++] = v;
                }
                return floats;
            }
            case PRIMITIVE_INT: {
                int[] ints = new int[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    int v = (Integer)i$.next();
                    ints[i++] = v;
                }
                return ints;
            }
            case PRIMITIVE_LONG: {
                long[] longs = new long[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    long v = (Long)i$.next();
                    longs[i++] = v;
                }
                return longs;
            }
            case PRIMITIVE_SHORT: {
                short[] shorts = new short[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    short v = (Short)i$.next();
                    shorts[i++] = v;
                }
                return shorts;
            }
            case PRIMITIVE_BOOLEAN: {
                boolean[] booleans = new boolean[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    boolean v = (Boolean)i$.next();
                    booleans[i++] = v;
                }
                return booleans;
            }
            case PRIMITIVE_BYTE: {
                byte[] bytes = new byte[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    byte v = (Byte)i$.next();
                    bytes[i++] = v;
                }
                return bytes;
            }
            case PRIMITIVE_CHAR: {
                char[] chars = new char[list.size()];
                Iterator i$ = list.iterator();
                while (i$.hasNext()) {
                    char v = ((Character)i$.next()).charValue();
                    chars[i++] = v;
                }
                return chars;
            }
        }
        Object[] objects = list.toArray();
        switch (this.accessor.componentType.id) {
            case 2003: {
                AbstractCursor.ArrayAccessor componentAccessor = (AbstractCursor.ArrayAccessor)this.accessor.componentAccessor;
                for (i = 0; i < objects.length; ++i) {
                    objects[i] = new ArrayImpl((List)objects[i], componentAccessor);
                }
                break;
            }
        }
        return objects;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(this.list.subList((int)index, count));
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.accessor.factory.create(this.accessor.componentType, this.list);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() throws SQLException {
    }

    public static interface Factory {
        public ResultSet create(ColumnMetaData.AvaticaType var1, Iterable<Object> var2);
    }
}

