/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Props$;
import com.typesafe.config.Config;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.akka.DefaultQuarantineHandler;
import org.apache.flink.runtime.akka.QuarantineMonitor;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.process.ProcessReaper;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.MemoryLogger;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManagerCliOptions;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.SignalHandler;
import org.jboss.netty.channel.ChannelException;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scopt.OptionParser;
import scopt.Read$;

public final class TaskManager$ {
    public static final TaskManager$ MODULE$;
    private final Logger LOG;
    private final int STARTUP_FAILURE_RETURN_CODE;
    private final int RUNTIME_FAILURE_RETURN_CODE;
    private final long MAX_STARTUP_CONNECT_TIME;
    private final long STARTUP_CONNECT_LOG_SUPPRESS;
    private final FiniteDuration HEARTBEAT_INTERVAL;

    static {
        new TaskManager$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public int STARTUP_FAILURE_RETURN_CODE() {
        return this.STARTUP_FAILURE_RETURN_CODE;
    }

    public int RUNTIME_FAILURE_RETURN_CODE() {
        return this.RUNTIME_FAILURE_RETURN_CODE;
    }

    public long MAX_STARTUP_CONNECT_TIME() {
        return this.MAX_STARTUP_CONNECT_TIME;
    }

    public long STARTUP_CONNECT_LOG_SUPPRESS() {
        return this.STARTUP_CONNECT_LOG_SUPPRESS;
    }

    public FiniteDuration HEARTBEAT_INTERVAL() {
        return this.HEARTBEAT_INTERVAL;
    }

    public void main(String[] args) {
        Configuration configuration;
        EnvironmentInformation.logEnvironmentInfo(this.LOG().logger(), "TaskManager", args);
        SignalHandler.register(this.LOG().logger());
        JvmShutdownSafeguard.installAsShutdownHook(this.LOG().logger());
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            this.LOG().info((Function0)new Serializable(maxOpenFileHandles){
                public static final long serialVersionUID = 0L;
                private final long maxOpenFileHandles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum number of open file descriptors is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxOpenFileHandles$1)}));
                }
                {
                    this.maxOpenFileHandles$1 = maxOpenFileHandles$1;
                }
            });
        } else {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot determine the maximum number of open file descriptors";
                }
            });
        }
        try {
            configuration = this.parseArgsAndLoadConfig(args);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final String apply() {
                    return this.t$11.getMessage();
                }
                {
                    this.t$11 = t$11;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final Throwable apply() {
                    return this.t$11;
                }
                {
                    this.t$11 = t$11;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            configuration = null;
        }
        Configuration configuration2 = configuration;
        ResourceID resourceId = ResourceID.generate();
        SecurityUtils.install(new SecurityUtils.SecurityConfiguration(configuration2));
        try {
            SecurityUtils.getInstalledContext().runSecured(new Callable<BoxedUnit>(configuration2, resourceId){
                private final Configuration configuration$1;
                private final ResourceID resourceId$1;

                public void call() {
                    TaskManager$.MODULE$.selectNetworkInterfaceAndRunTaskManager(this.configuration$1, this.resourceId$1, TaskManager.class);
                }
                {
                    this.configuration$1 = configuration$1;
                    this.resourceId$1 = resourceId$1;
                }
            });
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to run TaskManager.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$12;

                public final Throwable apply() {
                    return this.t$12;
                }
                {
                    this.t$12 = t$12;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
    }

    public Configuration parseArgsAndLoadConfig(String[] args) throws Exception {
        Configuration conf;
        OptionParser<TaskManagerCliOptions> parser = new OptionParser<TaskManagerCliOptions>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink TaskManager"}));
                this.opt("configDir", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TaskManagerCliOptions apply(String param, TaskManagerCliOptions conf) {
                        conf.setConfigDir(param);
                        return conf;
                    }
                }).text("Specify configuration directory.");
            }
        };
        TaskManagerCliOptions cliConfig = (TaskManagerCliOptions)parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new TaskManagerCliOptions()).getOrElse((Function0)new Serializable(args, (OptionParser)parser){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;
            private final OptionParser parser$1;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid command line arguments: ", ". Usage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.args$1).mkString(" "), this.parser$1.usage()})));
            }
            {
                this.args$1 = args$1;
                this.parser$1 = parser$1;
            }
        });
        try {
            this.LOG().info((Function0)new Serializable(cliConfig){
                public static final long serialVersionUID = 0L;
                private final TaskManagerCliOptions cliConfig$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading configuration from ").append((Object)this.cliConfig$1.getConfigDir()).toString();
                }
                {
                    this.cliConfig$1 = cliConfig$1;
                }
            });
            conf = GlobalConfiguration.loadConfiguration((String)cliConfig.getConfigDir());
        }
        catch (Exception exception) {
            throw new Exception("Could not load configuration", exception);
        }
        try {
            FileSystem.setDefaultScheme((Configuration)conf);
            return conf;
        }
        catch (IOException iOException) {
            throw new Exception("Error while setting the default filesystem scheme from configuration.", iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void selectNetworkInterfaceAndRunTaskManager(Configuration configuration, ResourceID resourceID, Class<? extends TaskManager> taskManagerClass) throws Exception {
        Tuple2 tuple22;
        HighAvailabilityServices highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, Executors.directExecutor(), HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION);
        Tuple2<String, Object> tuple2 = this.selectNetworkInterfaceAndPort(configuration, highAvailabilityServices);
        if (tuple2 == null) throw new MatchError(tuple2);
        String taskManagerHostname = (String)tuple2._1();
        int actorSystemPort = tuple2._2$mcI$sp();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)taskManagerHostname, (Object)BoxesRunTime.boxToInteger((int)actorSystemPort));
        String taskManagerHostname2 = (String)tuple23._1();
        int actorSystemPort2 = tuple23._2$mcI$sp();
        try {
            this.runTaskManager(taskManagerHostname2, resourceID, actorSystemPort2, configuration, highAvailabilityServices, taskManagerClass);
        }
        catch (Throwable throwable) {
            try {
                highAvailabilityServices.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                this.LOG().warn((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not properly stop the high availability services.";
                    }
                }, (Function0)new Serializable(throwable2){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$13;

                    public final Throwable apply() {
                        return this.t$13;
                    }
                    {
                        this.t$13 = t$13;
                    }
                });
            }
            throw throwable;
        }
        try {
            highAvailabilityServices.close();
            return;
        }
        catch (Throwable throwable) {
            this.LOG().warn((Function0)new /* invalid duplicate definition of identical inner class */, (Function0)new /* invalid duplicate definition of identical inner class */);
        }
    }

    public Tuple2<String, Object> selectNetworkInterfaceAndPort(Configuration configuration, HighAvailabilityServices highAvailabilityServices) throws IOException, IllegalConfigurationException {
        ObjectRef taskManagerHostname = new ObjectRef((Object)configuration.getString("taskmanager.hostname", null));
        if ((String)taskManagerHostname.elem == null) {
            FiniteDuration lookupTimeout = AkkaUtils$.MODULE$.getLookupTimeout(configuration);
            InetAddress taskManagerAddress = LeaderRetrievalUtils.findConnectingAddress(highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID), lookupTimeout);
            taskManagerHostname.elem = taskManagerAddress.getHostName();
            this.LOG().info((Function0)new Serializable(taskManagerHostname, taskManagerAddress){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$2;
                private final InetAddress taskManagerAddress$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager will use hostname/address '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.taskManagerHostname$2.elem}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") for communication."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskManagerAddress$1.getHostAddress()}))).toString();
                }
                {
                    this.taskManagerHostname$2 = taskManagerHostname$2;
                    this.taskManagerAddress$1 = taskManagerAddress$1;
                }
            });
        } else {
            this.LOG().info((Function0)new Serializable(taskManagerHostname){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using configured hostname/address for TaskManager: ").append((Object)((String)this.taskManagerHostname$2.elem)).toString();
                }
                {
                    this.taskManagerHostname$2 = taskManagerHostname$2;
                }
            });
        }
        int actorSystemPort = configuration.getInteger("taskmanager.rpc.port", 0);
        if (actorSystemPort < 0 || actorSystemPort > 65535) {
            throw new IllegalConfigurationException(new StringBuilder().append((Object)"Invalid value for 'taskmanager.rpc.port' (port for the TaskManager actor system) : ").append((Object)BoxesRunTime.boxToInteger((int)actorSystemPort)).append((Object)" - Leave config parameter empty or use 0 to let the system choose a port automatically.").toString());
        }
        return new Tuple2((Object)((String)taskManagerHostname.elem), (Object)BoxesRunTime.boxToInteger((int)actorSystemPort));
    }

    public void runTaskManager(String taskManagerHostname, ResourceID resourceID, int actorSystemPort, Configuration configuration, HighAvailabilityServices highAvailabilityServices) throws Exception {
        this.runTaskManager(taskManagerHostname, resourceID, actorSystemPort, configuration, highAvailabilityServices, TaskManager.class);
    }

    public void runTaskManager(String taskManagerHostname, ResourceID resourceID, int actorSystemPort, Configuration configuration, HighAvailabilityServices highAvailabilityServices, Class<? extends TaskManager> taskManagerClass) throws Exception {
        ActorSystem taskManagerSystem;
        this.LOG().info((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting TaskManager";
            }
        });
        this.LOG().info((Function0)new Serializable(taskManagerHostname, actorSystemPort){
            public static final long serialVersionUID = 0L;
            private final String taskManagerHostname$1;
            private final int actorSystemPort$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting TaskManager actor system at ", ":", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskManagerHostname$1, BoxesRunTime.boxToInteger((int)this.actorSystemPort$1)}));
            }
            {
                this.taskManagerHostname$1 = taskManagerHostname$1;
                this.actorSystemPort$1 = actorSystemPort$1;
            }
        });
        try {
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)taskManagerHostname, (Object)BoxesRunTime.boxToInteger((int)actorSystemPort))));
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug((Function0)new Serializable(akkaConfig){
                    public static final long serialVersionUID = 0L;
                    private final Config akkaConfig$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Using akka configuration\n ").append((Object)this.akkaConfig$1).toString();
                    }
                    {
                        this.akkaConfig$1 = akkaConfig$1;
                    }
                });
            }
            taskManagerSystem = AkkaUtils$.MODULE$.createActorSystem(akkaConfig);
        }
        catch (Throwable throwable) {
            Throwable cause;
            if (throwable instanceof ChannelException && (cause = throwable.getCause()) != null && throwable.getCause() instanceof BindException) {
                throw new IOException(new StringBuilder().append((Object)"Unable to bind TaskManager actor system to address ").append((Object)taskManagerHostname).append((Object)BoxesRunTime.boxToCharacter((char)':')).append((Object)BoxesRunTime.boxToInteger((int)actorSystemPort)).append((Object)" - ").append((Object)cause.getMessage()).toString(), throwable);
            }
            throw new Exception("Could not create TaskManager actor system", throwable);
        }
        try {
            BoxedUnit boxedUnit;
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager actor";
                }
            });
            ActorRef taskManager = this.startTaskManagerComponentsAndActor(configuration, resourceID, taskManagerSystem, highAvailabilityServices, taskManagerHostname, (Option<String>)new Some((Object)TaskExecutor.TASK_MANAGER_NAME), false, taskManagerClass);
            this.LOG().debug((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager process reaper";
                }
            });
            taskManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManager, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "TaskManager_Process_Reaper");
            if (configuration.getBoolean(TaskManagerOptions.EXIT_ON_FATAL_AKKA_ERROR)) {
                DefaultQuarantineHandler quarantineHandler = new DefaultQuarantineHandler(Time.milliseconds((long)AkkaUtils$.MODULE$.getTimeout(configuration).toMillis()), this.RUNTIME_FAILURE_RETURN_CODE(), this.LOG().logger());
                this.LOG().debug((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting TaskManager quarantine monitor";
                    }
                });
                boxedUnit = taskManagerSystem.actorOf(Props$.MODULE$.apply(QuarantineMonitor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quarantineHandler, this.LOG().logger()})));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (this.LOG().isInfoEnabled() && configuration.getBoolean("taskmanager.debug.memory.startLogThread", false)) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting periodic memory usage logger";
                    }
                });
                long interval = configuration.getLong("taskmanager.debug.memory.logIntervalMs", 5000L);
                MemoryLogger logger = new MemoryLogger(this.LOG().logger(), interval, taskManagerSystem);
                logger.start();
            }
            taskManagerSystem.awaitTermination();
            return;
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while starting up taskManager";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$14;

                public final Throwable apply() {
                    return this.t$14;
                }
                {
                    this.t$14 = t$14;
                }
            });
            try {
                taskManagerSystem.shutdown();
            }
            catch (Throwable throwable2) {
                this.LOG().warn((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not cleanly shut down actor system";
                    }
                }, (Function0)new Serializable(throwable2){
                    public static final long serialVersionUID = 0L;
                    private final Throwable tt$1;

                    public final Throwable apply() {
                        return this.tt$1;
                    }
                    {
                        this.tt$1 = tt$1;
                    }
                });
            }
            throw throwable;
        }
    }

    public ActorRef startTaskManagerComponentsAndActor(Configuration configuration, ResourceID resourceID, ActorSystem actorSystem, HighAvailabilityServices highAvailabilityServices, String taskManagerHostname, Option<String> taskManagerActorName, boolean localTaskManagerCommunication, Class<? extends TaskManager> taskManagerClass) throws IllegalConfigurationException, IOException, Exception {
        Option<String> option;
        block4: {
            ActorRef actorRef;
            block3: {
                Props tmProps;
                block2: {
                    InetAddress taskManagerAddress = InetAddress.getByName(taskManagerHostname);
                    TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(configuration, taskManagerAddress, false);
                    TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(configuration);
                    TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, resourceID);
                    MetricRegistry metricRegistry = taskManagerServices.getMetricRegistry();
                    tmProps = this.getTaskManagerProps(taskManagerClass, taskManagerConfiguration, resourceID, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getMemoryManager(), taskManagerServices.getIOManager(), taskManagerServices.getNetworkEnvironment(), highAvailabilityServices, metricRegistry);
                    metricRegistry.startQueryService(actorSystem, resourceID);
                    option = taskManagerActorName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String actorName = (String)some.x();
                    actorRef = actorSystem.actorOf(tmProps, actorName);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                actorRef = actorSystem.actorOf(tmProps);
            }
            return actorRef;
        }
        throw new MatchError(option);
    }

    public Props getTaskManagerProps(Class<? extends TaskManager> taskManagerClass, TaskManagerConfiguration taskManagerConfig, ResourceID resourceID, TaskManagerLocation taskManagerLocation, MemoryManager memoryManager, IOManager ioManager, NetworkEnvironment networkEnvironment, HighAvailabilityServices highAvailabilityServices, MetricRegistry metricsRegistry) {
        return Props$.MODULE$.apply(taskManagerClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerConfig, resourceID, taskManagerLocation, memoryManager, ioManager, networkEnvironment, BoxesRunTime.boxToInteger((int)taskManagerConfig.getNumberSlots()), highAvailabilityServices, metricsRegistry}));
    }

    public ActorRef getTaskManagerRemoteReference(String taskManagerUrl, ActorSystem system, FiniteDuration timeout) throws IOException {
        try {
            Future<ActorRef> future = AkkaUtils$.MODULE$.getActorRefFuture(taskManagerUrl, system, timeout);
            return (ActorRef)Await$.MODULE$.result(future, (Duration)timeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ActorNotFound ? true : throwable2 instanceof TimeoutException;
            if (bl) {
                throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager at ", " not reachable. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerUrl}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please make sure that the TaskManager is running and its port is reachable."})).s((Seq)Nil$.MODULE$)).toString(), throwable2);
            }
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                throw new IOException(new StringBuilder().append((Object)"Could not connect to TaskManager at ").append((Object)taskManagerUrl).toString(), iOException);
            }
            throw throwable;
        }
    }

    private TaskManager$() {
        MODULE$ = this;
        this.LOG = Logger$.MODULE$.apply(TaskManager.class);
        this.STARTUP_FAILURE_RETURN_CODE = 1;
        this.RUNTIME_FAILURE_RETURN_CODE = 2;
        this.MAX_STARTUP_CONNECT_TIME = 120000L;
        this.STARTUP_CONNECT_LOG_SUPPRESS = 10000L;
        this.HEARTBEAT_INTERVAL = new package.DurationInt(package$.MODULE$.DurationInt(5000)).milliseconds();
    }
}

