/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.util.Preconditions;

public class ActorGatewayCheckpointResponder
implements CheckpointResponder {
    private final ActorGateway actorGateway;

    public ActorGatewayCheckpointResponder(ActorGateway actorGateway) {
        this.actorGateway = (ActorGateway)Preconditions.checkNotNull((Object)actorGateway);
    }

    @Override
    public void acknowledgeCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics, SubtaskState checkpointStateHandles) {
        AcknowledgeCheckpoint message = new AcknowledgeCheckpoint(jobID, executionAttemptID, checkpointId, checkpointMetrics, checkpointStateHandles);
        this.actorGateway.tell(message);
    }

    @Override
    public void declineCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, Throwable reason) {
        DeclineCheckpoint decline = new DeclineCheckpoint(jobID, executionAttemptID, checkpointId, reason);
        this.actorGateway.tell(decline);
    }
}

