/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.query.netty.message.KvStateRequestSerializer;
import org.apache.flink.runtime.state.heap.AbstractHeapState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.util.Preconditions;

public class HeapMapState<K, N, UK, UV>
extends AbstractHeapState<K, N, HashMap<UK, UV>, MapState<UK, UV>, MapStateDescriptor<UK, UV>>
implements InternalMapState<N, UK, UV> {
    public HeapMapState(MapStateDescriptor<UK, UV> stateDesc, StateTable<K, N, HashMap<UK, UV>> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        super(stateDesc, stateTable, keySerializer, namespaceSerializer);
    }

    public UV get(UK userKey) {
        HashMap userMap = (HashMap)this.stateTable.get(this.currentNamespace);
        if (userMap == null) {
            return null;
        }
        return (UV)userMap.get(userKey);
    }

    public void put(UK userKey, UV userValue) {
        HashMap<UK, UV> userMap = (HashMap<UK, UV>)this.stateTable.get(this.currentNamespace);
        if (userMap == null) {
            userMap = new HashMap<UK, UV>();
            this.stateTable.put(this.currentNamespace, userMap);
        }
        userMap.put(userKey, userValue);
    }

    public void putAll(Map<UK, UV> value) {
        HashMap<UK, UV> userMap = (HashMap<UK, UV>)this.stateTable.get(this.currentNamespace);
        if (userMap == null) {
            userMap = new HashMap<UK, UV>();
            this.stateTable.put(this.currentNamespace, userMap);
        }
        userMap.putAll(value);
    }

    public void remove(UK userKey) {
        HashMap userMap = (HashMap)this.stateTable.get(this.currentNamespace);
        if (userMap == null) {
            return;
        }
        userMap.remove(userKey);
        if (userMap.isEmpty()) {
            this.clear();
        }
    }

    public boolean contains(UK userKey) {
        HashMap userMap = (HashMap)this.stateTable.get(this.currentNamespace);
        return userMap != null && userMap.containsKey(userKey);
    }

    public Iterable<Map.Entry<UK, UV>> entries() {
        HashMap userMap = (HashMap)this.stateTable.get(this.currentNamespace);
        return userMap == null ? null : userMap.entrySet();
    }

    public Iterable<UK> keys() {
        HashMap userMap = (HashMap)this.stateTable.get(this.currentNamespace);
        return userMap == null ? null : userMap.keySet();
    }

    public Iterable<UV> values() {
        HashMap userMap = (HashMap)this.stateTable.get(this.currentNamespace);
        return userMap == null ? null : userMap.values();
    }

    public Iterator<Map.Entry<UK, UV>> iterator() {
        HashMap userMap = (HashMap)this.stateTable.get(this.currentNamespace);
        return userMap == null ? null : userMap.entrySet().iterator();
    }

    @Override
    public byte[] getSerializedValue(K key, N namespace) throws IOException {
        Preconditions.checkState((namespace != null ? 1 : 0) != 0, (Object)"No namespace given.");
        Preconditions.checkState((key != null ? 1 : 0) != 0, (Object)"No key given.");
        HashMap result = (HashMap)this.stateTable.get(key, namespace);
        if (null == result) {
            return null;
        }
        TypeSerializer userKeySerializer = ((MapStateDescriptor)this.stateDesc).getKeySerializer();
        TypeSerializer userValueSerializer = ((MapStateDescriptor)this.stateDesc).getValueSerializer();
        return KvStateRequestSerializer.serializeMap(result.entrySet(), userKeySerializer, userValueSerializer);
    }
}

