/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.InstantiationUtil;

@Internal
final class JavaSerializer<T extends Serializable>
extends TypeSerializerSingleton<T> {
    private static final long serialVersionUID = 5067491650263321234L;

    JavaSerializer() {
    }

    public boolean isImmutableType() {
        return false;
    }

    public T createInstance() {
        return null;
    }

    public T copy(T from) {
        try {
            return (T)InstantiationUtil.clone(from, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new FlinkRuntimeException("Could not copy element via serialization: " + from, (Throwable)e);
        }
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        try (DataOutputViewStream outViewWrapper = new DataOutputViewStream(target);){
            InstantiationUtil.serializeObject((OutputStream)outViewWrapper, record);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(DataInputView source) throws IOException {
        try (DataInputViewStream inViewWrapper = new DataInputViewStream(source);){
            Serializable serializable = (Serializable)InstantiationUtil.deserializeObject((InputStream)inViewWrapper, (ClassLoader)Thread.currentThread().getContextClassLoader());
            return (T)serializable;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not deserialize object.", e);
        }
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return (T)this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        Object tmp = this.deserialize(source);
        this.serialize((T)tmp, target);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof JavaSerializer;
    }
}

