/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.hadoop.mapred.utils.HadoopUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.security.HadoopSecurityContext;
import org.apache.flink.runtime.security.NoOpSecurityContext;
import org.apache.flink.runtime.security.SecurityContext;
import org.apache.flink.runtime.security.modules.HadoopModule;
import org.apache.flink.runtime.security.modules.JaasModule;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.runtime.security.modules.ZooKeeperModule;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static SecurityContext installedContext = new NoOpSecurityContext();
    private static List<SecurityModule> installedModules = null;

    public static SecurityContext getInstalledContext() {
        return installedContext;
    }

    @VisibleForTesting
    static List<SecurityModule> getInstalledModules() {
        return installedModules;
    }

    public static void install(SecurityConfiguration config) throws Exception {
        ArrayList<SecurityModule> modules = new ArrayList<SecurityModule>();
        try {
            for (Class<? extends SecurityModule> moduleClass : config.getSecurityModules()) {
                SecurityModule module = moduleClass.newInstance();
                module.install(config);
                modules.add(module);
            }
        }
        catch (Exception ex) {
            throw new Exception("unable to establish the security context", ex);
        }
        installedModules = modules;
        if (!(installedContext instanceof NoOpSecurityContext)) {
            LOG.warn("overriding previous security context");
        }
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        installedContext = new HadoopSecurityContext(loginUser);
    }

    static void uninstall() {
        if (installedModules != null) {
            for (SecurityModule module : Lists.reverse(installedModules)) {
                try {
                    module.uninstall();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (SecurityModule.SecurityInstallException e) {
                    LOG.warn("unable to uninstall a security module", (Throwable)e);
                }
            }
            installedModules = null;
        }
        installedContext = new NoOpSecurityContext();
    }

    private SecurityUtils() {
    }

    public static class SecurityConfiguration {
        private static final List<Class<? extends SecurityModule>> DEFAULT_MODULES = Collections.unmodifiableList(Arrays.asList(HadoopModule.class, JaasModule.class, ZooKeeperModule.class));
        private final List<Class<? extends SecurityModule>> securityModules;
        private final org.apache.hadoop.conf.Configuration hadoopConf;
        private final boolean isZkSaslDisable;
        private final boolean useTicketCache;
        private final String keytab;
        private final String principal;
        private final List<String> loginContextNames;
        private final String zkServiceName;
        private final String zkLoginContextName;

        public SecurityConfiguration(Configuration flinkConf) {
            this(flinkConf, HadoopUtils.getHadoopConfiguration());
        }

        public SecurityConfiguration(Configuration flinkConf, org.apache.hadoop.conf.Configuration hadoopConf) {
            this(flinkConf, hadoopConf, DEFAULT_MODULES);
        }

        public SecurityConfiguration(Configuration flinkConf, org.apache.hadoop.conf.Configuration hadoopConf, List<? extends Class<? extends SecurityModule>> securityModules) {
            this.hadoopConf = (org.apache.hadoop.conf.Configuration)Preconditions.checkNotNull((Object)hadoopConf);
            this.isZkSaslDisable = flinkConf.getBoolean(SecurityOptions.ZOOKEEPER_SASL_DISABLE);
            this.keytab = flinkConf.getString(SecurityOptions.KERBEROS_LOGIN_KEYTAB);
            this.principal = flinkConf.getString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL);
            this.useTicketCache = flinkConf.getBoolean(SecurityOptions.KERBEROS_LOGIN_USETICKETCACHE);
            this.loginContextNames = SecurityConfiguration.parseList(flinkConf.getString(SecurityOptions.KERBEROS_LOGIN_CONTEXTS));
            this.zkServiceName = flinkConf.getString(SecurityOptions.ZOOKEEPER_SASL_SERVICE_NAME);
            this.zkLoginContextName = flinkConf.getString(SecurityOptions.ZOOKEEPER_SASL_LOGIN_CONTEXT_NAME);
            this.securityModules = Collections.unmodifiableList(securityModules);
            this.validate();
        }

        public boolean isZkSaslDisable() {
            return this.isZkSaslDisable;
        }

        public String getKeytab() {
            return this.keytab;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public boolean useTicketCache() {
            return this.useTicketCache;
        }

        public org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
            return this.hadoopConf;
        }

        public List<Class<? extends SecurityModule>> getSecurityModules() {
            return this.securityModules;
        }

        public List<String> getLoginContextNames() {
            return this.loginContextNames;
        }

        public String getZooKeeperServiceName() {
            return this.zkServiceName;
        }

        public String getZooKeeperLoginContextName() {
            return this.zkLoginContextName;
        }

        private void validate() {
            if (!StringUtils.isBlank((CharSequence)this.keytab)) {
                if (StringUtils.isBlank((CharSequence)this.principal)) {
                    throw new IllegalConfigurationException("Kerberos login configuration is invalid; keytab requires a principal.");
                }
                File keytabFile = new File(this.keytab);
                if (!(keytabFile.exists() && keytabFile.isFile() && keytabFile.canRead())) {
                    throw new IllegalConfigurationException("Kerberos login configuration is invalid; keytab is unreadable");
                }
            }
        }

        private static List<String> parseList(String value) {
            if (value == null || value.isEmpty()) {
                return Collections.emptyList();
            }
            return Arrays.asList(value.trim().replaceAll("(\\s*,+\\s*)+", ",").split(","));
        }
    }
}

