/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.clusterframework.FlinkResourceManager;
import org.apache.flink.runtime.clusterframework.standalone.StandaloneResourceManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.JobManagerMessages$RequestRunningJobsStatus$;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster;
import org.apache.flink.runtime.taskexecutor.TaskExecutor;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EnvironmentInformation;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple9;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rmf\u0001B\u0001\u0003\u00015\u0011Q\u0003T8dC24E.\u001b8l\u001b&t\u0017n\u00117vgR,'O\u0003\u0002\u0004\t\u0005YQ.\u001b8jG2,8\u000f^3s\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0011\r2Lgn['j]&\u001cE.^:uKJD\u0011b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001\u0006\u000e\u0002#U\u001cXM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u0007\f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0013\t\u0019\u0002\u0003C\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001eG\u0005A\u0002.[4i\u0003Z\f\u0017\u000e\\1cS2LG/_*feZL7-Z:\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\"\u0011\u0001\u00055jO\"\fg/Y5mC\nLG.\u001b;z\u0013\t\u0011sD\u0001\rIS\u001eD\u0017I^1jY\u0006\u0014\u0017\u000e\\5usN+'O^5dKNL!\u0001\b\t\t\u0013\u0015\u0002!\u0011!Q\u0001\n\u0019b\u0013!E:j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[B\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t9!i\\8mK\u0006t\u0017BA\u0017\u0011\u0003Q)8/Z*j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"B!\r\u001a4iA\u0011q\u0002\u0001\u0005\u0006'9\u0002\r\u0001\u0006\u0005\u000699\u0002\r!\b\u0005\u0006K9\u0002\rA\n\u0005\u0006_\u0001!\tA\u000e\u000b\u0004c]B\u0004\"B\n6\u0001\u0004!\u0002\"B\u00176\u0001\u00041\u0003\"B\u0018\u0001\t\u0003QDCA\u0019<\u0011\u0015\u0019\u0012\b1\u0001\u0015\u0011\u0015i\u0004\u0001\"\u0011?\u0003U9WM\\3sCR,7i\u001c8gS\u001e,(/\u0019;j_:$\"\u0001F \t\u000bMa\u0004\u0019\u0001\u000b\t\u000f\u0005\u0003!\u0019!C\u0001\u0005\u0006y!n\u001c2NC:\fw-\u001a:DY\u0006\u001c8/F\u0001Da\t!U\nE\u0002F\u0011.s!a\n$\n\u0005\u001dC\u0013A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n)1\t\\1tg*\u0011q\t\u000b\t\u0003\u00196c\u0001\u0001B\u0005O\u001f\u0006\u0005\t\u0011!B\u0001+\n\u0019q\fJ\u0019\t\rA\u0003\u0001\u0015!\u0003R\u0003AQwNY'b]\u0006<WM]\"mCN\u001c\b\u0005\r\u0002S)B\u0019Q\tS*\u0011\u00051#F!\u0003(P\u0003\u0003\u0005\tQ!\u0001V#\t1\u0016\f\u0005\u0002(/&\u0011\u0001\f\u000b\u0002\b\u001d>$\b.\u001b8h!\tQV,D\u0001\\\u0015\taF!\u0001\u0006k_\nl\u0017M\\1hKJL!AX.\u0003\u0015){'-T1oC\u001e,'\u000fC\u0004a\u0001\t\u0007I\u0011A1\u0002!Q\f7o['b]\u0006<WM]\"mCN\u001cX#\u000121\u0005\r,\u0007cA#IIB\u0011A*\u001a\u0003\nM\u001e\f\t\u0011!A\u0003\u00025\u00141a\u0018\u00133\u0011\u0019A\u0007\u0001)A\u0005S\u0006\tB/Y:l\u001b\u0006t\u0017mZ3s\u00072\f7o\u001d\u00111\u0005)d\u0007cA#IWB\u0011A\n\u001c\u0003\nM\u001e\f\t\u0011!A\u0003\u00025\f\"A\u00168\u0011\u0005=\u0014X\"\u00019\u000b\u0005E$\u0011a\u0003;bg.l\u0017M\\1hKJL!a\u001d9\u0003\u0017Q\u000b7o['b]\u0006<WM\u001d\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0003QiW-\\8ss\u0006\u00138\r[5wSN$8\t\\1tgV\tq\u000f\r\u0002yuB\u0019Q\tS=\u0011\u00051SHAC>}\u0003\u0003\u0005\tQ!\u0001\u0002\u0006\t\u0019q\fJ\u001a\t\ru\u0004\u0001\u0015!\u0003\u007f\u0003UiW-\\8ss\u0006\u00138\r[5wSN$8\t\\1tg\u0002\u00024a`A\u0002!\u0011)\u0005*!\u0001\u0011\u00071\u000b\u0019\u0001\u0002\u0006|y\u0006\u0005\t\u0011!B\u0001\u0003\u000b\t2AVA\u0004!\rQ\u0016\u0011B\u0005\u0004\u0003\u0017Y&aD'f[>\u0014\u00180\u0011:dQ&4\u0018n\u001d;\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0011\u0001\u0006:fg>,(oY3NC:\fw-\u001a:DY\u0006\u001c8/\u0006\u0002\u0002\u0014A\"\u0011QCA\r!\u0011)\u0005*a\u0006\u0011\u00071\u000bI\u0002\u0002\u0007\u0002\u001c\u0005u\u0011\u0011!A\u0001\u0006\u0003\tICA\u0002`IQB\u0001\"a\b\u0001A\u0003%\u0011\u0011E\u0001\u0016e\u0016\u001cx.\u001e:dK6\u000bg.Y4fe\u000ec\u0017m]:!a\u0011\t\u0019#a\n\u0011\t\u0015C\u0015Q\u0005\t\u0004\u0019\u0006\u001dB\u0001DA\u000e\u0003;\t\t\u0011!A\u0003\u0002\u0005%\u0012c\u0001,\u0002,A\"\u0011QFA\u001e!\u0019\ty#!\u000e\u0002:5\u0011\u0011\u0011\u0007\u0006\u0004\u0003g!\u0011\u0001E2mkN$XM\u001d4sC6,wo\u001c:l\u0013\u0011\t9$!\r\u0003)\u0019c\u0017N\\6SKN|WO]2f\u001b\u0006t\u0017mZ3s!\ra\u00151\b\u0003\r\u0003{\ty$!A\u0001\u0002\u000b\u0005\u0011\u0011\t\u0002\u0004?\u0012*D\u0001DA\u000e\u0003;\t\t1!A\u0003\u0002\u0005%\u0012c\u0001,\u0002DA!\u0011QIA&\u001b\t\t9E\u0003\u0003\u0002J\u0005E\u0012!\u0002;za\u0016\u001c\u0018\u0002BA'\u0003\u000f\u0012QCU3t_V\u00148-Z%E%\u0016$(/[3wC\ndW\rC\u0004\u0002R\u0001!\t%a\u0015\u0002\u001fM$\u0018M\u001d;K_\nl\u0015M\\1hKJ$b!!\u0016\u0002f\u0005=\u0004\u0003BA,\u0003Cj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0006C\u000e$xN\u001d\u0006\u0003\u0003?\nA!Y6lC&!\u00111MA-\u0005!\t5\r^8s%\u00164\u0007\u0002CA4\u0003\u001f\u0002\r!!\u001b\u0002\u000b%tG-\u001a=\u0011\u0007\u001d\nY'C\u0002\u0002n!\u00121!\u00138u\u0011!\t\t(a\u0014A\u0002\u0005M\u0014AB:zgR,W\u000e\u0005\u0003\u0002X\u0005U\u0014\u0002BA<\u00033\u00121\"Q2u_J\u001c\u0016p\u001d;f[\"9\u00111\u0010\u0001\u0005B\u0005u\u0014\u0001F:uCJ$(+Z:pkJ\u001cW-T1oC\u001e,'\u000f\u0006\u0004\u0002V\u0005}\u0014\u0011\u0011\u0005\t\u0003O\nI\b1\u0001\u0002j!A\u0011\u0011OA=\u0001\u0004\t\u0019\bC\u0004\u0002\u0006\u0002!\t%a\"\u0002!M$\u0018M\u001d;UCN\\W*\u00198bO\u0016\u0014HCBA+\u0003\u0013\u000bY\t\u0003\u0005\u0002h\u0005\r\u0005\u0019AA5\u0011!\t\t(a!A\u0002\u0005M\u0004bBAH\u0001\u0011\u0005\u0011\u0011S\u0001\u0010O\u0016$\u0018I]2iSZ,\u0007K]8qgRA\u00111SAM\u0003O\u000bY\u000b\u0005\u0003\u0002X\u0005U\u0015\u0002BAL\u00033\u0012Q\u0001\u0015:paND\u0001\"a'\u0002\u000e\u0002\u0007\u0011QT\u0001\rCJ\u001c\u0007.\u001b<f\u00072\f7o\u001d\u0019\u0005\u0003?\u000b\u0019\u000b\u0005\u0003F\u0011\u0006\u0005\u0006c\u0001'\u0002$\u0012a\u0011QUAM\u0003\u0003\u0005\tQ!\u0001\u0002\u0006\t\u0019q\f\n\u001c\t\u0011\u0005%\u0016Q\u0012a\u0001\u0003S\nA\"\u0019:dQ&4XmQ8v]RD\u0001\"!,\u0002\u000e\u0002\u0007\u0011qV\u0001\u000bCJD\u0017N^3QCRD\u0007#B\u0014\u00022\u0006U\u0016bAAZQ\t1q\n\u001d;j_:\u0004B!a.\u0002B6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,\u0001\u0002gg*\u0019\u0011q\u0018\u0004\u0002\t\r|'/Z\u0005\u0005\u0003\u0007\fIL\u0001\u0003QCRD\u0007bBAd\u0001\u0011\u0005\u0011\u0011Z\u0001\u0013O\u0016$(j\u001c2NC:\fw-\u001a:Qe>\u00048\u000f\u0006\u0011\u0002\u0014\u0006-\u0017q[Am\u0003c\fYPa\u0003\u0003\u001a\t5\"\u0011\u0007B#\u0005/\u00129G!\u001d\u0003\u0002\n\u0015\u0005bB!\u0002F\u0002\u0007\u0011Q\u001a\u0019\u0005\u0003\u001f\f\u0019\u000e\u0005\u0003F\u0011\u0006E\u0007c\u0001'\u0002T\u0012Y\u0011Q[Af\u0003\u0003\u0005\tQ!\u0001V\u0005\ryFe\u000e\u0005\u0007/\u0005\u0015\u0007\u0019\u0001\u000b\t\u0011\u0005m\u0017Q\u0019a\u0001\u0003;\faBZ;ukJ,W\t_3dkR|'\u000f\u0005\u0003\u0002`\u00065XBAAq\u0015\u0011\t\u0019/!:\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002h\u0006%\u0018\u0001B;uS2T!!a;\u0002\t)\fg/Y\u0005\u0005\u0003_\f\tO\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016D\u0001\"a=\u0002F\u0002\u0007\u0011Q_\u0001\u000bS>,\u00050Z2vi>\u0014\b\u0003BAp\u0003oLA!!?\u0002b\nAQ\t_3dkR|'\u000f\u0003\u0005\u0002~\u0006\u0015\u0007\u0019AA\u0000\u0003=Ign\u001d;b]\u000e,W*\u00198bO\u0016\u0014\b\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\u0007\t\u0015A!\u0001\u0005j]N$\u0018M\\2f\u0013\u0011\u0011IAa\u0001\u0003\u001f%s7\u000f^1oG\u0016l\u0015M\\1hKJD\u0001B!\u0004\u0002F\u0002\u0007!qB\u0001\ng\u000eDW\rZ;mKJ\u0004BA!\u0005\u0003\u00165\u0011!1\u0003\u0006\u0004\u0005\u001bY\u0016\u0002\u0002B\f\u0005'\u0011\u0011bU2iK\u0012,H.\u001a:\t\u0011\tm\u0011Q\u0019a\u0001\u0005;\t1\u0003\\5ce\u0006\u0014\u0018pQ1dQ\u0016l\u0015M\\1hKJ\u0004BAa\b\u0003*5\u0011!\u0011\u0005\u0006\u0005\u0005G\u0011)#\u0001\u0007mS\n\u0014\u0018M]=dC\u000eDWMC\u0002\u0003(\u0011\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\t-\"\u0011\u0005\u0002\u0018\u00052|'\rT5ce\u0006\u0014\u0018pQ1dQ\u0016l\u0015M\\1hKJD\u0001Ba\f\u0002F\u0002\u0007\u0011QK\u0001\bCJ\u001c\u0007.\u001b<f\u0011!\u0011\u0019$!2A\u0002\tU\u0012A\u0006:fgR\f'\u000f^*ue\u0006$XmZ=GC\u000e$xN]=\u0011\t\t]\"\u0011I\u0007\u0003\u0005sQAAa\u000f\u0003>\u00059!/Z:uCJ$(b\u0001B \t\u0005qQ\r_3dkRLwN\\4sCBD\u0017\u0002\u0002B\"\u0005s\u0011aCU3ti\u0006\u0014Ho\u0015;sCR,w-\u001f$bGR|'/\u001f\u0005\t\u0005\u000f\n)\r1\u0001\u0003J\u00059A/[7f_V$\b\u0003\u0002B&\u0005'j!A!\u0014\u000b\t\t=#\u0011K\u0001\tIV\u0014\u0018\r^5p]*\u0019\u00111\u001d\u0015\n\t\tU#Q\n\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011!\u0011I&!2A\u0002\tm\u0013!\u00067fC\u0012,'/\u00127fGRLwN\\*feZL7-\u001a\t\u0005\u0005;\u0012\u0019'\u0004\u0002\u0003`)\u0019!\u0011\r\u0003\u0002\u001d1,\u0017\rZ3sK2,7\r^5p]&!!Q\rB0\u0005UaU-\u00193fe\u0016cWm\u0019;j_:\u001cVM\u001d<jG\u0016D\u0001B!\u001b\u0002F\u0002\u0007!1N\u0001\u0017gV\u0014W.\u001b;uK\u0012TuNY$sCBD7\u000b^8sKB\u0019!L!\u001c\n\u0007\t=4L\u0001\fTk\nl\u0017\u000e\u001e;fI*{'m\u0012:ba\"\u001cFo\u001c:f\u0011!\u0011\u0019(!2A\u0002\tU\u0014!G2iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef4\u0015m\u0019;pef\u0004BAa\u001e\u0003~5\u0011!\u0011\u0010\u0006\u0004\u0005w\"\u0011AC2iK\u000e\\\u0007o\\5oi&!!q\u0010B=\u0005e\u0019\u0005.Z2la>Lg\u000e\u001e*fG>4XM]=GC\u000e$xN]=\t\u0011\t\r\u0015Q\u0019a\u0001\u0005\u0013\n!C[8c%\u0016\u001cwN^3ssRKW.Z8vi\"A!qQAc\u0001\u0004\u0011I)A\bnKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z!\u00159\u0013\u0011\u0017BF!\u0011\u0011iIa%\u000e\u0005\t=%b\u0001BI\t\u00059Q.\u001a;sS\u000e\u001c\u0018\u0002\u0002BK\u0005\u001f\u0013a\"T3ue&\u001c'+Z4jgR\u0014\u0018\u0010C\u0004\u0003\u001a\u0002!\tAa'\u0002'\u001d,G\u000fV1tW6\u000bg.Y4feB\u0013x\u000e]:\u0015%\u0005M%Q\u0014BU\u0005s\u0013\u0019M!4\u0003^\nU8Q\u0001\u0005\bA\n]\u0005\u0019\u0001BPa\u0011\u0011\tK!*\u0011\t\u0015C%1\u0015\t\u0004\u0019\n\u0015Fa\u0003BT\u0005;\u000b\t\u0011!A\u0003\u00025\u00141a\u0018\u00139\u0011!\u0011YKa&A\u0002\t5\u0016!\u0005;bg.l\u0015M\\1hKJ\u001cuN\u001c4jOB!!q\u0016B[\u001b\t\u0011\tLC\u0002\u00034\u0012\tA\u0002^1tW\u0016DXmY;u_JLAAa.\u00032\nAB+Y:l\u001b\u0006t\u0017mZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0011\tm&q\u0013a\u0001\u0005{\u000b!B]3t_V\u00148-Z%E!\u0011\t)Ea0\n\t\t\u0005\u0017q\t\u0002\u000b%\u0016\u001cx.\u001e:dK&#\u0005\u0002\u0003Bc\u0005/\u0003\rAa2\u0002'Q\f7o['b]\u0006<WM\u001d'pG\u0006$\u0018n\u001c8\u0011\u0007=\u0014I-C\u0002\u0003LB\u00141\u0003V1tW6\u000bg.Y4fe2{7-\u0019;j_:D\u0001Ba4\u0003\u0018\u0002\u0007!\u0011[\u0001\u000e[\u0016lwN]=NC:\fw-\u001a:\u0011\t\tM'\u0011\\\u0007\u0003\u0005+T1Aa6\u0005\u0003\u0019iW-\\8ss&!!1\u001cBk\u00055iU-\\8ss6\u000bg.Y4fe\"A!q\u001cBL\u0001\u0004\u0011\t/A\u0005j_6\u000bg.Y4feB!!1\u001dBy\u001b\t\u0011)O\u0003\u0003\u0003h\n%\u0018!C5p[\u0006t\u0017mZ3s\u0015\u0011\u0011YO!<\u0002\t\u0011L7o\u001b\u0006\u0004\u0005_$\u0011AA5p\u0013\u0011\u0011\u0019P!:\u0003\u0013%{U*\u00198bO\u0016\u0014\b\u0002\u0003B|\u0005/\u0003\rA!?\u0002%9,Go^8sW\u0016sg/\u001b:p]6,g\u000e\u001e\t\u0005\u0005w\u001c\t!\u0004\u0002\u0003~*!!q Bw\u0003\u001dqW\r^<pe.LAaa\u0001\u0003~\n\u0011b*\u001a;x_J\\WI\u001c<je>tW.\u001a8u\u0011!\u00119Ia&A\u0002\t-\u0005bBB\u0005\u0001\u0011\u000511B\u0001\u0018O\u0016$(+Z:pkJ\u001cW-T1oC\u001e,'\u000f\u0015:paN$\u0002\"a%\u0004\u000e\r\u001d2\u0011\u0006\u0005\t\u0003\u001f\u00199\u00011\u0001\u0004\u0010A\"1\u0011CB\u000b!\u0011)\u0005ja\u0005\u0011\u00071\u001b)\u0002\u0002\u0007\u0004\u0018\r5\u0011\u0011!A\u0001\u0006\u0003\u0019IBA\u0002`Ie\n2AVB\u000ea\u0011\u0019ib!\t\u0011\r\u0005=\u0012QGB\u0010!\ra5\u0011\u0005\u0003\r\u0007G\u0019)#!A\u0001\u0002\u000b\u0005\u0011\u0011\t\u0002\u0005?\u0012\n\u0004\u0007\u0002\u0007\u0004\u0018\r5\u0011\u0011aA\u0001\u0006\u0003\u0019I\u0002\u0003\u0004\u0018\u0007\u000f\u0001\r\u0001\u0006\u0005\t\u0007W\u00199\u00011\u0001\u0004.\u00051B.Z1eKJ\u0014V\r\u001e:jKZ\fGnU3sm&\u001cW\r\u0005\u0003\u00040\rURBAB\u0019\u0015\r\u0019\u0019\u0004B\u0001\u0010Y\u0016\fG-\u001a:sKR\u0014\u0018.\u001a<bY&!1qGB\u0019\u0005YaU-\u00193feJ+GO]5fm\u0006d7+\u001a:wS\u000e,\u0007bBB\u001e\u0001\u0011\u00051QH\u0001\u001aS:LG/[1mSj,\u0017j\u0014$pe6\fGo\u00117bgN,7\u000f\u0006\u0003\u0004@\r\u0015\u0003cA\u0014\u0004B%\u001911\t\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0007/\re\u0002\u0019\u0001\u000b\t\u000f\r%\u0003\u0001\"\u0001\u0004L\u0005I1/\u001a;NK6|'/\u001f\u000b\u0005\u0007\u007f\u0019i\u0005C\u0004\u0004P\r\u001d\u0003\u0019\u0001\u000b\u0002\r\r|gNZ5h\u0011\u001d\u0019\u0019\u0006\u0001C\u0001\u0007+\n\u0001cZ3u\t\u00164\u0017-\u001e7u\u0007>tg-[4\u0016\u0003QAqa!\u0017\u0001\t#\u0019Y&A\thKRTuNY'b]\u0006<WM\u001d(b[\u0016$Ba!\u0018\u0004dA\u0019Qia\u0018\n\u0007\r\u0005$J\u0001\u0004TiJLgn\u001a\u0005\t\u0003O\u001a9\u00061\u0001\u0002j!91q\r\u0001\u0005\u0012\r%\u0014AF4fiJ+7o\\;sG\u0016l\u0015M\\1hKJt\u0015-\\3\u0015\t\ru31\u000e\u0005\t\u0003O\u001a)\u00071\u0001\u0002j!91q\u000e\u0001\u0005\u0012\rE\u0014AD4fi\u0006\u00138\r[5wK:\u000bW.\u001a\u000b\u0005\u0007;\u001a\u0019\b\u0003\u0005\u0002h\r5\u0004\u0019AA5\u0011\u001d\u00199\b\u0001C\u0001\u0007s\nAcY;se\u0016tG\u000f\\=Sk:t\u0017N\\4K_\n\u001cXCAB>!\u0019\u0019ih!$\u0004\u0014:!1qPBE\u001d\u0011\u0019\tia\"\u000e\u0005\r\r%bABC\u0019\u00051AH]8pizJ\u0011!K\u0005\u0004\u0007\u0017C\u0013a\u00029bG.\fw-Z\u0005\u0005\u0007\u001f\u001b\tJ\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0019Y\t\u000b\t\u0005\u0007+\u001by*\u0004\u0002\u0004\u0018*!1\u0011TBN\u0003\u0019\u0019w.\\7p]*\u00191Q\u0014\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0004\"\u000e]%!\u0002&pE&#\u0005bBBS\u0001\u0011\u00051qU\u0001\u001cO\u0016$8)\u001e:sK:$H.\u001f*v]:Lgn\u001a&pENT\u0015M^1\u0015\u0005\r%\u0006CBBV\u0007[\u001b\u0019*\u0004\u0002\u0002f&!1qVAs\u0005\u0011a\u0015n\u001d;\t\u000f\rM\u0006\u0001\"\u0001\u00046\u000691\u000f^8q\u0015>\u0014G\u0003BB \u0007oC\u0001b!/\u00042\u0002\u000711S\u0001\u0003S\u0012\u0004")
public class LocalFlinkMiniCluster
extends FlinkMiniCluster {
    private final Class<? extends JobManager> jobManagerClass = JobManager.class;
    private final Class<? extends TaskManager> taskManagerClass = TaskManager.class;
    private final Class<? extends MemoryArchivist> memoryArchivistClass = MemoryArchivist.class;
    private final Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass = StandaloneResourceManager.class;

    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration generateConfiguration(Configuration userConfiguration) {
        void var2_2;
        Configuration config = this.getDefaultConfig();
        this.setDefaultCiConfig(config);
        config.addAll(userConfiguration);
        this.setMemory(config);
        this.initializeIOFormatClasses(config);
        if (!config.containsKey(QueryableStateOptions.SERVER_ENABLE.key())) {
            this.LOG().info("Disabled queryable state server");
            config.setBoolean(QueryableStateOptions.SERVER_ENABLE, false);
        }
        return var2_2;
    }

    public Class<? extends JobManager> jobManagerClass() {
        return this.jobManagerClass;
    }

    public Class<? extends TaskManager> taskManagerClass() {
        return this.taskManagerClass;
    }

    public Class<? extends MemoryArchivist> memoryArchivistClass() {
        return this.memoryArchivistClass;
    }

    public Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass() {
        return this.resourceManagerClass;
    }

    @Override
    public ActorRef startJobManager(int index, ActorSystem system) {
        Tuple9<InstanceManager, Scheduler, BlobLibraryCacheManager, RestartStrategyFactory, FiniteDuration, Object, Option<Path>, FiniteDuration, Option<MetricRegistry>> tuple9;
        Configuration config = this.originalConfiguration().clone();
        String jobManagerName = this.getJobManagerName(index);
        String archiveName = this.getArchiveName(index);
        int jobManagerPort = config.getInteger("jobmanager.rpc.port", 6123);
        if (jobManagerPort > 0) {
            config.setInteger("jobmanager.rpc.port", jobManagerPort + index);
        }
        if ((tuple9 = JobManager$.MODULE$.createJobManagerComponents(config, this.futureExecutor(), this.ioExecutor(), super.highAvailabilityServices().createBlobStore())) != null) {
            Tuple9 tuple92;
            InstanceManager instanceManager = (InstanceManager)tuple9._1();
            Scheduler scheduler = (Scheduler)tuple9._2();
            BlobLibraryCacheManager libraryCacheManager = (BlobLibraryCacheManager)tuple9._3();
            RestartStrategyFactory restartStrategyFactory = (RestartStrategyFactory)tuple9._4();
            FiniteDuration timeout = (FiniteDuration)tuple9._5();
            int archiveCount = BoxesRunTime.unboxToInt((Object)tuple9._6());
            Option archivePath = (Option)tuple9._7();
            FiniteDuration jobRecoveryTimeout = (FiniteDuration)tuple9._8();
            Option metricsRegistry = (Option)tuple9._9();
            Tuple9 tuple93 = tuple92 = new Tuple9((Object)instanceManager, (Object)scheduler, (Object)libraryCacheManager, (Object)restartStrategyFactory, (Object)timeout, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)archivePath, (Object)jobRecoveryTimeout, (Object)metricsRegistry);
            InstanceManager instanceManager2 = (InstanceManager)tuple93._1();
            Scheduler scheduler2 = (Scheduler)tuple93._2();
            BlobLibraryCacheManager libraryCacheManager2 = (BlobLibraryCacheManager)tuple93._3();
            RestartStrategyFactory restartStrategyFactory2 = (RestartStrategyFactory)tuple93._4();
            FiniteDuration timeout2 = (FiniteDuration)tuple93._5();
            int archiveCount2 = BoxesRunTime.unboxToInt((Object)tuple93._6());
            Option archivePath2 = (Option)tuple93._7();
            FiniteDuration jobRecoveryTimeout2 = (FiniteDuration)tuple93._8();
            Option metricsRegistry2 = (Option)tuple93._9();
            if (config.getBoolean("local.start-webserver", false)) {
                ((MetricRegistry)metricsRegistry2.get()).startQueryService(system, null);
            }
            ActorRef archive = system.actorOf(this.getArchiveProps(this.memoryArchivistClass(), archiveCount2, (Option<Path>)archivePath2), archiveName);
            return system.actorOf(this.getJobManagerProps(this.jobManagerClass(), config, this.futureExecutor(), this.ioExecutor(), instanceManager2, scheduler2, libraryCacheManager2, archive, restartStrategyFactory2, timeout2, super.highAvailabilityServices().getJobManagerLeaderElectionService(HighAvailabilityServices.DEFAULT_JOB_ID), super.highAvailabilityServices().getSubmittedJobGraphStore(), super.highAvailabilityServices().getCheckpointRecoveryFactory(), jobRecoveryTimeout2, (Option<MetricRegistry>)metricsRegistry2), jobManagerName);
        }
        throw new MatchError(tuple9);
    }

    @Override
    public ActorRef startResourceManager(int index, ActorSystem system) {
        Configuration config = this.originalConfiguration().clone();
        String resourceManagerName = this.getResourceManagerName(index);
        int resourceManagerPort = config.getInteger("resourcemanager.rpc.port", 0);
        if (resourceManagerPort > 0) {
            config.setInteger("resourcemanager.rpc.port", resourceManagerPort + index);
        }
        Props resourceManagerProps = this.getResourceManagerProps(this.resourceManagerClass(), config, super.highAvailabilityServices().getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID));
        return system.actorOf(resourceManagerProps, resourceManagerName);
    }

    @Override
    public ActorRef startTaskManager(int index, ActorSystem system) {
        Configuration config = this.originalConfiguration().clone();
        int rpcPort = config.getInteger("taskmanager.rpc.port", 0);
        int dataPort = config.getInteger("taskmanager.data.port", 0);
        if (rpcPort > 0) {
            config.setInteger("taskmanager.rpc.port", rpcPort + index);
        }
        if (dataPort > 0) {
            config.setInteger("taskmanager.data.port", dataPort + index);
        }
        boolean localExecution = this.numTaskManagers() == 1;
        String taskManagerActorName = super.useSingleActorSystem() ? new StringBuilder().append((Object)TaskExecutor.TASK_MANAGER_NAME).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : TaskExecutor.TASK_MANAGER_NAME;
        ResourceID resourceID = ResourceID.generate();
        InetAddress taskManagerAddress = InetAddress.getByName(this.hostname());
        TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(config);
        TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(config, taskManagerAddress, localExecution);
        TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, resourceID);
        MetricRegistry metricRegistry = taskManagerServices.getMetricRegistry();
        Props props = this.getTaskManagerProps(this.taskManagerClass(), taskManagerConfiguration, resourceID, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getMemoryManager(), taskManagerServices.getIOManager(), taskManagerServices.getNetworkEnvironment(), metricRegistry);
        if (config.getBoolean("local.start-webserver", false)) {
            metricRegistry.startQueryService(system, resourceID);
        }
        return system.actorOf(props, taskManagerActorName);
    }

    public Props getArchiveProps(Class<? extends MemoryArchivist> archiveClass, int archiveCount, Option<Path> arhivePath) {
        return JobManager$.MODULE$.getArchiveProps(archiveClass, archiveCount, (Option<Path>)Option$.MODULE$.empty());
    }

    public Props getJobManagerProps(Class<? extends JobManager> jobManagerClass, Configuration configuration, ScheduledExecutorService futureExecutor, Executor ioExecutor, InstanceManager instanceManager, Scheduler scheduler, BlobLibraryCacheManager libraryCacheManager, ActorRef archive, RestartStrategyFactory restartStrategyFactory, FiniteDuration timeout, LeaderElectionService leaderElectionService, SubmittedJobGraphStore submittedJobGraphStore, CheckpointRecoveryFactory checkpointRecoveryFactory, FiniteDuration jobRecoveryTimeout, Option<MetricRegistry> metricsRegistry) {
        return JobManager$.MODULE$.getJobManagerProps(jobManagerClass, configuration, futureExecutor, ioExecutor, instanceManager, scheduler, libraryCacheManager, archive, restartStrategyFactory, timeout, leaderElectionService, submittedJobGraphStore, checkpointRecoveryFactory, jobRecoveryTimeout, metricsRegistry);
    }

    public Props getTaskManagerProps(Class<? extends TaskManager> taskManagerClass, TaskManagerConfiguration taskManagerConfig, ResourceID resourceID, TaskManagerLocation taskManagerLocation, MemoryManager memoryManager, IOManager ioManager, NetworkEnvironment networkEnvironment, MetricRegistry metricsRegistry) {
        return TaskManager$.MODULE$.getTaskManagerProps(taskManagerClass, taskManagerConfig, resourceID, taskManagerLocation, memoryManager, ioManager, networkEnvironment, super.highAvailabilityServices(), metricsRegistry);
    }

    public Props getResourceManagerProps(Class<? extends FlinkResourceManager<? extends ResourceIDRetrievable>> resourceManagerClass, Configuration configuration, LeaderRetrievalService leaderRetrievalService) {
        return FlinkResourceManager.getResourceManagerProps(resourceManagerClass, configuration, leaderRetrievalService);
    }

    public void initializeIOFormatClasses(Configuration configuration) {
        try {
            Method om = FileOutputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", Configuration.class);
            om.setAccessible(true);
            om.invoke(null, configuration);
        }
        catch (Exception exception) {
            this.LOG().error("Cannot (re) initialize the globally loaded defaults. Some classes might not follow the specified default behaviour.");
        }
    }

    public void setMemory(Configuration config) {
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)config.getLong(TaskManagerOptions.MANAGED_MEMORY_SIZE)), (Object)TaskManagerOptions.MANAGED_MEMORY_SIZE.defaultValue())) {
            int numTaskManager = config.getInteger("local.number-taskmanager", 1);
            float memoryFraction = config.getFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION);
            long memorySize = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            memorySize /= (long)(numTaskManager + 1);
            memorySize -= TaskManagerServices.calculateNetworkBufferMemory(memorySize, config);
            memorySize = (long)((double)memorySize * (double)memoryFraction);
            config.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, memorySize >>= 20);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getDefaultConfig() {
        void var1_1;
        Configuration config = new Configuration();
        config.setString("jobmanager.rpc.address", this.hostname());
        config.setInteger("jobmanager.rpc.port", 0);
        config.setInteger("local.number-taskmanager", 1);
        config.setInteger(NettyConfig.NUM_THREADS_CLIENT, 1);
        config.setInteger(NettyConfig.NUM_THREADS_SERVER, 2);
        return var1_1;
    }

    public String getJobManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)JobMaster.JOB_MANAGER_NAME).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : JobMaster.JOB_MANAGER_NAME;
    }

    public String getResourceManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)FlinkResourceManager.RESOURCE_MANAGER_NAME).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : FlinkResourceManager.RESOURCE_MANAGER_NAME;
    }

    public String getArchiveName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)JobMaster.ARCHIVE_NAME).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : JobMaster.ARCHIVE_NAME;
    }

    public Iterable<JobID> currentlyRunningJobs() {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future future = leader.ask(JobManagerMessages$RequestRunningJobsStatus$.MODULE$, this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.RunningJobsStatus.class));
        return (Iterable)((JobManagerMessages.RunningJobsStatus)Await$.MODULE$.result((Awaitable)future, (Duration)this.timeout())).runningJobs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JobID apply(JobStatusMessage x$2) {
                return x$2.getJobId();
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public List<JobID> getCurrentlyRunningJobsJava() {
        void var1_1;
        ArrayList list = new ArrayList();
        this.currentlyRunningJobs().foreach((Function1)new Serializable(this, list){
            public static final long serialVersionUID = 0L;
            private final ArrayList list$1;

            public final boolean apply(JobID x$1) {
                return this.list$1.add(x$1);
            }
            {
                this.list$1 = list$1;
            }
        });
        return var1_1;
    }

    public void stopJob(JobID id) {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future response = leader.ask(new JobManagerMessages.StopJob(id), this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.StoppingResponse.class));
        JobManagerMessages.StoppingResponse rc = (JobManagerMessages.StoppingResponse)Await$.MODULE$.result((Awaitable)response, (Duration)this.timeout());
        JobManagerMessages.StoppingResponse stoppingResponse = rc;
        if (stoppingResponse instanceof JobManagerMessages.StoppingFailure) {
            JobManagerMessages.StoppingFailure stoppingFailure = (JobManagerMessages.StoppingFailure)stoppingResponse;
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping the job with ID ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), stoppingFailure.cause());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, HighAvailabilityServices highAvailabilityServices, boolean singleActorSystem) {
        super(userConfiguration, highAvailabilityServices, singleActorSystem);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, boolean useSingleActorSystem) {
        this(userConfiguration, HighAvailabilityServicesUtils.createAvailableOrEmbeddedServices(userConfiguration, (Executor)ExecutionContext$.MODULE$.global()), useSingleActorSystem);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration) {
        this(userConfiguration, true);
    }
}

