/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import scala.concurrent.duration.FiniteDuration;

public class JobManagerServices {
    public final ScheduledExecutorService executorService;
    public final BlobLibraryCacheManager libraryCacheManager;
    public final RestartStrategyFactory restartStrategyFactory;
    public final Time rpcAskTimeout;

    public JobManagerServices(ScheduledExecutorService executorService, BlobLibraryCacheManager libraryCacheManager, RestartStrategyFactory restartStrategyFactory, Time rpcAskTimeout) {
        this.executorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.libraryCacheManager = (BlobLibraryCacheManager)Preconditions.checkNotNull((Object)libraryCacheManager);
        this.restartStrategyFactory = (RestartStrategyFactory)Preconditions.checkNotNull((Object)restartStrategyFactory);
        this.rpcAskTimeout = (Time)Preconditions.checkNotNull((Object)rpcAskTimeout);
    }

    public void shutdown() throws Exception {
        Throwable firstException = null;
        try {
            this.executorService.shutdownNow();
        }
        catch (Throwable t) {
            firstException = t;
        }
        try {
            this.libraryCacheManager.shutdown();
        }
        catch (Throwable t) {
            if (firstException == null) {
                firstException = t;
            }
            firstException.addSuppressed(t);
        }
        if (firstException != null) {
            ExceptionUtils.rethrowException((Throwable)firstException, (String)"Error while shutting down JobManager services");
        }
    }

    public static JobManagerServices fromConfiguration(Configuration config, HighAvailabilityServices haServices) throws Exception {
        FiniteDuration timeout;
        BlobServer blobServer = new BlobServer(config, haServices.createBlobStore());
        long cleanupInterval = config.getLong("library-cache-manager.cleanup.interval", 3600L) * 1000L;
        BlobLibraryCacheManager libraryCacheManager = new BlobLibraryCacheManager(blobServer, cleanupInterval);
        try {
            timeout = AkkaUtils.getTimeout(config);
        }
        catch (NumberFormatException e) {
            throw new IllegalConfigurationException(AkkaUtils.formatDurationParingErrorMessage());
        }
        ScheduledExecutorService futureExecutor = Executors.newScheduledThreadPool(Hardware.getNumberCPUCores(), new ExecutorThreadFactory("jobmanager-future"));
        return new JobManagerServices(futureExecutor, libraryCacheManager, RestartStrategyFactory.createRestartStrategyFactory(config), Time.of((long)timeout.length(), (TimeUnit)timeout.unit()));
    }
}

