/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.shared.asn1.util.Oid;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaException;
import org.apache.directory.shared.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.directory.shared.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.shared.ldap.model.schema.SchemaObject;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.model.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.SchemaObjectRegistry;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultSchemaObjectRegistry<T extends SchemaObject>
implements SchemaObjectRegistry<T>,
Iterable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaObjectRegistry.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    protected Map<String, T> byName = new HashMap<String, T>();
    protected SchemaObjectType schemaObjectType;
    protected OidRegistry<T> oidRegistry;

    protected DefaultSchemaObjectRegistry(SchemaObjectType schemaObjectType, OidRegistry<T> oidRegistry) {
        this.schemaObjectType = schemaObjectType;
        this.oidRegistry = oidRegistry;
    }

    @Override
    public boolean contains(String oid) {
        if (!this.byName.containsKey(oid)) {
            return this.byName.containsKey(Strings.toLowerCase((String)oid));
        }
        return true;
    }

    @Override
    public String getSchemaName(String oid) throws LdapException {
        if (!Oid.isOid((String)oid)) {
            String msg = I18n.err((I18n)I18n.ERR_04267, (Object[])new Object[0]);
            LOG.warn(msg);
            throw new LdapException(msg);
        }
        SchemaObject schemaObject = (SchemaObject)this.byName.get(oid);
        if (schemaObject != null) {
            return schemaObject.getSchemaName();
        }
        String msg = I18n.err((I18n)I18n.ERR_04268_OID_NOT_FOUND, (Object[])new Object[]{oid});
        LOG.warn(msg);
        throw new LdapException(msg);
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        for (SchemaObject schemaObject : this) {
            if (!originalSchemaName.equalsIgnoreCase(schemaObject.getSchemaName())) continue;
            schemaObject.setSchemaName(newSchemaName);
            if (!DEBUG) continue;
            LOG.debug("Renamed {} schemaName to {}", (Object)schemaObject, (Object)newSchemaName);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.oidRegistry.iterator();
    }

    @Override
    public Iterator<String> oidsIterator() {
        return this.byName.keySet().iterator();
    }

    @Override
    public T lookup(String oid) throws LdapException {
        if (oid == null) {
            return null;
        }
        SchemaObject schemaObject = (SchemaObject)this.byName.get(oid);
        if (schemaObject == null) {
            schemaObject = (SchemaObject)this.byName.get(Strings.trim((String)Strings.toLowerCase((String)oid)));
        }
        if (schemaObject == null) {
            String msg = I18n.err((I18n)I18n.ERR_04269, (Object[])new Object[]{this.schemaObjectType.name(), oid});
            LOG.debug(msg);
            throw new LdapException(msg);
        }
        if (DEBUG) {
            LOG.debug("Found {} with oid: {}", (Object)schemaObject, (Object)oid);
        }
        return (T)schemaObject;
    }

    @Override
    public void register(T schemaObject) throws LdapException {
        String oid = schemaObject.getOid();
        if (this.byName.containsKey(oid)) {
            String msg = I18n.err((I18n)I18n.ERR_04270, (Object[])new Object[]{this.schemaObjectType.name(), oid});
            LOG.warn(msg);
            LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.OID_ALREADY_REGISTERED, msg);
            ldapSchemaException.setSourceObject((SchemaObject)schemaObject);
            throw ldapSchemaException;
        }
        this.byName.put(oid, schemaObject);
        for (String name : schemaObject.getNames()) {
            String lowerName = Strings.trim((String)Strings.toLowerCase((String)name));
            if (this.byName.containsKey(lowerName)) {
                String msg = I18n.err((I18n)I18n.ERR_04271, (Object[])new Object[]{this.schemaObjectType.name(), name});
                LOG.warn(msg);
                LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.NAME_ALREADY_REGISTERED, msg);
                ldapSchemaException.setSourceObject((SchemaObject)schemaObject);
                throw ldapSchemaException;
            }
            this.byName.put(lowerName, schemaObject);
        }
        this.oidRegistry.register(schemaObject);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registered " + schemaObject.getName() + " for OID {}", (Object)oid);
        }
    }

    @Override
    public T unregister(String numericOid) throws LdapException {
        if (!Oid.isOid((String)numericOid)) {
            String msg = I18n.err((I18n)I18n.ERR_04272, (Object[])new Object[]{numericOid});
            LOG.error(msg);
            throw new LdapException(msg);
        }
        SchemaObject schemaObject = (SchemaObject)this.byName.remove(numericOid);
        for (String name : schemaObject.getNames()) {
            this.byName.remove(name);
        }
        this.oidRegistry.unregister(numericOid);
        if (DEBUG) {
            LOG.debug("Removed {} with oid {} from the registry", (Object)schemaObject, (Object)numericOid);
        }
        return (T)schemaObject;
    }

    @Override
    public T unregister(T schemaObject) throws LdapException {
        String oid = schemaObject.getOid();
        if (!this.byName.containsKey(oid)) {
            String msg = I18n.err((I18n)I18n.ERR_04273, (Object[])new Object[]{this.schemaObjectType.name(), oid});
            LOG.warn(msg);
            throw new LdapException(msg);
        }
        SchemaObject removed = (SchemaObject)this.byName.remove(oid);
        for (String name : schemaObject.getNames()) {
            this.byName.remove(Strings.trim((String)Strings.toLowerCase((String)name)));
        }
        this.oidRegistry.unregister(oid);
        return (T)removed;
    }

    @Override
    public void unregisterSchemaElements(String schemaName) throws LdapException {
        if (schemaName == null) {
            return;
        }
        for (SchemaObject schemaObject : this) {
            if (!schemaName.equalsIgnoreCase(schemaObject.getSchemaName())) continue;
            String oid = schemaObject.getOid();
            String removed = this.unregister((T)oid);
            if (!DEBUG) continue;
            LOG.debug("Removed {} with oid {} from the registry", (Object)removed, (Object)oid);
        }
    }

    @Override
    public String getOidByName(String name) throws LdapException {
        String lowerCased;
        SchemaObject schemaObject = (SchemaObject)this.byName.get(name);
        if (schemaObject == null && (schemaObject = (SchemaObject)this.byName.get(lowerCased = Strings.toLowerCase((String)name))) == null) {
            throw new LdapException(I18n.err((I18n)I18n.ERR_04274, (Object[])new Object[]{name}));
        }
        return schemaObject.getOid();
    }

    public SchemaObjectRegistry<T> copy(SchemaObjectRegistry<T> original) {
        for (String key : ((DefaultSchemaObjectRegistry)original).byName.keySet()) {
            SchemaObject value = (SchemaObject)((DefaultSchemaObjectRegistry)original).byName.get(key);
            if (value instanceof LoadableSchemaObject) {
                this.byName.put(key, value);
                this.oidRegistry.put(value);
                continue;
            }
            SchemaObject copiedValue = null;
            if (this.oidRegistry.contains(value.getOid())) {
                try {
                    copiedValue = this.oidRegistry.getSchemaObject(value.getOid());
                }
                catch (LdapException ne) {}
            } else {
                copiedValue = value.copy();
            }
            this.byName.put(key, copiedValue);
            this.oidRegistry.put(copiedValue);
        }
        return this;
    }

    @Override
    public T get(String oid) {
        try {
            return this.oidRegistry.getSchemaObject(oid);
        }
        catch (LdapException ne) {
            return null;
        }
    }

    @Override
    public SchemaObjectType getType() {
        return this.schemaObjectType;
    }

    @Override
    public int size() {
        return this.oidRegistry.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.schemaObjectType).append(": ");
        boolean isFirst = true;
        for (String name : this.byName.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            SchemaObject schemaObject = (SchemaObject)this.byName.get(name);
            sb.append('<').append(name).append(", ").append(schemaObject.getOid()).append('>');
        }
        return sb.toString();
    }

    @Override
    public void clear() {
        for (SchemaObject schemaObject : this.oidRegistry) {
            if (schemaObject instanceof LoadableSchemaObject) continue;
            schemaObject.clear();
        }
        this.byName.clear();
        this.oidRegistry.clear();
    }
}

