/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.registries;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectWrapper;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.StringConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSchema
implements Schema {
    protected static final String DEFAULT_OWNER = "uid=admin,ou=system";
    protected boolean disabled;
    protected String[] dependencies;
    protected String owner;
    protected String name;
    protected Set<SchemaObjectWrapper> content;

    public DefaultSchema(String name) {
        this(name, null, null, false);
    }

    public DefaultSchema(String name, String owner) {
        this(name, owner, null, false);
    }

    public DefaultSchema(String name, String owner, String[] dependencies) {
        this(name, owner, dependencies, false);
    }

    public DefaultSchema(String name, String owner, String[] dependencies, boolean disabled) {
        if (name == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04266, (Object[])new Object[0]));
        }
        this.name = name;
        this.owner = owner != null ? owner : DEFAULT_OWNER;
        if (dependencies != null) {
            this.dependencies = new String[dependencies.length];
            System.arraycopy(dependencies, 0, this.dependencies, 0, dependencies.length);
        } else {
            this.dependencies = StringConstants.EMPTY_STRINGS;
        }
        this.disabled = disabled;
        this.content = new HashSet<SchemaObjectWrapper>();
    }

    @Override
    public String[] getDependencies() {
        String[] copy = new String[this.dependencies.length];
        System.arraycopy(this.dependencies, 0, copy, 0, this.dependencies.length);
        return copy;
    }

    @Override
    public void addDependencies(String ... dependenciesToAdd) {
        if (dependenciesToAdd != null) {
            int start = 0;
            if (this.dependencies == null) {
                this.dependencies = new String[dependenciesToAdd.length];
            } else {
                String[] tempDependencies = new String[this.dependencies.length + dependenciesToAdd.length];
                System.arraycopy(this.dependencies, 0, tempDependencies, 0, this.dependencies.length);
                start = this.dependencies.length;
                this.dependencies = tempDependencies;
            }
            System.arraycopy(dependenciesToAdd, 0, this.dependencies, start, dependenciesToAdd.length);
        }
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getSchemaName() {
        return this.name;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isEnabled() {
        return !this.disabled;
    }

    @Override
    public void disable() {
        this.disabled = true;
    }

    @Override
    public void enable() {
        this.disabled = false;
    }

    @Override
    public Set<SchemaObjectWrapper> getContent() {
        return this.content;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\tSchema Name: ");
        sb.append(this.name);
        sb.append("\n\t\tDisabled: ");
        sb.append(this.disabled);
        sb.append("\n\t\tOwner: ");
        sb.append(this.owner);
        sb.append("\n\t\tDependencies: ");
        sb.append(Arrays.toString(this.dependencies));
        return sb.toString();
    }
}

