/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.model.schema.registries.DefaultSchemaObjectRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.OidRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectClassRegistry
extends DefaultSchemaObjectRegistry<ObjectClass>
implements ObjectClassRegistry {
    private Map<String, Set<ObjectClass>> oidToDescendants = new HashMap<String, Set<ObjectClass>>();

    public DefaultObjectClassRegistry() {
        super(SchemaObjectType.OBJECT_CLASS, new OidRegistry());
    }

    @Override
    public boolean hasDescendants(String ancestorId) throws LdapException {
        try {
            String oid = this.getOidByName(ancestorId);
            Set<ObjectClass> descendants = this.oidToDescendants.get(oid);
            return descendants != null && !descendants.isEmpty();
        }
        catch (LdapException ne) {
            throw new LdapNoSuchAttributeException(ne.getMessage(), ne);
        }
    }

    @Override
    public Iterator<ObjectClass> descendants(String ancestorId) throws LdapException {
        try {
            String oid = this.getOidByName(ancestorId);
            Set<ObjectClass> descendants = this.oidToDescendants.get(oid);
            if (descendants == null) {
                return Collections.EMPTY_SET.iterator();
            }
            return descendants.iterator();
        }
        catch (LdapException ne) {
            throw new LdapNoSuchAttributeException(ne.getMessage(), ne);
        }
    }

    @Override
    public void registerDescendants(ObjectClass objectClass, List<ObjectClass> ancestors) throws LdapException {
        if (ancestors == null || ancestors.size() == 0) {
            return;
        }
        for (ObjectClass ancestor : ancestors) {
            Set<ObjectClass> descendants = this.oidToDescendants.get(ancestor.getOid());
            if (descendants == null) {
                descendants = new HashSet<ObjectClass>(1);
                this.oidToDescendants.put(ancestor.getOid(), descendants);
            }
            descendants.add(objectClass);
            try {
                this.registerDescendants(objectClass, ancestor.getSuperiors());
            }
            catch (LdapException ne) {
                throw new LdapNoSuchAttributeException(ne.getMessage(), ne);
            }
        }
    }

    @Override
    public void unregisterDescendants(ObjectClass attributeType, List<ObjectClass> ancestors) throws LdapException {
        if (ancestors == null || ancestors.size() == 0) {
            return;
        }
        for (ObjectClass ancestor : ancestors) {
            Set<ObjectClass> descendants = this.oidToDescendants.get(ancestor.getOid());
            if (descendants != null) {
                descendants.remove(attributeType);
                if (descendants.size() == 0) {
                    this.oidToDescendants.remove(ancestor.getOid());
                }
            }
            try {
                this.unregisterDescendants(attributeType, ancestor.getSuperiors());
            }
            catch (LdapException ne) {
                throw new LdapNoSuchAttributeException(ne.getMessage(), ne);
            }
        }
    }

    @Override
    public ObjectClass unregister(String numericOid) throws LdapException {
        try {
            ObjectClass removed = (ObjectClass)((Object)super.unregister(numericOid));
            this.oidToDescendants.remove(numericOid);
            this.unregisterDescendants(removed, removed.getSuperiors());
            return removed;
        }
        catch (LdapException ne) {
            throw new LdapNoSuchAttributeException(ne.getMessage(), ne);
        }
    }

    @Override
    public DefaultObjectClassRegistry copy() {
        DefaultObjectClassRegistry copy = new DefaultObjectClassRegistry();
        copy.copy(this);
        return copy;
    }

    @Override
    public void clear() {
        for (ObjectClass objectClass : this.oidRegistry) {
            objectClass.clear();
        }
        super.clear();
        for (String oid : this.oidToDescendants.keySet()) {
            Set<ObjectClass> descendants = this.oidToDescendants.get(oid);
            if (descendants == null) continue;
            descendants.clear();
        }
        this.oidToDescendants.clear();
    }
}

