/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema;

import java.io.IOException;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.exception.InvalidCharacterException;

public final class PrepareString {
    private static final boolean CASE_SENSITIVE = true;
    private static final boolean IGNORE_CASE = false;
    private static final char[][] COMBINING_MARKS = new char[][]{{'\u0300', '\u034f'}, {'\u0360', '\u036f'}, {'\u0483', '\u0486'}, {'\u0488', '\u0489'}, {'\u0591', '\u05a1'}, {'\u05a3', '\u05b9'}, {'\u05bb', '\u05bc'}, {'\u05bf', '\u05bf'}, {'\u05c1', '\u05c2'}, {'\u05c4', '\u05c4'}, {'\u064b', '\u0655'}, {'\u0670', '\u0670'}, {'\u06d6', '\u06dc'}, {'\u06de', '\u06e4'}, {'\u06e7', '\u06e8'}, {'\u06ea', '\u06ed'}, {'\u0711', '\u0711'}, {'\u0730', '\u074a'}, {'\u07a6', '\u07b0'}, {'\u0901', '\u0903'}, {'\u093c', '\u093c'}, {'\u093e', '\u094f'}, {'\u0951', '\u0954'}, {'\u0962', '\u0963'}, {'\u0981', '\u0983'}, {'\u09bc', '\u09bc'}, {'\u09be', '\u09c4'}, {'\u09c7', '\u09c8'}, {'\u09cb', '\u09cd'}, {'\u09d7', '\u09d7'}, {'\u09e2', '\u09e3'}, {'\u0a02', '\u0a02'}, {'\u0a3c', '\u0a3c'}, {'\u0a3e', '\u0a42'}, {'\u0a47', '\u0a48'}, {'\u0a4b', '\u0a4d'}, {'\u0a70', '\u0a71'}, {'\u0a81', '\u0a83'}, {'\u0abc', '\u0abc'}, {'\u0abe', '\u0ac5'}, {'\u0ac7', '\u0ac9'}, {'\u0acb', '\u0acd'}, {'\u0b01', '\u0b03'}, {'\u0b3c', '\u0b3c'}, {'\u0b3e', '\u0b43'}, {'\u0b47', '\u0b48'}, {'\u0b4b', '\u0b4d'}, {'\u0b56', '\u0b57'}, {'\u0b82', '\u0b82'}, {'\u0bbe', '\u0bc2'}, {'\u0bc6', '\u0bc8'}, {'\u0bca', '\u0bcd'}, {'\u0bd7', '\u0bd7'}, {'\u0c01', '\u0c03'}, {'\u0c3e', '\u0c44'}, {'\u0c46', '\u0c48'}, {'\u0c4a', '\u0c4d'}, {'\u0c55', '\u0c56'}, {'\u0c82', '\u0c83'}, {'\u0cbe', '\u0cc4'}, {'\u0cc6', '\u0cc8'}, {'\u0cca', '\u0ccd'}, {'\u0cd5', '\u0cd6'}, {'\u0d02', '\u0d03'}, {'\u0d3e', '\u0d43'}, {'\u0d46', '\u0d48'}, {'\u0d4a', '\u0d4d'}, {'\u0d57', '\u0d57'}, {'\u0d82', '\u0d83'}, {'\u0dca', '\u0dca'}, {'\u0dcf', '\u0dd4'}, {'\u0dd6', '\u0dd6'}, {'\u0dd8', '\u0ddf'}, {'\u0df2', '\u0df3'}, {'\u0e31', '\u0e31'}, {'\u0e34', '\u0e3a'}, {'\u0e47', '\u0e4e'}, {'\u0eb1', '\u0eb1'}, {'\u0eb4', '\u0eb9'}, {'\u0ebb', '\u0ebc'}, {'\u0ec8', '\u0ecd'}, {'\u0f18', '\u0f19'}, {'\u0f35', '\u0f35'}, {'\u0f37', '\u0f37'}, {'\u0f39', '\u0f39'}, {'\u0f3e', '\u0f3f'}, {'\u0f71', '\u0f84'}, {'\u0f86', '\u0f87'}, {'\u0f90', '\u0f97'}, {'\u0f99', '\u0fbc'}, {'\u0fc6', '\u0fc6'}, {'\u102c', '\u1032'}, {'\u1036', '\u1039'}, {'\u1056', '\u1059'}, {'\u1712', '\u1714'}, {'\u1732', '\u1734'}, {'\u1752', '\u1753'}, {'\u1772', '\u1773'}, {'\u17b4', '\u17d3'}, {'\u180b', '\u180d'}, {'\u18a9', '\u18a9'}, {'\u20d0', '\u20ea'}, {'\u302a', '\u302f'}, {'\u3099', '\u309a'}, {'\ufb1e', '\ufb1e'}, {'\ufe00', '\ufe0f'}, {'\ufe20', '\ufe23'}};

    private PrepareString() {
    }

    private static boolean isCombiningMark(char c) {
        if (c < COMBINING_MARKS[0][0]) {
            return false;
        }
        for (char[] interval : COMBINING_MARKS) {
            if (c < interval[0] || c > interval[1]) continue;
            return true;
        }
        return false;
    }

    public static String normalize(String str, StringType type) throws IOException {
        switch (type) {
            case NUMERIC_STRING: {
                return PrepareString.insignifiantCharNumericString(str);
            }
            case TELEPHONE_NUMBER: {
                return PrepareString.insignifiantCharTelephoneNumber(str);
            }
            case CASE_EXACT: 
            case CASE_EXACT_IA5: 
            case DIRECTORY_STRING: {
                return PrepareString.insignifiantSpacesString(str, true);
            }
            case CASE_IGNORE_IA5: 
            case CASE_IGNORE_LIST: 
            case CASE_IGNORE: {
                return PrepareString.insignifiantSpacesString(str, false);
            }
            case WORD: {
                return str;
            }
        }
        return str;
    }

    private static int map(char c, char[] target, int pos, char lowerCase) {
        int start = pos;
        switch (c) {
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\b': {
                break;
            }
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': {
                target[pos++] = 32;
                break;
            }
            case '\u000e': 
            case '\u000f': 
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': {
                target[pos++] = (char)(c | lowerCase);
                break;
            }
            case '\u007f': 
            case '\u0080': 
            case '\u0081': 
            case '\u0082': 
            case '\u0083': 
            case '\u0084': {
                break;
            }
            case '\u0085': {
                target[pos++] = 32;
                break;
            }
            case '\u0086': 
            case '\u0087': 
            case '\u0088': 
            case '\u0089': 
            case '\u008a': 
            case '\u008b': 
            case '\u008c': 
            case '\u008d': 
            case '\u008e': 
            case '\u008f': 
            case '\u0090': 
            case '\u0091': 
            case '\u0092': 
            case '\u0093': 
            case '\u0094': 
            case '\u0095': 
            case '\u0096': 
            case '\u0097': 
            case '\u0098': 
            case '\u0099': 
            case '\u009a': 
            case '\u009b': 
            case '\u009c': 
            case '\u009d': 
            case '\u009e': 
            case '\u009f': {
                break;
            }
            case '\u00a0': {
                target[pos++] = 32;
                break;
            }
            case '\u00ad': {
                break;
            }
            case '\u00b5': {
                target[pos++] = 956;
                break;
            }
            case '\u00c0': 
            case '\u00c1': 
            case '\u00c2': 
            case '\u00c3': 
            case '\u00c4': 
            case '\u00c5': 
            case '\u00c6': 
            case '\u00c7': 
            case '\u00c8': 
            case '\u00c9': 
            case '\u00ca': 
            case '\u00cb': 
            case '\u00cc': 
            case '\u00cd': 
            case '\u00ce': 
            case '\u00cf': 
            case '\u00d0': 
            case '\u00d1': 
            case '\u00d2': 
            case '\u00d3': 
            case '\u00d4': 
            case '\u00d5': 
            case '\u00d6': 
            case '\u00d8': 
            case '\u00d9': 
            case '\u00da': 
            case '\u00db': 
            case '\u00dc': 
            case '\u00dd': 
            case '\u00de': {
                target[pos++] = (char)(c | lowerCase);
                break;
            }
            case '\u00df': {
                target[pos++] = 115;
                target[pos++] = 115;
                break;
            }
            case '\u0100': {
                target[pos++] = 257;
                break;
            }
            case '\u0102': {
                target[pos++] = 259;
                break;
            }
            case '\u0104': {
                target[pos++] = 261;
                break;
            }
            case '\u0106': {
                target[pos++] = 263;
                break;
            }
            case '\u0108': {
                target[pos++] = 265;
                break;
            }
            case '\u010a': {
                target[pos++] = 267;
                break;
            }
            case '\u010c': {
                target[pos++] = 269;
                break;
            }
            case '\u010e': {
                target[pos++] = 271;
                break;
            }
            case '\u0110': {
                target[pos++] = 273;
                break;
            }
            case '\u0112': {
                target[pos++] = 275;
                break;
            }
            case '\u0114': {
                target[pos++] = 277;
                break;
            }
            case '\u0116': {
                target[pos++] = 279;
                break;
            }
            case '\u0118': {
                target[pos++] = 281;
                break;
            }
            case '\u011a': {
                target[pos++] = 283;
                break;
            }
            case '\u011c': {
                target[pos++] = 285;
                break;
            }
            case '\u011e': {
                target[pos++] = 287;
                break;
            }
            case '\u0120': {
                target[pos++] = 289;
                break;
            }
            case '\u0122': {
                target[pos++] = 291;
                break;
            }
            case '\u0124': {
                target[pos++] = 293;
                break;
            }
            case '\u0126': {
                target[pos++] = 295;
                break;
            }
            case '\u0128': {
                target[pos++] = 297;
                break;
            }
            case '\u012a': {
                target[pos++] = 299;
                break;
            }
            case '\u012c': {
                target[pos++] = 301;
                break;
            }
            case '\u012e': {
                target[pos++] = 303;
                break;
            }
            case '\u0130': {
                target[pos++] = 105;
                target[pos++] = 775;
                break;
            }
            case '\u0132': {
                target[pos++] = 307;
                break;
            }
            case '\u0134': {
                target[pos++] = 309;
                break;
            }
            case '\u0136': {
                target[pos++] = 311;
                break;
            }
            case '\u0139': {
                target[pos++] = 314;
                break;
            }
            case '\u013b': {
                target[pos++] = 316;
                break;
            }
            case '\u013d': {
                target[pos++] = 318;
                break;
            }
            case '\u013f': {
                target[pos++] = 320;
                break;
            }
            case '\u0141': {
                target[pos++] = 322;
                break;
            }
            case '\u0143': {
                target[pos++] = 324;
                break;
            }
            case '\u0145': {
                target[pos++] = 326;
                break;
            }
            case '\u0147': {
                target[pos++] = 328;
                break;
            }
            case '\u0149': {
                target[pos++] = 700;
                target[pos++] = 110;
                break;
            }
            case '\u014a': {
                target[pos++] = 331;
                break;
            }
            case '\u014c': {
                target[pos++] = 333;
                break;
            }
            case '\u014e': {
                target[pos++] = 335;
                break;
            }
            case '\u0150': {
                target[pos++] = 337;
                break;
            }
            case '\u0152': {
                target[pos++] = 339;
                break;
            }
            case '\u0154': {
                target[pos++] = 341;
                break;
            }
            case '\u0156': {
                target[pos++] = 343;
                break;
            }
            case '\u0158': {
                target[pos++] = 345;
                break;
            }
            case '\u015a': {
                target[pos++] = 347;
                break;
            }
            case '\u015c': {
                target[pos++] = 349;
                break;
            }
            case '\u015e': {
                target[pos++] = 351;
                break;
            }
            case '\u0160': {
                target[pos++] = 353;
                break;
            }
            case '\u0162': {
                target[pos++] = 355;
                break;
            }
            case '\u0164': {
                target[pos++] = 357;
                break;
            }
            case '\u0166': {
                target[pos++] = 359;
                break;
            }
            case '\u0168': {
                target[pos++] = 361;
                break;
            }
            case '\u016a': {
                target[pos++] = 363;
                break;
            }
            case '\u016c': {
                target[pos++] = 365;
                break;
            }
            case '\u016e': {
                target[pos++] = 367;
                break;
            }
            case '\u0170': {
                target[pos++] = 369;
                break;
            }
            case '\u0172': {
                target[pos++] = 371;
                break;
            }
            case '\u0174': {
                target[pos++] = 373;
                break;
            }
            case '\u0176': {
                target[pos++] = 375;
                break;
            }
            case '\u0178': {
                target[pos++] = 255;
                break;
            }
            case '\u0179': {
                target[pos++] = 378;
                break;
            }
            case '\u017b': {
                target[pos++] = 380;
                break;
            }
            case '\u017d': {
                target[pos++] = 382;
                break;
            }
            case '\u017f': {
                target[pos++] = 115;
                break;
            }
            case '\u0181': {
                target[pos++] = 595;
                break;
            }
            case '\u0182': {
                target[pos++] = 387;
                break;
            }
            case '\u0184': {
                target[pos++] = 389;
                break;
            }
            case '\u0186': {
                target[pos++] = 596;
                break;
            }
            case '\u0187': {
                target[pos++] = 392;
                break;
            }
            case '\u0189': {
                target[pos++] = 598;
                break;
            }
            case '\u018a': {
                target[pos++] = 599;
                break;
            }
            case '\u018b': {
                target[pos++] = 396;
                break;
            }
            case '\u018e': {
                target[pos++] = 477;
                break;
            }
            case '\u018f': {
                target[pos++] = 601;
                break;
            }
            case '\u0190': {
                target[pos++] = 603;
                break;
            }
            case '\u0191': {
                target[pos++] = 402;
                break;
            }
            case '\u0193': {
                target[pos++] = 608;
                break;
            }
            case '\u0194': {
                target[pos++] = 611;
                break;
            }
            case '\u0196': {
                target[pos++] = 617;
                break;
            }
            case '\u0197': {
                target[pos++] = 616;
                break;
            }
            case '\u0198': {
                target[pos++] = 409;
                break;
            }
            case '\u019c': {
                target[pos++] = 623;
                break;
            }
            case '\u019d': {
                target[pos++] = 626;
                break;
            }
            case '\u019f': {
                target[pos++] = 629;
                break;
            }
            case '\u01a0': {
                target[pos++] = 417;
                break;
            }
            case '\u01a2': {
                target[pos++] = 419;
                break;
            }
            case '\u01a4': {
                target[pos++] = 421;
                break;
            }
            case '\u01a6': {
                target[pos++] = 640;
                break;
            }
            case '\u01a7': {
                target[pos++] = 424;
                break;
            }
            case '\u01a9': {
                target[pos++] = 643;
                break;
            }
            case '\u01ac': {
                target[pos++] = 429;
                break;
            }
            case '\u01ae': {
                target[pos++] = 648;
                break;
            }
            case '\u01af': {
                target[pos++] = 432;
                break;
            }
            case '\u01b1': {
                target[pos++] = 650;
                break;
            }
            case '\u01b2': {
                target[pos++] = 651;
                break;
            }
            case '\u01b3': {
                target[pos++] = 436;
                break;
            }
            case '\u01b5': {
                target[pos++] = 438;
                break;
            }
            case '\u01b7': {
                target[pos++] = 658;
                break;
            }
            case '\u01b8': {
                target[pos++] = 441;
                break;
            }
            case '\u01bc': {
                target[pos++] = 445;
                break;
            }
            case '\u01c4': {
                target[pos++] = 454;
                break;
            }
            case '\u01c5': {
                target[pos++] = 454;
                break;
            }
            case '\u01c7': {
                target[pos++] = 457;
                break;
            }
            case '\u01c8': {
                target[pos++] = 457;
                break;
            }
            case '\u01ca': {
                target[pos++] = 460;
                break;
            }
            case '\u01cb': {
                target[pos++] = 460;
                break;
            }
            case '\u01cd': {
                target[pos++] = 462;
                break;
            }
            case '\u01cf': {
                target[pos++] = 464;
                break;
            }
            case '\u01d1': {
                target[pos++] = 466;
                break;
            }
            case '\u01d3': {
                target[pos++] = 468;
                break;
            }
            case '\u01d5': {
                target[pos++] = 470;
                break;
            }
            case '\u01d7': {
                target[pos++] = 472;
                break;
            }
            case '\u01d9': {
                target[pos++] = 474;
                break;
            }
            case '\u01db': {
                target[pos++] = 476;
                break;
            }
            case '\u01de': {
                target[pos++] = 479;
                break;
            }
            case '\u01e0': {
                target[pos++] = 481;
                break;
            }
            case '\u01e2': {
                target[pos++] = 483;
                break;
            }
            case '\u01e4': {
                target[pos++] = 485;
                break;
            }
            case '\u01e6': {
                target[pos++] = 487;
                break;
            }
            case '\u01e8': {
                target[pos++] = 489;
                break;
            }
            case '\u01ea': {
                target[pos++] = 491;
                break;
            }
            case '\u01ec': {
                target[pos++] = 493;
                break;
            }
            case '\u01ee': {
                target[pos++] = 495;
                break;
            }
            case '\u01f0': {
                target[pos++] = 106;
                target[pos++] = 780;
                break;
            }
            case '\u01f1': {
                target[pos++] = 499;
                break;
            }
            case '\u01f2': {
                target[pos++] = 499;
                break;
            }
            case '\u01f4': {
                target[pos++] = 501;
                break;
            }
            case '\u01f6': {
                target[pos++] = 405;
                break;
            }
            case '\u01f7': {
                target[pos++] = 447;
                break;
            }
            case '\u01f8': {
                target[pos++] = 505;
                break;
            }
            case '\u01fa': {
                target[pos++] = 507;
                break;
            }
            case '\u01fc': {
                target[pos++] = 509;
                break;
            }
            case '\u01fe': {
                target[pos++] = 511;
                break;
            }
            case '\u0200': {
                target[pos++] = 513;
                break;
            }
            case '\u0202': {
                target[pos++] = 515;
                break;
            }
            case '\u0204': {
                target[pos++] = 517;
                break;
            }
            case '\u0206': {
                target[pos++] = 519;
                break;
            }
            case '\u0208': {
                target[pos++] = 521;
                break;
            }
            case '\u020a': {
                target[pos++] = 523;
                break;
            }
            case '\u020c': {
                target[pos++] = 525;
                break;
            }
            case '\u020e': {
                target[pos++] = 527;
                break;
            }
            case '\u0210': {
                target[pos++] = 529;
                break;
            }
            case '\u0212': {
                target[pos++] = 531;
                break;
            }
            case '\u0214': {
                target[pos++] = 533;
                break;
            }
            case '\u0216': {
                target[pos++] = 535;
                break;
            }
            case '\u0218': {
                target[pos++] = 537;
                break;
            }
            case '\u021a': {
                target[pos++] = 539;
                break;
            }
            case '\u021c': {
                target[pos++] = 541;
                break;
            }
            case '\u021e': {
                target[pos++] = 543;
                break;
            }
            case '\u0220': {
                target[pos++] = 414;
                break;
            }
            case '\u0222': {
                target[pos++] = 547;
                break;
            }
            case '\u0224': {
                target[pos++] = 549;
                break;
            }
            case '\u0226': {
                target[pos++] = 551;
                break;
            }
            case '\u0228': {
                target[pos++] = 553;
                break;
            }
            case '\u022a': {
                target[pos++] = 555;
                break;
            }
            case '\u022c': {
                target[pos++] = 557;
                break;
            }
            case '\u022e': {
                target[pos++] = 559;
                break;
            }
            case '\u0230': {
                target[pos++] = 561;
                break;
            }
            case '\u0232': {
                target[pos++] = 563;
                break;
            }
            case '\u0345': {
                target[pos++] = 953;
                break;
            }
            case '\u034f': {
                break;
            }
            case '\u037a': {
                target[pos++] = 32;
                target[pos++] = 953;
                break;
            }
            case '\u0386': {
                target[pos++] = 940;
                break;
            }
            case '\u0388': {
                target[pos++] = 941;
                break;
            }
            case '\u0389': {
                target[pos++] = 942;
                break;
            }
            case '\u038a': {
                target[pos++] = 943;
                break;
            }
            case '\u038c': {
                target[pos++] = 972;
                break;
            }
            case '\u038e': {
                target[pos++] = 973;
                break;
            }
            case '\u038f': {
                target[pos++] = 974;
                break;
            }
            case '\u0390': {
                target[pos++] = 953;
                target[pos++] = 776;
                target[pos++] = 769;
                break;
            }
            case '\u0391': {
                target[pos++] = 945;
                break;
            }
            case '\u0392': {
                target[pos++] = 946;
                break;
            }
            case '\u0393': {
                target[pos++] = 947;
                break;
            }
            case '\u0394': {
                target[pos++] = 948;
                break;
            }
            case '\u0395': {
                target[pos++] = 949;
                break;
            }
            case '\u0396': {
                target[pos++] = 950;
                break;
            }
            case '\u0397': {
                target[pos++] = 951;
                break;
            }
            case '\u0398': {
                target[pos++] = 952;
                break;
            }
            case '\u0399': {
                target[pos++] = 953;
                break;
            }
            case '\u039a': {
                target[pos++] = 954;
                break;
            }
            case '\u039b': {
                target[pos++] = 955;
                break;
            }
            case '\u039c': {
                target[pos++] = 956;
                break;
            }
            case '\u039d': {
                target[pos++] = 957;
                break;
            }
            case '\u039e': {
                target[pos++] = 958;
                break;
            }
            case '\u039f': {
                target[pos++] = 959;
                break;
            }
            case '\u03a0': {
                target[pos++] = 960;
                break;
            }
            case '\u03a1': {
                target[pos++] = 961;
                break;
            }
            case '\u03a3': {
                target[pos++] = 963;
                break;
            }
            case '\u03a4': {
                target[pos++] = 964;
                break;
            }
            case '\u03a5': {
                target[pos++] = 965;
                break;
            }
            case '\u03a6': {
                target[pos++] = 966;
                break;
            }
            case '\u03a7': {
                target[pos++] = 967;
                break;
            }
            case '\u03a8': {
                target[pos++] = 968;
                break;
            }
            case '\u03a9': {
                target[pos++] = 969;
                break;
            }
            case '\u03aa': {
                target[pos++] = 970;
                break;
            }
            case '\u03ab': {
                target[pos++] = 971;
                break;
            }
            case '\u03b0': {
                target[pos++] = 965;
                target[pos++] = 776;
                target[pos++] = 769;
                break;
            }
            case '\u03c2': {
                target[pos++] = 963;
                break;
            }
            case '\u03d0': {
                target[pos++] = 946;
                break;
            }
            case '\u03d1': {
                target[pos++] = 952;
                break;
            }
            case '\u03d2': {
                target[pos++] = 965;
                break;
            }
            case '\u03d3': {
                target[pos++] = 973;
                break;
            }
            case '\u03d4': {
                target[pos++] = 971;
                break;
            }
            case '\u03d5': {
                target[pos++] = 966;
                break;
            }
            case '\u03d6': {
                target[pos++] = 960;
                break;
            }
            case '\u03d8': {
                target[pos++] = 985;
                break;
            }
            case '\u03da': {
                target[pos++] = 987;
                break;
            }
            case '\u03dc': {
                target[pos++] = 989;
                break;
            }
            case '\u03de': {
                target[pos++] = 991;
                break;
            }
            case '\u03e0': {
                target[pos++] = 993;
                break;
            }
            case '\u03e2': {
                target[pos++] = 995;
                break;
            }
            case '\u03e4': {
                target[pos++] = 997;
                break;
            }
            case '\u03e6': {
                target[pos++] = 999;
                break;
            }
            case '\u03e8': {
                target[pos++] = 1001;
                break;
            }
            case '\u03ea': {
                target[pos++] = 1003;
                break;
            }
            case '\u03ec': {
                target[pos++] = 1005;
                break;
            }
            case '\u03ee': {
                target[pos++] = 1007;
                break;
            }
            case '\u03f0': {
                target[pos++] = 954;
                break;
            }
            case '\u03f1': {
                target[pos++] = 961;
                break;
            }
            case '\u03f2': {
                target[pos++] = 963;
                break;
            }
            case '\u03f4': {
                target[pos++] = 952;
                break;
            }
            case '\u03f5': {
                target[pos++] = 949;
                break;
            }
            case '\u0400': {
                target[pos++] = 1104;
                break;
            }
            case '\u0401': {
                target[pos++] = 1105;
                break;
            }
            case '\u0402': {
                target[pos++] = 1106;
                break;
            }
            case '\u0403': {
                target[pos++] = 1107;
                break;
            }
            case '\u0404': {
                target[pos++] = 1108;
                break;
            }
            case '\u0405': {
                target[pos++] = 1109;
                break;
            }
            case '\u0406': {
                target[pos++] = 1110;
                break;
            }
            case '\u0407': {
                target[pos++] = 1111;
                break;
            }
            case '\u0408': {
                target[pos++] = 1112;
                break;
            }
            case '\u0409': {
                target[pos++] = 1113;
                break;
            }
            case '\u040a': {
                target[pos++] = 1114;
                break;
            }
            case '\u040b': {
                target[pos++] = 1115;
                break;
            }
            case '\u040c': {
                target[pos++] = 1116;
                break;
            }
            case '\u040d': {
                target[pos++] = 1117;
                break;
            }
            case '\u040e': {
                target[pos++] = 1118;
                break;
            }
            case '\u040f': {
                target[pos++] = 1119;
                break;
            }
            case '\u0410': {
                target[pos++] = 1072;
                break;
            }
            case '\u0411': {
                target[pos++] = 1073;
                break;
            }
            case '\u0412': {
                target[pos++] = 1074;
                break;
            }
            case '\u0413': {
                target[pos++] = 1075;
                break;
            }
            case '\u0414': {
                target[pos++] = 1076;
                break;
            }
            case '\u0415': {
                target[pos++] = 1077;
                break;
            }
            case '\u0416': {
                target[pos++] = 1078;
                break;
            }
            case '\u0417': {
                target[pos++] = 1079;
                break;
            }
            case '\u0418': {
                target[pos++] = 1080;
                break;
            }
            case '\u0419': {
                target[pos++] = 1081;
                break;
            }
            case '\u041a': {
                target[pos++] = 1082;
                break;
            }
            case '\u041b': {
                target[pos++] = 1083;
                break;
            }
            case '\u041c': {
                target[pos++] = 1084;
                break;
            }
            case '\u041d': {
                target[pos++] = 1085;
                break;
            }
            case '\u041e': {
                target[pos++] = 1086;
                break;
            }
            case '\u041f': {
                target[pos++] = 1087;
                break;
            }
            case '\u0420': {
                target[pos++] = 1088;
                break;
            }
            case '\u0421': {
                target[pos++] = 1089;
                break;
            }
            case '\u0422': {
                target[pos++] = 1090;
                break;
            }
            case '\u0423': {
                target[pos++] = 1091;
                break;
            }
            case '\u0424': {
                target[pos++] = 1092;
                break;
            }
            case '\u0425': {
                target[pos++] = 1093;
                break;
            }
            case '\u0426': {
                target[pos++] = 1094;
                break;
            }
            case '\u0427': {
                target[pos++] = 1095;
                break;
            }
            case '\u0428': {
                target[pos++] = 1096;
                break;
            }
            case '\u0429': {
                target[pos++] = 1097;
                break;
            }
            case '\u042a': {
                target[pos++] = 1098;
                break;
            }
            case '\u042b': {
                target[pos++] = 1099;
                break;
            }
            case '\u042c': {
                target[pos++] = 1100;
                break;
            }
            case '\u042d': {
                target[pos++] = 1101;
                break;
            }
            case '\u042e': {
                target[pos++] = 1102;
                break;
            }
            case '\u042f': {
                target[pos++] = 1103;
                break;
            }
            case '\u0460': {
                target[pos++] = 1121;
                break;
            }
            case '\u0462': {
                target[pos++] = 1123;
                break;
            }
            case '\u0464': {
                target[pos++] = 1125;
                break;
            }
            case '\u0466': {
                target[pos++] = 1127;
                break;
            }
            case '\u0468': {
                target[pos++] = 1129;
                break;
            }
            case '\u046a': {
                target[pos++] = 1131;
                break;
            }
            case '\u046c': {
                target[pos++] = 1133;
                break;
            }
            case '\u046e': {
                target[pos++] = 1135;
                break;
            }
            case '\u0470': {
                target[pos++] = 1137;
                break;
            }
            case '\u0472': {
                target[pos++] = 1139;
                break;
            }
            case '\u0474': {
                target[pos++] = 1141;
                break;
            }
            case '\u0476': {
                target[pos++] = 1143;
                break;
            }
            case '\u0478': {
                target[pos++] = 1145;
                break;
            }
            case '\u047a': {
                target[pos++] = 1147;
                break;
            }
            case '\u047c': {
                target[pos++] = 1149;
                break;
            }
            case '\u047e': {
                target[pos++] = 1151;
                break;
            }
            case '\u0480': {
                target[pos++] = 1153;
                break;
            }
            case '\u048a': {
                target[pos++] = 1163;
                break;
            }
            case '\u048c': {
                target[pos++] = 1165;
                break;
            }
            case '\u048e': {
                target[pos++] = 1167;
                break;
            }
            case '\u0490': {
                target[pos++] = 1169;
                break;
            }
            case '\u0492': {
                target[pos++] = 1171;
                break;
            }
            case '\u0494': {
                target[pos++] = 1173;
                break;
            }
            case '\u0496': {
                target[pos++] = 1175;
                break;
            }
            case '\u0498': {
                target[pos++] = 1177;
                break;
            }
            case '\u049a': {
                target[pos++] = 1179;
                break;
            }
            case '\u049c': {
                target[pos++] = 1181;
                break;
            }
            case '\u049e': {
                target[pos++] = 1183;
                break;
            }
            case '\u04a0': {
                target[pos++] = 1185;
                break;
            }
            case '\u04a2': {
                target[pos++] = 1187;
                break;
            }
            case '\u04a4': {
                target[pos++] = 1189;
                break;
            }
            case '\u04a6': {
                target[pos++] = 1191;
                break;
            }
            case '\u04a8': {
                target[pos++] = 1193;
                break;
            }
            case '\u04aa': {
                target[pos++] = 1195;
                break;
            }
            case '\u04ac': {
                target[pos++] = 1197;
                break;
            }
            case '\u04ae': {
                target[pos++] = 1199;
                break;
            }
            case '\u04b0': {
                target[pos++] = 1201;
                break;
            }
            case '\u04b2': {
                target[pos++] = 1203;
                break;
            }
            case '\u04b4': {
                target[pos++] = 1205;
                break;
            }
            case '\u04b6': {
                target[pos++] = 1207;
                break;
            }
            case '\u04b8': {
                target[pos++] = 1209;
                break;
            }
            case '\u04ba': {
                target[pos++] = 1211;
                break;
            }
            case '\u04bc': {
                target[pos++] = 1213;
                break;
            }
            case '\u04be': {
                target[pos++] = 1215;
                break;
            }
            case '\u04c1': {
                target[pos++] = 1218;
                break;
            }
            case '\u04c3': {
                target[pos++] = 1220;
                break;
            }
            case '\u04c5': {
                target[pos++] = 1222;
                break;
            }
            case '\u04c7': {
                target[pos++] = 1224;
                break;
            }
            case '\u04c9': {
                target[pos++] = 1226;
                break;
            }
            case '\u04cb': {
                target[pos++] = 1228;
                break;
            }
            case '\u04cd': {
                target[pos++] = 1230;
                break;
            }
            case '\u04d0': {
                target[pos++] = 1233;
                break;
            }
            case '\u04d2': {
                target[pos++] = 1235;
                break;
            }
            case '\u04d4': {
                target[pos++] = 1237;
                break;
            }
            case '\u04d6': {
                target[pos++] = 1239;
                break;
            }
            case '\u04d8': {
                target[pos++] = 1241;
                break;
            }
            case '\u04da': {
                target[pos++] = 1243;
                break;
            }
            case '\u04dc': {
                target[pos++] = 1245;
                break;
            }
            case '\u04de': {
                target[pos++] = 1247;
                break;
            }
            case '\u04e0': {
                target[pos++] = 1249;
                break;
            }
            case '\u04e2': {
                target[pos++] = 1251;
                break;
            }
            case '\u04e4': {
                target[pos++] = 1253;
                break;
            }
            case '\u04e6': {
                target[pos++] = 1255;
                break;
            }
            case '\u04e8': {
                target[pos++] = 1257;
                break;
            }
            case '\u04ea': {
                target[pos++] = 1259;
                break;
            }
            case '\u04ec': {
                target[pos++] = 1261;
                break;
            }
            case '\u04ee': {
                target[pos++] = 1263;
                break;
            }
            case '\u04f0': {
                target[pos++] = 1265;
                break;
            }
            case '\u04f2': {
                target[pos++] = 1267;
                break;
            }
            case '\u04f4': {
                target[pos++] = 1269;
                break;
            }
            case '\u04f8': {
                target[pos++] = 1273;
                break;
            }
            case '\u0500': {
                target[pos++] = 1281;
                break;
            }
            case '\u0502': {
                target[pos++] = 1283;
                break;
            }
            case '\u0504': {
                target[pos++] = 1285;
                break;
            }
            case '\u0506': {
                target[pos++] = 1287;
                break;
            }
            case '\u0508': {
                target[pos++] = 1289;
                break;
            }
            case '\u050a': {
                target[pos++] = 1291;
                break;
            }
            case '\u050c': {
                target[pos++] = 1293;
                break;
            }
            case '\u050e': {
                target[pos++] = 1295;
                break;
            }
            case '\u0531': {
                target[pos++] = 1377;
                break;
            }
            case '\u0532': {
                target[pos++] = 1378;
                break;
            }
            case '\u0533': {
                target[pos++] = 1379;
                break;
            }
            case '\u0534': {
                target[pos++] = 1380;
                break;
            }
            case '\u0535': {
                target[pos++] = 1381;
                break;
            }
            case '\u0536': {
                target[pos++] = 1382;
                break;
            }
            case '\u0537': {
                target[pos++] = 1383;
                break;
            }
            case '\u0538': {
                target[pos++] = 1384;
                break;
            }
            case '\u0539': {
                target[pos++] = 1385;
                break;
            }
            case '\u053a': {
                target[pos++] = 1386;
                break;
            }
            case '\u053b': {
                target[pos++] = 1387;
                break;
            }
            case '\u053c': {
                target[pos++] = 1388;
                break;
            }
            case '\u053d': {
                target[pos++] = 1389;
                break;
            }
            case '\u053e': {
                target[pos++] = 1390;
                break;
            }
            case '\u053f': {
                target[pos++] = 1391;
                break;
            }
            case '\u0540': {
                target[pos++] = 1392;
                break;
            }
            case '\u0541': {
                target[pos++] = 1393;
                break;
            }
            case '\u0542': {
                target[pos++] = 1394;
                break;
            }
            case '\u0543': {
                target[pos++] = 1395;
                break;
            }
            case '\u0544': {
                target[pos++] = 1396;
                break;
            }
            case '\u0545': {
                target[pos++] = 1397;
                break;
            }
            case '\u0546': {
                target[pos++] = 1398;
                break;
            }
            case '\u0547': {
                target[pos++] = 1399;
                break;
            }
            case '\u0548': {
                target[pos++] = 1400;
                break;
            }
            case '\u0549': {
                target[pos++] = 1401;
                break;
            }
            case '\u054a': {
                target[pos++] = 1402;
                break;
            }
            case '\u054b': {
                target[pos++] = 1403;
                break;
            }
            case '\u054c': {
                target[pos++] = 1404;
                break;
            }
            case '\u054d': {
                target[pos++] = 1405;
                break;
            }
            case '\u054e': {
                target[pos++] = 1406;
                break;
            }
            case '\u054f': {
                target[pos++] = 1407;
                break;
            }
            case '\u0550': {
                target[pos++] = 1408;
                break;
            }
            case '\u0551': {
                target[pos++] = 1409;
                break;
            }
            case '\u0552': {
                target[pos++] = 1410;
                break;
            }
            case '\u0553': {
                target[pos++] = 1411;
                break;
            }
            case '\u0554': {
                target[pos++] = 1412;
                break;
            }
            case '\u0555': {
                target[pos++] = 1413;
                break;
            }
            case '\u0556': {
                target[pos++] = 1414;
                break;
            }
            case '\u0587': {
                target[pos++] = 1381;
                target[pos++] = 1410;
                break;
            }
            case '\u06dd': {
                break;
            }
            case '\u070f': {
                break;
            }
            case '\u1680': {
                target[pos++] = 32;
                break;
            }
            case '\u1806': {
                break;
            }
            case '\u180b': 
            case '\u180c': 
            case '\u180d': 
            case '\u180e': {
                break;
            }
            case '\u1e00': {
                target[pos++] = 7681;
                break;
            }
            case '\u1e02': {
                target[pos++] = 7683;
                break;
            }
            case '\u1e04': {
                target[pos++] = 7685;
                break;
            }
            case '\u1e06': {
                target[pos++] = 7687;
                break;
            }
            case '\u1e08': {
                target[pos++] = 7689;
                break;
            }
            case '\u1e0a': {
                target[pos++] = 7691;
                break;
            }
            case '\u1e0c': {
                target[pos++] = 7693;
                break;
            }
            case '\u1e0e': {
                target[pos++] = 7695;
                break;
            }
            case '\u1e10': {
                target[pos++] = 7697;
                break;
            }
            case '\u1e12': {
                target[pos++] = 7699;
                break;
            }
            case '\u1e14': {
                target[pos++] = 7701;
                break;
            }
            case '\u1e16': {
                target[pos++] = 7703;
                break;
            }
            case '\u1e18': {
                target[pos++] = 7705;
                break;
            }
            case '\u1e1a': {
                target[pos++] = 7707;
                break;
            }
            case '\u1e1c': {
                target[pos++] = 7709;
                break;
            }
            case '\u1e1e': {
                target[pos++] = 7711;
                break;
            }
            case '\u1e20': {
                target[pos++] = 7713;
                break;
            }
            case '\u1e22': {
                target[pos++] = 7715;
                break;
            }
            case '\u1e24': {
                target[pos++] = 7717;
                break;
            }
            case '\u1e26': {
                target[pos++] = 7719;
                break;
            }
            case '\u1e28': {
                target[pos++] = 7721;
                break;
            }
            case '\u1e2a': {
                target[pos++] = 7723;
                break;
            }
            case '\u1e2c': {
                target[pos++] = 7725;
                break;
            }
            case '\u1e2e': {
                target[pos++] = 7727;
                break;
            }
            case '\u1e30': {
                target[pos++] = 7729;
                break;
            }
            case '\u1e32': {
                target[pos++] = 7731;
                break;
            }
            case '\u1e34': {
                target[pos++] = 7733;
                break;
            }
            case '\u1e36': {
                target[pos++] = 7735;
                break;
            }
            case '\u1e38': {
                target[pos++] = 7737;
                break;
            }
            case '\u1e3a': {
                target[pos++] = 7739;
                break;
            }
            case '\u1e3c': {
                target[pos++] = 7741;
                break;
            }
            case '\u1e3e': {
                target[pos++] = 7743;
                break;
            }
            case '\u1e40': {
                target[pos++] = 7745;
                break;
            }
            case '\u1e42': {
                target[pos++] = 7747;
                break;
            }
            case '\u1e44': {
                target[pos++] = 7749;
                break;
            }
            case '\u1e46': {
                target[pos++] = 7751;
                break;
            }
            case '\u1e48': {
                target[pos++] = 7753;
                break;
            }
            case '\u1e4a': {
                target[pos++] = 7755;
                break;
            }
            case '\u1e4c': {
                target[pos++] = 7757;
                break;
            }
            case '\u1e4e': {
                target[pos++] = 7759;
                break;
            }
            case '\u1e50': {
                target[pos++] = 7761;
                break;
            }
            case '\u1e52': {
                target[pos++] = 7763;
                break;
            }
            case '\u1e54': {
                target[pos++] = 7765;
                break;
            }
            case '\u1e56': {
                target[pos++] = 7767;
                break;
            }
            case '\u1e58': {
                target[pos++] = 7769;
                break;
            }
            case '\u1e5a': {
                target[pos++] = 7771;
                break;
            }
            case '\u1e5c': {
                target[pos++] = 7773;
                break;
            }
            case '\u1e5e': {
                target[pos++] = 7775;
                break;
            }
            case '\u1e60': {
                target[pos++] = 7777;
                break;
            }
            case '\u1e62': {
                target[pos++] = 7779;
                break;
            }
            case '\u1e64': {
                target[pos++] = 7781;
                break;
            }
            case '\u1e66': {
                target[pos++] = 7783;
                break;
            }
            case '\u1e68': {
                target[pos++] = 7785;
                break;
            }
            case '\u1e6a': {
                target[pos++] = 7787;
                break;
            }
            case '\u1e6c': {
                target[pos++] = 7789;
                break;
            }
            case '\u1e6e': {
                target[pos++] = 7791;
                break;
            }
            case '\u1e70': {
                target[pos++] = 7793;
                break;
            }
            case '\u1e72': {
                target[pos++] = 7795;
                break;
            }
            case '\u1e74': {
                target[pos++] = 7797;
                break;
            }
            case '\u1e76': {
                target[pos++] = 7799;
                break;
            }
            case '\u1e78': {
                target[pos++] = 7801;
                break;
            }
            case '\u1e7a': {
                target[pos++] = 7803;
                break;
            }
            case '\u1e7c': {
                target[pos++] = 7805;
                break;
            }
            case '\u1e7e': {
                target[pos++] = 7807;
                break;
            }
            case '\u1e80': {
                target[pos++] = 7809;
                break;
            }
            case '\u1e82': {
                target[pos++] = 7811;
                break;
            }
            case '\u1e84': {
                target[pos++] = 7813;
                break;
            }
            case '\u1e86': {
                target[pos++] = 7815;
                break;
            }
            case '\u1e88': {
                target[pos++] = 7817;
                break;
            }
            case '\u1e8a': {
                target[pos++] = 7819;
                break;
            }
            case '\u1e8c': {
                target[pos++] = 7821;
                break;
            }
            case '\u1e8e': {
                target[pos++] = 7823;
                break;
            }
            case '\u1e90': {
                target[pos++] = 7825;
                break;
            }
            case '\u1e92': {
                target[pos++] = 7827;
                break;
            }
            case '\u1e94': {
                target[pos++] = 7829;
                break;
            }
            case '\u1e96': {
                target[pos++] = 104;
                target[pos++] = 817;
                break;
            }
            case '\u1e97': {
                target[pos++] = 116;
                target[pos++] = 776;
                break;
            }
            case '\u1e98': {
                target[pos++] = 119;
                target[pos++] = 778;
                break;
            }
            case '\u1e99': {
                target[pos++] = 121;
                target[pos++] = 778;
                break;
            }
            case '\u1e9a': {
                target[pos++] = 97;
                target[pos++] = 702;
                break;
            }
            case '\u1e9b': {
                target[pos++] = 7777;
                break;
            }
            case '\u1ea0': {
                target[pos++] = 7841;
                break;
            }
            case '\u1ea2': {
                target[pos++] = 7843;
                break;
            }
            case '\u1ea4': {
                target[pos++] = 7845;
                break;
            }
            case '\u1ea6': {
                target[pos++] = 7847;
                break;
            }
            case '\u1ea8': {
                target[pos++] = 7849;
                break;
            }
            case '\u1eaa': {
                target[pos++] = 7851;
                break;
            }
            case '\u1eac': {
                target[pos++] = 7853;
                break;
            }
            case '\u1eae': {
                target[pos++] = 7855;
                break;
            }
            case '\u1eb0': {
                target[pos++] = 7857;
                break;
            }
            case '\u1eb2': {
                target[pos++] = 7859;
                break;
            }
            case '\u1eb4': {
                target[pos++] = 7861;
                break;
            }
            case '\u1eb6': {
                target[pos++] = 7863;
                break;
            }
            case '\u1eb8': {
                target[pos++] = 7865;
                break;
            }
            case '\u1eba': {
                target[pos++] = 7867;
                break;
            }
            case '\u1ebc': {
                target[pos++] = 7869;
                break;
            }
            case '\u1ebe': {
                target[pos++] = 7871;
                break;
            }
            case '\u1ec0': {
                target[pos++] = 7873;
                break;
            }
            case '\u1ec2': {
                target[pos++] = 7875;
                break;
            }
            case '\u1ec4': {
                target[pos++] = 7877;
                break;
            }
            case '\u1ec6': {
                target[pos++] = 7879;
                break;
            }
            case '\u1ec8': {
                target[pos++] = 7881;
                break;
            }
            case '\u1eca': {
                target[pos++] = 7883;
                break;
            }
            case '\u1ecc': {
                target[pos++] = 7885;
                break;
            }
            case '\u1ece': {
                target[pos++] = 7887;
                break;
            }
            case '\u1ed0': {
                target[pos++] = 7889;
                break;
            }
            case '\u1ed2': {
                target[pos++] = 7891;
                break;
            }
            case '\u1ed4': {
                target[pos++] = 7893;
                break;
            }
            case '\u1ed6': {
                target[pos++] = 7895;
                break;
            }
            case '\u1ed8': {
                target[pos++] = 7897;
                break;
            }
            case '\u1eda': {
                target[pos++] = 7899;
                break;
            }
            case '\u1edc': {
                target[pos++] = 7901;
                break;
            }
            case '\u1ede': {
                target[pos++] = 7903;
                break;
            }
            case '\u1ee0': {
                target[pos++] = 7905;
                break;
            }
            case '\u1ee2': {
                target[pos++] = 7907;
                break;
            }
            case '\u1ee4': {
                target[pos++] = 7909;
                break;
            }
            case '\u1ee6': {
                target[pos++] = 7911;
                break;
            }
            case '\u1ee8': {
                target[pos++] = 7913;
                break;
            }
            case '\u1eea': {
                target[pos++] = 7915;
                break;
            }
            case '\u1eec': {
                target[pos++] = 7917;
                break;
            }
            case '\u1eee': {
                target[pos++] = 7919;
                break;
            }
            case '\u1ef0': {
                target[pos++] = 7921;
                break;
            }
            case '\u1ef2': {
                target[pos++] = 7923;
                break;
            }
            case '\u1ef4': {
                target[pos++] = 7925;
                break;
            }
            case '\u1ef6': {
                target[pos++] = 7927;
                break;
            }
            case '\u1ef8': {
                target[pos++] = 7929;
                break;
            }
            case '\u1f08': {
                target[pos++] = 7936;
                break;
            }
            case '\u1f09': {
                target[pos++] = 7937;
                break;
            }
            case '\u1f0a': {
                target[pos++] = 7938;
                break;
            }
            case '\u1f0b': {
                target[pos++] = 7939;
                break;
            }
            case '\u1f0c': {
                target[pos++] = 7940;
                break;
            }
            case '\u1f0d': {
                target[pos++] = 7941;
                break;
            }
            case '\u1f0e': {
                target[pos++] = 7942;
                break;
            }
            case '\u1f0f': {
                target[pos++] = 7943;
                break;
            }
            case '\u1f18': {
                target[pos++] = 7952;
                break;
            }
            case '\u1f19': {
                target[pos++] = 7953;
                break;
            }
            case '\u1f1a': {
                target[pos++] = 7954;
                break;
            }
            case '\u1f1b': {
                target[pos++] = 7955;
                break;
            }
            case '\u1f1c': {
                target[pos++] = 7956;
                break;
            }
            case '\u1f1d': {
                target[pos++] = 7957;
                break;
            }
            case '\u1f28': {
                target[pos++] = 7968;
                break;
            }
            case '\u1f29': {
                target[pos++] = 7969;
                break;
            }
            case '\u1f2a': {
                target[pos++] = 7970;
                break;
            }
            case '\u1f2b': {
                target[pos++] = 7971;
                break;
            }
            case '\u1f2c': {
                target[pos++] = 7972;
                break;
            }
            case '\u1f2d': {
                target[pos++] = 7973;
                break;
            }
            case '\u1f2e': {
                target[pos++] = 7974;
                break;
            }
            case '\u1f2f': {
                target[pos++] = 7975;
                break;
            }
            case '\u1f38': {
                target[pos++] = 7984;
                break;
            }
            case '\u1f39': {
                target[pos++] = 7985;
                break;
            }
            case '\u1f3a': {
                target[pos++] = 7986;
                break;
            }
            case '\u1f3b': {
                target[pos++] = 7987;
                break;
            }
            case '\u1f3c': {
                target[pos++] = 7988;
                break;
            }
            case '\u1f3d': {
                target[pos++] = 7989;
                break;
            }
            case '\u1f3e': {
                target[pos++] = 7990;
                break;
            }
            case '\u1f3f': {
                target[pos++] = 7991;
                break;
            }
            case '\u1f48': {
                target[pos++] = 8000;
                break;
            }
            case '\u1f49': {
                target[pos++] = 8001;
                break;
            }
            case '\u1f4a': {
                target[pos++] = 8002;
                break;
            }
            case '\u1f4b': {
                target[pos++] = 8003;
                break;
            }
            case '\u1f4c': {
                target[pos++] = 8004;
                break;
            }
            case '\u1f4d': {
                target[pos++] = 8005;
                break;
            }
            case '\u1f50': {
                target[pos++] = 965;
                target[pos++] = 787;
                break;
            }
            case '\u1f52': {
                target[pos++] = 965;
                target[pos++] = 787;
                target[pos++] = 768;
                break;
            }
            case '\u1f54': {
                target[pos++] = 965;
                target[pos++] = 787;
                target[pos++] = 769;
                break;
            }
            case '\u1f56': {
                target[pos++] = 965;
                target[pos++] = 787;
                target[pos++] = 834;
                break;
            }
            case '\u1f59': {
                target[pos++] = 8017;
                break;
            }
            case '\u1f5b': {
                target[pos++] = 8019;
                break;
            }
            case '\u1f5d': {
                target[pos++] = 8021;
                break;
            }
            case '\u1f5f': {
                target[pos++] = 8023;
                break;
            }
            case '\u1f68': {
                target[pos++] = 8032;
                break;
            }
            case '\u1f69': {
                target[pos++] = 8033;
                break;
            }
            case '\u1f6a': {
                target[pos++] = 8034;
                break;
            }
            case '\u1f6b': {
                target[pos++] = 8035;
                break;
            }
            case '\u1f6c': {
                target[pos++] = 8036;
                break;
            }
            case '\u1f6d': {
                target[pos++] = 8037;
                break;
            }
            case '\u1f6e': {
                target[pos++] = 8038;
                break;
            }
            case '\u1f6f': {
                target[pos++] = 8039;
                break;
            }
            case '\u1f80': {
                target[pos++] = 7936;
                target[pos++] = 953;
                break;
            }
            case '\u1f81': {
                target[pos++] = 7937;
                target[pos++] = 953;
                break;
            }
            case '\u1f82': {
                target[pos++] = 7938;
                target[pos++] = 953;
                break;
            }
            case '\u1f83': {
                target[pos++] = 7939;
                target[pos++] = 953;
                break;
            }
            case '\u1f84': {
                target[pos++] = 7940;
                target[pos++] = 953;
                break;
            }
            case '\u1f85': {
                target[pos++] = 7941;
                target[pos++] = 953;
                break;
            }
            case '\u1f86': {
                target[pos++] = 7942;
                target[pos++] = 953;
                break;
            }
            case '\u1f87': {
                target[pos++] = 7943;
                target[pos++] = 953;
                break;
            }
            case '\u1f88': {
                target[pos++] = 7936;
                target[pos++] = 953;
                break;
            }
            case '\u1f89': {
                target[pos++] = 7937;
                target[pos++] = 953;
                break;
            }
            case '\u1f8a': {
                target[pos++] = 7938;
                target[pos++] = 953;
                break;
            }
            case '\u1f8b': {
                target[pos++] = 7939;
                target[pos++] = 953;
                break;
            }
            case '\u1f8c': {
                target[pos++] = 7940;
                target[pos++] = 953;
                break;
            }
            case '\u1f8d': {
                target[pos++] = 7941;
                target[pos++] = 953;
                break;
            }
            case '\u1f8e': {
                target[pos++] = 7942;
                target[pos++] = 953;
                break;
            }
            case '\u1f8f': {
                target[pos++] = 7943;
                target[pos++] = 953;
                break;
            }
            case '\u1f90': {
                target[pos++] = 7968;
                target[pos++] = 953;
                break;
            }
            case '\u1f91': {
                target[pos++] = 7969;
                target[pos++] = 953;
                break;
            }
            case '\u1f92': {
                target[pos++] = 7970;
                target[pos++] = 953;
                break;
            }
            case '\u1f93': {
                target[pos++] = 7971;
                target[pos++] = 953;
                break;
            }
            case '\u1f94': {
                target[pos++] = 7972;
                target[pos++] = 953;
                break;
            }
            case '\u1f95': {
                target[pos++] = 7973;
                target[pos++] = 953;
                break;
            }
            case '\u1f96': {
                target[pos++] = 7974;
                target[pos++] = 953;
                break;
            }
            case '\u1f97': {
                target[pos++] = 7975;
                target[pos++] = 953;
                break;
            }
            case '\u1f98': {
                target[pos++] = 7968;
                target[pos++] = 953;
                break;
            }
            case '\u1f99': {
                target[pos++] = 7969;
                target[pos++] = 953;
                break;
            }
            case '\u1f9a': {
                target[pos++] = 7970;
                target[pos++] = 953;
                break;
            }
            case '\u1f9b': {
                target[pos++] = 7971;
                target[pos++] = 953;
                break;
            }
            case '\u1f9c': {
                target[pos++] = 7972;
                target[pos++] = 953;
                break;
            }
            case '\u1f9d': {
                target[pos++] = 7973;
                target[pos++] = 953;
                break;
            }
            case '\u1f9e': {
                target[pos++] = 7974;
                target[pos++] = 953;
                break;
            }
            case '\u1f9f': {
                target[pos++] = 7975;
                target[pos++] = 953;
                break;
            }
            case '\u1fa0': {
                target[pos++] = 8032;
                target[pos++] = 953;
                break;
            }
            case '\u1fa1': {
                target[pos++] = 8033;
                target[pos++] = 953;
                break;
            }
            case '\u1fa2': {
                target[pos++] = 8034;
                target[pos++] = 953;
                break;
            }
            case '\u1fa3': {
                target[pos++] = 8035;
                target[pos++] = 953;
                break;
            }
            case '\u1fa4': {
                target[pos++] = 8036;
                target[pos++] = 953;
                break;
            }
            case '\u1fa5': {
                target[pos++] = 8037;
                target[pos++] = 953;
                break;
            }
            case '\u1fa6': {
                target[pos++] = 8038;
                target[pos++] = 953;
                break;
            }
            case '\u1fa7': {
                target[pos++] = 8039;
                target[pos++] = 953;
                break;
            }
            case '\u1fa8': {
                target[pos++] = 8032;
                target[pos++] = 953;
                break;
            }
            case '\u1fa9': {
                target[pos++] = 8033;
                target[pos++] = 953;
                break;
            }
            case '\u1faa': {
                target[pos++] = 8034;
                target[pos++] = 953;
                break;
            }
            case '\u1fab': {
                target[pos++] = 8035;
                target[pos++] = 953;
                break;
            }
            case '\u1fac': {
                target[pos++] = 8036;
                target[pos++] = 953;
                break;
            }
            case '\u1fad': {
                target[pos++] = 8037;
                target[pos++] = 953;
                break;
            }
            case '\u1fae': {
                target[pos++] = 8038;
                target[pos++] = 953;
                break;
            }
            case '\u1faf': {
                target[pos++] = 8039;
                target[pos++] = 953;
                break;
            }
            case '\u1fb2': {
                target[pos++] = 8048;
                target[pos++] = 953;
                break;
            }
            case '\u1fb3': {
                target[pos++] = 945;
                target[pos++] = 953;
                break;
            }
            case '\u1fb4': {
                target[pos++] = 940;
                target[pos++] = 953;
                break;
            }
            case '\u1fb6': {
                target[pos++] = 945;
                target[pos++] = 834;
                break;
            }
            case '\u1fb7': {
                target[pos++] = 945;
                target[pos++] = 834;
                target[pos++] = 953;
                break;
            }
            case '\u1fb8': {
                target[pos++] = 8112;
                break;
            }
            case '\u1fb9': {
                target[pos++] = 8113;
                break;
            }
            case '\u1fba': {
                target[pos++] = 8048;
                break;
            }
            case '\u1fbb': {
                target[pos++] = 8049;
                break;
            }
            case '\u1fbc': {
                target[pos++] = 945;
                target[pos++] = 953;
                break;
            }
            case '\u1fbe': {
                target[pos++] = 953;
                break;
            }
            case '\u1fc2': {
                target[pos++] = 8052;
                target[pos++] = 953;
                break;
            }
            case '\u1fc3': {
                target[pos++] = 951;
                target[pos++] = 953;
                break;
            }
            case '\u1fc4': {
                target[pos++] = 942;
                target[pos++] = 953;
                break;
            }
            case '\u1fc6': {
                target[pos++] = 951;
                target[pos++] = 834;
                break;
            }
            case '\u1fc7': {
                target[pos++] = 951;
                target[pos++] = 834;
                target[pos++] = 953;
                break;
            }
            case '\u1fc8': {
                target[pos++] = 8050;
                break;
            }
            case '\u1fc9': {
                target[pos++] = 8051;
                break;
            }
            case '\u1fca': {
                target[pos++] = 8052;
                break;
            }
            case '\u1fcb': {
                target[pos++] = 8053;
                break;
            }
            case '\u1fcc': {
                target[pos++] = 951;
                target[pos++] = 953;
                break;
            }
            case '\u1fd2': {
                target[pos++] = 953;
                target[pos++] = 776;
                target[pos++] = 768;
                break;
            }
            case '\u1fd3': {
                target[pos++] = 953;
                target[pos++] = 776;
                target[pos++] = 769;
                break;
            }
            case '\u1fd6': {
                target[pos++] = 953;
                target[pos++] = 834;
                break;
            }
            case '\u1fd7': {
                target[pos++] = 953;
                target[pos++] = 776;
                target[pos++] = 834;
                break;
            }
            case '\u1fd8': {
                target[pos++] = 8144;
                break;
            }
            case '\u1fd9': {
                target[pos++] = 8145;
                break;
            }
            case '\u1fda': {
                target[pos++] = 8054;
                break;
            }
            case '\u1fdb': {
                target[pos++] = 8055;
                break;
            }
            case '\u1fe2': {
                target[pos++] = 965;
                target[pos++] = 776;
                target[pos++] = 768;
                break;
            }
            case '\u1fe3': {
                target[pos++] = 965;
                target[pos++] = 776;
                target[pos++] = 769;
                break;
            }
            case '\u1fe4': {
                target[pos++] = 961;
                target[pos++] = 787;
                break;
            }
            case '\u1fe6': {
                target[pos++] = 965;
                target[pos++] = 834;
                break;
            }
            case '\u1fe7': {
                target[pos++] = 965;
                target[pos++] = 776;
                target[pos++] = 834;
                break;
            }
            case '\u1fe8': {
                target[pos++] = 8160;
                break;
            }
            case '\u1fe9': {
                target[pos++] = 8161;
                break;
            }
            case '\u1fea': {
                target[pos++] = 8058;
                break;
            }
            case '\u1feb': {
                target[pos++] = 8059;
                break;
            }
            case '\u1fec': {
                target[pos++] = 8165;
                break;
            }
            case '\u1ff2': {
                target[pos++] = 8060;
                target[pos++] = 953;
                break;
            }
            case '\u1ff3': {
                target[pos++] = 969;
                target[pos++] = 953;
                break;
            }
            case '\u1ff4': {
                target[pos++] = 974;
                target[pos++] = 953;
                break;
            }
            case '\u1ff6': {
                target[pos++] = 969;
                target[pos++] = 834;
                break;
            }
            case '\u1ff7': {
                target[pos++] = 969;
                target[pos++] = 834;
                target[pos++] = 953;
                break;
            }
            case '\u1ff8': {
                target[pos++] = 8056;
                break;
            }
            case '\u1ff9': {
                target[pos++] = 8057;
                break;
            }
            case '\u1ffa': {
                target[pos++] = 8060;
                break;
            }
            case '\u1ffb': {
                target[pos++] = 8061;
                break;
            }
            case '\u1ffc': {
                target[pos++] = 969;
                target[pos++] = 953;
                break;
            }
            case '\u2000': 
            case '\u2001': 
            case '\u2002': 
            case '\u2003': 
            case '\u2004': 
            case '\u2005': 
            case '\u2006': 
            case '\u2007': 
            case '\u2008': 
            case '\u2009': 
            case '\u200a': {
                target[pos++] = 32;
                break;
            }
            case '\u200b': 
            case '\u200c': 
            case '\u200d': 
            case '\u200e': 
            case '\u200f': {
                break;
            }
            case '\u2028': 
            case '\u2029': {
                target[pos++] = 32;
                break;
            }
            case '\u202a': 
            case '\u202b': 
            case '\u202c': 
            case '\u202d': 
            case '\u202e': {
                break;
            }
            case '\u202f': {
                target[pos++] = 32;
                break;
            }
            case '\u205f': {
                target[pos++] = 32;
                break;
            }
            case '\u2060': 
            case '\u2061': 
            case '\u2062': 
            case '\u2063': {
                break;
            }
            case '\u206a': 
            case '\u206b': 
            case '\u206c': 
            case '\u206d': 
            case '\u206e': 
            case '\u206f': {
                break;
            }
            case '\u20a8': {
                target[pos++] = 114;
                target[pos++] = 115;
                break;
            }
            case '\u2102': {
                target[pos++] = 99;
                break;
            }
            case '\u2103': {
                target[pos++] = 176;
                target[pos++] = 99;
                break;
            }
            case '\u2107': {
                target[pos++] = 603;
                break;
            }
            case '\u2109': {
                target[pos++] = 176;
                target[pos++] = 102;
                break;
            }
            case '\u210b': {
                target[pos++] = 104;
                break;
            }
            case '\u210c': {
                target[pos++] = 104;
                break;
            }
            case '\u210d': {
                target[pos++] = 104;
                break;
            }
            case '\u2110': {
                target[pos++] = 105;
                break;
            }
            case '\u2111': {
                target[pos++] = 105;
                break;
            }
            case '\u2112': {
                target[pos++] = 108;
                break;
            }
            case '\u2115': {
                target[pos++] = 110;
                break;
            }
            case '\u2116': {
                target[pos++] = 110;
                target[pos++] = 111;
                break;
            }
            case '\u2119': {
                target[pos++] = 112;
                break;
            }
            case '\u211a': {
                target[pos++] = 113;
                break;
            }
            case '\u211b': {
                target[pos++] = 114;
                break;
            }
            case '\u211c': {
                target[pos++] = 114;
                break;
            }
            case '\u211d': {
                target[pos++] = 114;
                break;
            }
            case '\u2120': {
                target[pos++] = 115;
                target[pos++] = 109;
                break;
            }
            case '\u2121': {
                target[pos++] = 116;
                target[pos++] = 101;
                target[pos++] = 108;
                break;
            }
            case '\u2122': {
                target[pos++] = 116;
                target[pos++] = 109;
                break;
            }
            case '\u2124': {
                target[pos++] = 122;
                break;
            }
            case '\u2126': {
                target[pos++] = 969;
                break;
            }
            case '\u2128': {
                target[pos++] = 122;
                break;
            }
            case '\u212a': {
                target[pos++] = 107;
                break;
            }
            case '\u212b': {
                target[pos++] = 229;
                break;
            }
            case '\u212c': {
                target[pos++] = 98;
                break;
            }
            case '\u212d': {
                target[pos++] = 99;
                break;
            }
            case '\u2130': {
                target[pos++] = 101;
                break;
            }
            case '\u2131': {
                target[pos++] = 102;
                break;
            }
            case '\u2133': {
                target[pos++] = 109;
                break;
            }
            case '\u213e': {
                target[pos++] = 947;
                break;
            }
            case '\u213f': {
                target[pos++] = 960;
                break;
            }
            case '\u2145': {
                target[pos++] = 100;
                break;
            }
            case '\u2160': {
                target[pos++] = 8560;
                break;
            }
            case '\u2161': {
                target[pos++] = 8561;
                break;
            }
            case '\u2162': {
                target[pos++] = 8562;
                break;
            }
            case '\u2163': {
                target[pos++] = 8563;
                break;
            }
            case '\u2164': {
                target[pos++] = 8564;
                break;
            }
            case '\u2165': {
                target[pos++] = 8565;
                break;
            }
            case '\u2166': {
                target[pos++] = 8566;
                break;
            }
            case '\u2167': {
                target[pos++] = 8567;
                break;
            }
            case '\u2168': {
                target[pos++] = 8568;
                break;
            }
            case '\u2169': {
                target[pos++] = 8569;
                break;
            }
            case '\u216a': {
                target[pos++] = 8570;
                break;
            }
            case '\u216b': {
                target[pos++] = 8571;
                break;
            }
            case '\u216c': {
                target[pos++] = 8572;
                break;
            }
            case '\u216d': {
                target[pos++] = 8573;
                break;
            }
            case '\u216e': {
                target[pos++] = 8574;
                break;
            }
            case '\u216f': {
                target[pos++] = 8575;
                break;
            }
            case '\u24b6': {
                target[pos++] = 9424;
                break;
            }
            case '\u24b7': {
                target[pos++] = 9425;
                break;
            }
            case '\u24b8': {
                target[pos++] = 9426;
                break;
            }
            case '\u24b9': {
                target[pos++] = 9427;
                break;
            }
            case '\u24ba': {
                target[pos++] = 9428;
                break;
            }
            case '\u24bb': {
                target[pos++] = 9429;
                break;
            }
            case '\u24bc': {
                target[pos++] = 9430;
                break;
            }
            case '\u24bd': {
                target[pos++] = 9431;
                break;
            }
            case '\u24be': {
                target[pos++] = 9432;
                break;
            }
            case '\u24bf': {
                target[pos++] = 9433;
                break;
            }
            case '\u24c0': {
                target[pos++] = 9434;
                break;
            }
            case '\u24c1': {
                target[pos++] = 9435;
                break;
            }
            case '\u24c2': {
                target[pos++] = 9436;
                break;
            }
            case '\u24c3': {
                target[pos++] = 9437;
                break;
            }
            case '\u24c4': {
                target[pos++] = 9438;
                break;
            }
            case '\u24c5': {
                target[pos++] = 9439;
                break;
            }
            case '\u24c6': {
                target[pos++] = 9440;
                break;
            }
            case '\u24c7': {
                target[pos++] = 9441;
                break;
            }
            case '\u24c8': {
                target[pos++] = 9442;
                break;
            }
            case '\u24c9': {
                target[pos++] = 9443;
                break;
            }
            case '\u24ca': {
                target[pos++] = 9444;
                break;
            }
            case '\u24cb': {
                target[pos++] = 9445;
                break;
            }
            case '\u24cc': {
                target[pos++] = 9446;
                break;
            }
            case '\u24cd': {
                target[pos++] = 9447;
                break;
            }
            case '\u24ce': {
                target[pos++] = 9448;
                break;
            }
            case '\u24cf': {
                target[pos++] = 9449;
                break;
            }
            case '\u3000': {
                target[pos++] = 32;
                break;
            }
            case '\u3371': {
                target[pos++] = 104;
                target[pos++] = 112;
                target[pos++] = 97;
                break;
            }
            case '\u3373': {
                target[pos++] = 97;
                target[pos++] = 117;
                break;
            }
            case '\u3375': {
                target[pos++] = 111;
                target[pos++] = 118;
                break;
            }
            case '\u3380': {
                target[pos++] = 112;
                target[pos++] = 97;
                break;
            }
            case '\u3381': {
                target[pos++] = 110;
                target[pos++] = 97;
                break;
            }
            case '\u3382': {
                target[pos++] = 956;
                target[pos++] = 97;
                break;
            }
            case '\u3383': {
                target[pos++] = 109;
                target[pos++] = 97;
                break;
            }
            case '\u3384': {
                target[pos++] = 107;
                target[pos++] = 97;
                break;
            }
            case '\u3385': {
                target[pos++] = 107;
                target[pos++] = 98;
                break;
            }
            case '\u3386': {
                target[pos++] = 109;
                target[pos++] = 98;
                break;
            }
            case '\u3387': {
                target[pos++] = 103;
                target[pos++] = 98;
                break;
            }
            case '\u338a': {
                target[pos++] = 112;
                target[pos++] = 102;
                break;
            }
            case '\u338b': {
                target[pos++] = 110;
                target[pos++] = 102;
                break;
            }
            case '\u338c': {
                target[pos++] = 956;
                target[pos++] = 102;
                break;
            }
            case '\u3390': {
                target[pos++] = 104;
                target[pos++] = 122;
                break;
            }
            case '\u3391': {
                target[pos++] = 107;
                target[pos++] = 104;
                target[pos++] = 122;
                break;
            }
            case '\u3392': {
                target[pos++] = 109;
                target[pos++] = 104;
                target[pos++] = 122;
                break;
            }
            case '\u3393': {
                target[pos++] = 103;
                target[pos++] = 104;
                target[pos++] = 122;
                break;
            }
            case '\u3394': {
                target[pos++] = 116;
                target[pos++] = 104;
                target[pos++] = 122;
                break;
            }
            case '\u33a9': {
                target[pos++] = 112;
                target[pos++] = 97;
                break;
            }
            case '\u33aa': {
                target[pos++] = 107;
                target[pos++] = 112;
                target[pos++] = 97;
                break;
            }
            case '\u33ab': {
                target[pos++] = 109;
                target[pos++] = 112;
                target[pos++] = 97;
                break;
            }
            case '\u33ac': {
                target[pos++] = 103;
                target[pos++] = 112;
                target[pos++] = 97;
                break;
            }
            case '\u33b4': {
                target[pos++] = 112;
                target[pos++] = 118;
                break;
            }
            case '\u33b5': {
                target[pos++] = 110;
                target[pos++] = 118;
                break;
            }
            case '\u33b6': {
                target[pos++] = 956;
                target[pos++] = 118;
                break;
            }
            case '\u33b7': {
                target[pos++] = 109;
                target[pos++] = 118;
                break;
            }
            case '\u33b8': {
                target[pos++] = 107;
                target[pos++] = 118;
                break;
            }
            case '\u33b9': {
                target[pos++] = 109;
                target[pos++] = 118;
                break;
            }
            case '\u33ba': {
                target[pos++] = 112;
                target[pos++] = 119;
                break;
            }
            case '\u33bb': {
                target[pos++] = 110;
                target[pos++] = 119;
                break;
            }
            case '\u33bc': {
                target[pos++] = 956;
                target[pos++] = 119;
                break;
            }
            case '\u33bd': {
                target[pos++] = 109;
                target[pos++] = 119;
                break;
            }
            case '\u33be': {
                target[pos++] = 107;
                target[pos++] = 119;
                break;
            }
            case '\u33bf': {
                target[pos++] = 109;
                target[pos++] = 119;
                break;
            }
            case '\u33c0': {
                target[pos++] = 107;
                target[pos++] = 969;
                break;
            }
            case '\u33c1': {
                target[pos++] = 109;
                target[pos++] = 969;
                break;
            }
            case '\u33c3': {
                target[pos++] = 98;
                target[pos++] = 113;
                break;
            }
            case '\u33c6': {
                target[pos++] = 99;
                target[pos++] = 8725;
                target[pos++] = 107;
                target[pos++] = 103;
                break;
            }
            case '\u33c7': {
                target[pos++] = 99;
                target[pos++] = 111;
                target[pos++] = 46;
                break;
            }
            case '\u33c8': {
                target[pos++] = 100;
                target[pos++] = 98;
                break;
            }
            case '\u33c9': {
                target[pos++] = 103;
                target[pos++] = 121;
                break;
            }
            case '\u33cb': {
                target[pos++] = 104;
                target[pos++] = 112;
                break;
            }
            case '\u33cd': {
                target[pos++] = 107;
                target[pos++] = 107;
                break;
            }
            case '\u33ce': {
                target[pos++] = 107;
                target[pos++] = 109;
                break;
            }
            case '\u33d7': {
                target[pos++] = 112;
                target[pos++] = 104;
                break;
            }
            case '\u33d9': {
                target[pos++] = 112;
                target[pos++] = 112;
                target[pos++] = 109;
                break;
            }
            case '\u33da': {
                target[pos++] = 112;
                target[pos++] = 114;
                break;
            }
            case '\u33dc': {
                target[pos++] = 115;
                target[pos++] = 118;
                break;
            }
            case '\u33dd': {
                target[pos++] = 119;
                target[pos++] = 98;
                break;
            }
            case '\ufb00': {
                target[pos++] = 102;
                target[pos++] = 102;
                break;
            }
            case '\ufb01': {
                target[pos++] = 102;
                target[pos++] = 105;
                break;
            }
            case '\ufb02': {
                target[pos++] = 102;
                target[pos++] = 108;
                break;
            }
            case '\ufb03': {
                target[pos++] = 102;
                target[pos++] = 102;
                target[pos++] = 105;
                break;
            }
            case '\ufb04': {
                target[pos++] = 102;
                target[pos++] = 102;
                target[pos++] = 108;
                break;
            }
            case '\ufb05': {
                target[pos++] = 115;
                target[pos++] = 116;
                break;
            }
            case '\ufb06': {
                target[pos++] = 115;
                target[pos++] = 116;
                break;
            }
            case '\ufb13': {
                target[pos++] = 1396;
                target[pos++] = 1398;
                break;
            }
            case '\ufb14': {
                target[pos++] = 1396;
                target[pos++] = 1381;
                break;
            }
            case '\ufb15': {
                target[pos++] = 1396;
                target[pos++] = 1387;
                break;
            }
            case '\ufb16': {
                target[pos++] = 1406;
                target[pos++] = 1398;
                break;
            }
            case '\ufb17': {
                target[pos++] = 1396;
                target[pos++] = 1389;
                break;
            }
            case '\ufe00': 
            case '\ufe01': 
            case '\ufe02': 
            case '\ufe03': 
            case '\ufe04': 
            case '\ufe05': 
            case '\ufe06': 
            case '\ufe07': 
            case '\ufe08': 
            case '\ufe09': 
            case '\ufe0a': 
            case '\ufe0b': 
            case '\ufe0c': 
            case '\ufe0d': 
            case '\ufe0e': 
            case '\ufe0f': {
                break;
            }
            case '\ufeff': {
                break;
            }
            case '\uff21': {
                target[pos++] = 65345;
                break;
            }
            case '\uff22': {
                target[pos++] = 65346;
                break;
            }
            case '\uff23': {
                target[pos++] = 65347;
                break;
            }
            case '\uff24': {
                target[pos++] = 65348;
                break;
            }
            case '\uff25': {
                target[pos++] = 65349;
                break;
            }
            case '\uff26': {
                target[pos++] = 65350;
                break;
            }
            case '\uff27': {
                target[pos++] = 65351;
                break;
            }
            case '\uff28': {
                target[pos++] = 65352;
                break;
            }
            case '\uff29': {
                target[pos++] = 65353;
                break;
            }
            case '\uff2a': {
                target[pos++] = 65354;
                break;
            }
            case '\uff2b': {
                target[pos++] = 65355;
                break;
            }
            case '\uff2c': {
                target[pos++] = 65356;
                break;
            }
            case '\uff2d': {
                target[pos++] = 65357;
                break;
            }
            case '\uff2e': {
                target[pos++] = 65358;
                break;
            }
            case '\uff2f': {
                target[pos++] = 65359;
                break;
            }
            case '\uff30': {
                target[pos++] = 65360;
                break;
            }
            case '\uff31': {
                target[pos++] = 65361;
                break;
            }
            case '\uff32': {
                target[pos++] = 65362;
                break;
            }
            case '\uff33': {
                target[pos++] = 65363;
                break;
            }
            case '\uff34': {
                target[pos++] = 65364;
                break;
            }
            case '\uff35': {
                target[pos++] = 65365;
                break;
            }
            case '\uff36': {
                target[pos++] = 65366;
                break;
            }
            case '\uff37': {
                target[pos++] = 65367;
                break;
            }
            case '\uff38': {
                target[pos++] = 65368;
                break;
            }
            case '\uff39': {
                target[pos++] = 65369;
                break;
            }
            case '\uff3a': {
                target[pos++] = 65370;
                break;
            }
            case '\ufff9': 
            case '\ufffa': 
            case '\ufffb': 
            case '\ufffc': {
                break;
            }
            default: {
                target[pos++] = c >= '\ud800' && c <= '\udfff' ? 65533 : c;
            }
        }
        return pos - start;
    }

    private static void checkProhibited(char c) throws InvalidCharacterException {
        if (c < '\u0221') {
            return;
        }
        switch (c) {
            case '\u0221': 
            case '\u038b': 
            case '\u038d': 
            case '\u03a2': 
            case '\u03cf': 
            case '\u0487': 
            case '\u04cf': 
            case '\u0560': 
            case '\u0588': 
            case '\u05a2': 
            case '\u05ba': 
            case '\u0620': 
            case '\u06ff': 
            case '\u070e': 
            case '\u0904': 
            case '\u0984': 
            case '\u09a9': 
            case '\u09b1': 
            case '\u09bd': 
            case '\u09de': 
            case '\u0a29': 
            case '\u0a31': 
            case '\u0a34': 
            case '\u0a37': 
            case '\u0a3d': 
            case '\u0a5d': 
            case '\u0a84': 
            case '\u0a8c': 
            case '\u0a8e': 
            case '\u0a92': 
            case '\u0aa9': 
            case '\u0ab1': 
            case '\u0ab4': 
            case '\u0ac6': 
            case '\u0aca': 
            case '\u0b04': 
            case '\u0b29': 
            case '\u0b31': 
            case '\u0b5e': 
            case '\u0b84': 
            case '\u0b91': 
            case '\u0b9b': 
            case '\u0b9d': 
            case '\u0bb6': 
            case '\u0bc9': 
            case '\u0c04': 
            case '\u0c0d': 
            case '\u0c11': 
            case '\u0c29': 
            case '\u0c34': 
            case '\u0c45': 
            case '\u0c49': 
            case '\u0c84': 
            case '\u0c8d': 
            case '\u0c91': 
            case '\u0ca9': 
            case '\u0cb4': 
            case '\u0cc5': 
            case '\u0cc9': 
            case '\u0cdf': 
            case '\u0d04': 
            case '\u0d0d': 
            case '\u0d11': 
            case '\u0d29': 
            case '\u0d49': 
            case '\u0d84': 
            case '\u0db2': 
            case '\u0dbc': 
            case '\u0dd5': 
            case '\u0dd7': 
            case '\u0e83': 
            case '\u0e89': 
            case '\u0e98': 
            case '\u0ea0': 
            case '\u0ea4': 
            case '\u0ea6': 
            case '\u0eac': 
            case '\u0eba': 
            case '\u0ec5': 
            case '\u0ec7': 
            case '\u0f48': 
            case '\u0f98': 
            case '\u0fbd': 
            case '\u1022': 
            case '\u1028': 
            case '\u102b': 
            case '\u1207': 
            case '\u1247': 
            case '\u1249': 
            case '\u1257': 
            case '\u1259': 
            case '\u1287': 
            case '\u1289': 
            case '\u12af': 
            case '\u12b1': 
            case '\u12bf': 
            case '\u12c1': 
            case '\u12cf': 
            case '\u12d7': 
            case '\u12ef': 
            case '\u130f': 
            case '\u1311': 
            case '\u131f': 
            case '\u1347': 
            case '\u170d': 
            case '\u176d': 
            case '\u1771': 
            case '\u180f': 
            case '\u1f58': 
            case '\u1f5a': 
            case '\u1f5c': 
            case '\u1f5e': 
            case '\u1fb5': 
            case '\u1fc5': 
            case '\u1fdc': 
            case '\u1ff5': 
            case '\u1fff': 
            case '\u24ff': 
            case '\u2618': 
            case '\u2705': 
            case '\u2728': 
            case '\u274c': 
            case '\u274e': 
            case '\u2757': 
            case '\u27b0': 
            case '\u2e9a': 
            case '\u3040': 
            case '\u318f': 
            case '\u32ff': 
            case '\u33ff': 
            case '\ufb37': 
            case '\ufb3d': 
            case '\ufb3f': 
            case '\ufb42': 
            case '\ufb45': 
            case '\ufe53': 
            case '\ufe67': 
            case '\ufe75': 
            case '\uff00': 
            case '\uffe7': {
                throw new InvalidCharacterException((int)c);
            }
        }
        if (c >= '\u0234' && c <= '\u024f') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u02ae' && c <= '\u02af') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u02ef' && c <= '\u02ff') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0350' && c <= '\u035f') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0370' && c <= '\u0373') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0376' && c <= '\u0379') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u037b' && c <= '\u037d') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u037f' && c <= '\u0383') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u03f7' && c <= '\u03ff') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u04f6' && c <= '\u04f7') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u04fa' && c <= '\u04ff') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0510' && c <= '\u0530') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0557' && c <= '\u0558') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u058b' && c <= '\u0590') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u05c5' && c <= '\u05cf') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u05eb' && c <= '\u05ef') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u05f5' && c <= '\u060b') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u060d' && c <= '\u061a') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u061c' && c <= '\u061e') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u063b' && c <= '\u063f') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0656' && c <= '\u065f') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u06ee' && c <= '\u06ef') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u072d' && c <= '\u072f') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u074b' && c <= '\u077f') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u07b2' && c <= '\u0900') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u093a' && c <= '\u093b') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u094e' && c <= '\u094f') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0955' && c <= '\u0957') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0971' && c <= '\u0980') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u098d' && c <= '\u098e') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0991' && c <= '\u0992') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u09b3' && c <= '\u09b5') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u09ba' && c <= '\u09bb') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u09c5' && c <= '\u09c6') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u09c9' && c <= '\u09ca') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u09ce' && c <= '\u09d6') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u09d8' && c <= '\u09db') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u09e4' && c <= '\u09e5') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u09fb' && c <= '\u0a01') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0a03' && c <= '\u0a04') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0a0b' && c <= '\u0a0e') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0a11' && c <= '\u0a12') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0a3a' && c <= '\u0a3b') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0a43' && c <= '\u0a46') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0a49' && c <= '\u0a4a') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0a4e' && c <= '\u0a58') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0a5f' && c <= '\u0a65') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0a75' && c <= '\u0a80') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0aba' && c <= '\u0abb') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0ace' && c <= '\u0acf') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0ad1' && c <= '\u0adf') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0ae1' && c <= '\u0ae5') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0af0' && c <= '\u0b00') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b0d' && c <= '\u0b0e') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b11' && c <= '\u0b12') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b34' && c <= '\u0b35') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b3a' && c <= '\u0b3b') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b44' && c <= '\u0b46') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b49' && c <= '\u0b4a') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b4e' && c <= '\u0b55') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b58' && c <= '\u0b5b') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b62' && c <= '\u0b65') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b71' && c <= '\u0b81') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b8b' && c <= '\u0b8d') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0b96' && c <= '\u0b98') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0ba0' && c <= '\u0ba2') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0ba5' && c <= '\u0ba7') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0bab' && c <= '\u0bad') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0bba' && c <= '\u0bbd') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0bc3' && c <= '\u0bc5') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0bce' && c <= '\u0bd6') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0bd8' && c <= '\u0be6') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\u0bf3' && c <= '\u0c00') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\ue000' && c <= '\uf8ff') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\ufdd0' && c <= '\ufdef') {
            throw new InvalidCharacterException((int)c);
        }
        if (c == '\ufffe' || c == '\uffff') {
            throw new InvalidCharacterException((int)c);
        }
        if (c >= '\ud800' && c <= '\udfff') {
            throw new InvalidCharacterException((int)c);
        }
        switch (c) {
            case '\u0340': 
            case '\u0341': 
            case '\u200e': 
            case '\u200f': 
            case '\u202a': 
            case '\u202b': 
            case '\u202c': 
            case '\u202d': 
            case '\u202e': 
            case '\u206a': 
            case '\u206b': 
            case '\u206c': 
            case '\u206d': 
            case '\u206e': 
            case '\u206f': {
                throw new InvalidCharacterException((int)c);
            }
        }
        if (c == '\ufffd') {
            throw new InvalidCharacterException((int)c);
        }
    }

    public static String bidi(String str) {
        return str;
    }

    public static StringBuilder bidi(char[] array) {
        StringBuilder sb = new StringBuilder(array == null ? 0 : array.length);
        if (array != null) {
            sb.append(array);
        }
        return sb;
    }

    private static String insignifiantCharTelephoneNumber(String str) {
        if (Strings.isEmpty((String)str)) {
            return "";
        }
        char[] array = str.toCharArray();
        boolean isSpaceOrHyphen = false;
        char soh = '\u0000';
        int pos = 0;
        block3: for (char c : array) {
            switch (c) {
                case ' ': 
                case '-': 
                case '\u058a': 
                case '\u2010': 
                case '\u2011': 
                case '\u2212': 
                case '\ufe63': 
                case '\uff0d': {
                    soh = c;
                    continue block3;
                }
                default: {
                    if (isSpaceOrHyphen && PrepareString.isCombiningMark(c)) {
                        array[pos++] = soh;
                        isSpaceOrHyphen = false;
                    }
                    array[pos++] = c;
                }
            }
        }
        return new String(array, 0, pos);
    }

    private static String insignifiantCharNumericString(String str) {
        if (Strings.isEmpty((String)str)) {
            return "";
        }
        char[] array = str.toCharArray();
        boolean isSpace = false;
        int pos = 0;
        for (char c : array) {
            if (c != ' ') {
                if (isSpace && PrepareString.isCombiningMark(c)) {
                    array[pos++] = 32;
                    isSpace = false;
                }
                array[pos++] = c;
                continue;
            }
            isSpace = true;
        }
        return new String(array, 0, pos);
    }

    private static String insignifiantSpacesString(String str, boolean caseSensitive) throws InvalidCharacterException {
        int start;
        if (Strings.isEmpty((String)str)) {
            return "";
        }
        char[] array = str.toCharArray();
        char[] target = new char[str.length() * 3 + 2];
        int pos = 0;
        char lowerCase = (char)(caseSensitive ? 0 : 32);
        for (char c : array) {
            pos += PrepareString.map(c, target, pos, lowerCase);
        }
        int limit = pos;
        pos = 0;
        int i = 0;
        char c = '\u0000';
        for (i = 0; i < limit; ++i) {
            c = target[i];
            if (c == ' ') continue;
            PrepareString.checkProhibited(c);
            break;
        }
        if ((start = i) == limit) {
            return " ";
        }
        if (PrepareString.isCombiningMark(c)) {
            if (start == 0) {
                throw new InvalidCharacterException((int)c);
            }
            target[pos++] = 32;
            target[pos++] = c;
            ++start;
        } else {
            target[pos++] = c;
            ++start;
        }
        for (i = limit - 1; i > start && target[i] == ' '; --i) {
        }
        limit = i + 1;
        boolean spaceSeen = false;
        boolean space2Seen = false;
        for (i = start; i < limit; ++i) {
            c = target[i];
            PrepareString.checkProhibited(c);
            if (PrepareString.isCombiningMark(c)) {
                if (spaceSeen) {
                    if (space2Seen) {
                        target[pos++] = 32;
                    }
                    target[pos++] = 32;
                    target[pos++] = c;
                    spaceSeen = false;
                    space2Seen = false;
                    continue;
                }
                target[pos++] = c;
                continue;
            }
            if (c == ' ') {
                if (spaceSeen) {
                    space2Seen = true;
                    continue;
                }
                spaceSeen = true;
                continue;
            }
            if (spaceSeen) {
                target[pos++] = 32;
                spaceSeen = false;
                space2Seen = false;
            }
            target[pos++] = c;
        }
        return new String(target, 0, pos);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StringType {
        NOT_STRING,
        NUMERIC_STRING,
        CASE_EXACT,
        CASE_EXACT_IA5,
        CASE_IGNORE_IA5,
        CASE_IGNORE_LIST,
        CASE_IGNORE,
        DIRECTORY_STRING,
        TELEPHONE_NUMBER,
        WORD;

    }
}

