/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema;

import java.util.List;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.model.schema.DescriptionUtils;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.model.schema.UsageEnum;
import org.apache.directory.shared.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.model.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeType
extends AbstractSchemaObject
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeType.class);
    private String syntaxOid;
    private LdapSyntax syntax;
    private String equalityOid;
    private MatchingRule equality;
    private String substringOid;
    private MatchingRule substring;
    private String orderingOid;
    private MatchingRule ordering;
    private String superiorOid;
    private AttributeType superior;
    private boolean isSingleValued = false;
    private boolean isCollective = false;
    private boolean canUserModify = true;
    private UsageEnum usage = UsageEnum.USER_APPLICATIONS;
    private long syntaxLength = 0L;

    public AttributeType(String oid) {
        super(SchemaObjectType.ATTRIBUTE_TYPE, oid);
    }

    @Override
    public void removeFromRegistries(List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
            attributeTypeRegistry.removeMappingFor(this);
            attributeTypeRegistry.unregisterDescendants(this, this.superior);
            if (this.equality != null) {
                registries.delReference(this, this.equality);
            }
            if (this.ordering != null) {
                registries.delReference(this, this.ordering);
            }
            if (this.substring != null) {
                registries.delReference(this, this.substring);
            }
            if (this.syntax != null) {
                registries.delReference(this, this.syntax);
            }
            if (this.superior != null) {
                registries.delReference(this, this.superior);
            }
        }
    }

    public boolean isSingleValued() {
        return this.isSingleValued;
    }

    public void setSingleValued(boolean singleValued) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.isSingleValued = singleValued;
        }
    }

    public boolean isUserModifiable() {
        return this.canUserModify;
    }

    public void setUserModifiable(boolean userModifiable) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.canUserModify = userModifiable;
        }
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public void updateCollective(boolean collective) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.isCollective = collective;
    }

    public void setCollective(boolean collective) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.isCollective = collective;
        }
    }

    public UsageEnum getUsage() {
        return this.usage;
    }

    public void setUsage(UsageEnum usage) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.usage = usage;
        }
    }

    public void updateUsage(UsageEnum newUsage) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.usage = newUsage;
    }

    public long getSyntaxLength() {
        return this.syntaxLength;
    }

    public void setSyntaxLength(long length) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.syntaxLength = length;
        }
    }

    public AttributeType getSuperior() {
        return this.superior;
    }

    public String getSuperiorOid() {
        return this.superiorOid;
    }

    public String getSuperiorName() {
        if (this.superior != null) {
            return this.superior.getName();
        }
        return this.superiorOid;
    }

    public void setSuperiorOid(String superiorOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.superiorOid = superiorOid;
        }
    }

    public void setSuperior(AttributeType superior) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.superior = superior;
            this.superiorOid = superior.getOid();
        }
    }

    public void setSuperior(String newSuperiorOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.superiorOid = newSuperiorOid;
        }
    }

    public void updateSuperior(AttributeType newSuperior) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.superior = newSuperior;
        this.superiorOid = newSuperior.getOid();
    }

    public LdapSyntax getSyntax() {
        return this.syntax;
    }

    public String getSyntaxName() {
        if (this.syntax != null) {
            return this.syntax.getName();
        }
        return this.syntaxOid;
    }

    public String getSyntaxOid() {
        return this.syntaxOid;
    }

    public void setSyntaxOid(String syntaxOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.syntaxOid = syntaxOid;
        }
    }

    public void setSyntax(LdapSyntax syntax) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.syntax = syntax;
            this.syntaxOid = syntax.getOid();
        }
    }

    public void updateSyntax(LdapSyntax newSyntax) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.syntax = newSyntax;
        this.syntaxOid = newSyntax.getOid();
    }

    public MatchingRule getEquality() {
        return this.equality;
    }

    public String getEqualityOid() {
        return this.equalityOid;
    }

    public String getEqualityName() {
        if (this.equality != null) {
            return this.equality.getName();
        }
        return this.equalityOid;
    }

    public void setEqualityOid(String equalityOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.equalityOid = equalityOid;
        }
    }

    public void setEquality(MatchingRule equality) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.equality = equality;
            this.equalityOid = equality.getOid();
        }
    }

    public void updateEquality(MatchingRule newEquality) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.equality = newEquality;
        this.equalityOid = newEquality.getOid();
    }

    public MatchingRule getOrdering() {
        return this.ordering;
    }

    public String getOrderingName() {
        if (this.ordering != null) {
            return this.ordering.getName();
        }
        return this.orderingOid;
    }

    public String getOrderingOid() {
        return this.orderingOid;
    }

    public void setOrderingOid(String orderingOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.orderingOid = orderingOid;
        }
    }

    public void setOrdering(MatchingRule ordering) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.ordering = ordering;
            this.orderingOid = ordering.getOid();
        }
    }

    public void updateOrdering(MatchingRule newOrdering) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.ordering = newOrdering;
        this.orderingOid = newOrdering.getOid();
    }

    public MatchingRule getSubstring() {
        return this.substring;
    }

    public String getSubstringName() {
        if (this.substring != null) {
            return this.substring.getName();
        }
        return this.substringOid;
    }

    public String getSubstringOid() {
        return this.substringOid;
    }

    public void setSubstringOid(String substrOid) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.substringOid = substrOid;
        }
    }

    public void setSubstring(MatchingRule substring) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.substring = substring;
            this.substringOid = substring.getOid();
        }
    }

    public void updateSubstring(MatchingRule newSubstring) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04441, (Object[])new Object[]{this.getName()}));
        }
        this.substring = newSubstring;
        this.substringOid = newSubstring.getOid();
    }

    public boolean isAncestorOf(AttributeType descendant) {
        if (descendant == null || this.equals(descendant)) {
            return false;
        }
        return this.isAncestorOrEqual(this, descendant);
    }

    public boolean isDescendantOf(AttributeType ancestor) {
        if (ancestor == null || this.equals(ancestor)) {
            return false;
        }
        return this.isAncestorOrEqual(ancestor, this);
    }

    private boolean isAncestorOrEqual(AttributeType ancestor, AttributeType descendant) {
        if (ancestor == null || descendant == null) {
            return false;
        }
        if (ancestor.equals(descendant)) {
            return true;
        }
        return this.isAncestorOrEqual(ancestor, descendant.getSuperior());
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public AttributeType copy() {
        AttributeType copy = new AttributeType(this.oid);
        copy.copy(this);
        copy.canUserModify = this.canUserModify;
        copy.isCollective = this.isCollective;
        copy.isSingleValued = this.isSingleValued;
        copy.usage = this.usage;
        copy.equality = null;
        copy.equalityOid = this.equalityOid;
        copy.ordering = null;
        copy.orderingOid = this.orderingOid;
        copy.substring = null;
        copy.substringOid = this.substringOid;
        copy.superior = null;
        copy.superiorOid = this.superiorOid;
        copy.syntax = null;
        copy.syntaxOid = this.syntaxOid;
        copy.syntaxLength = this.syntaxLength;
        return copy;
    }

    @Override
    public void clear() {
        super.clear();
        this.equality = null;
        this.ordering = null;
        this.substring = null;
        this.superior = null;
        this.syntax = null;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AttributeType)) {
            return false;
        }
        AttributeType that = (AttributeType)o;
        if (this.isCollective != that.isCollective) {
            return false;
        }
        if (this.isSingleValued != that.isSingleValued) {
            return false;
        }
        if (this.canUserModify != that.canUserModify) {
            return false;
        }
        if (this.usage != that.usage) {
            return false;
        }
        if (!this.compareOid(this.equalityOid, that.equalityOid)) {
            return false;
        }
        if (this.equality != null ? !this.equality.equals(that.equality) : that.equality != null) {
            return false;
        }
        if (!this.compareOid(this.orderingOid, that.orderingOid)) {
            return false;
        }
        if (this.ordering != null ? !this.ordering.equals(that.ordering) : that.ordering != null) {
            return false;
        }
        if (!this.compareOid(this.substringOid, that.substringOid)) {
            return false;
        }
        if (this.substring != null ? !this.substring.equals(that.substring) : that.substring != null) {
            return false;
        }
        if (!this.compareOid(this.superiorOid, that.superiorOid)) {
            return false;
        }
        if (this.superior != null ? !this.superior.equals(that.superior) : that.superior != null) {
            return false;
        }
        if (!this.compareOid(this.syntaxOid, that.syntaxOid)) {
            return false;
        }
        if (this.syntaxLength != that.syntaxLength) {
            return false;
        }
        if (this.syntax == null) {
            return that.syntax == null;
        }
        if (this.syntax.equals(that.syntax)) {
            return this.syntaxLength == that.syntaxLength;
        }
        return false;
    }
}

