/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.message;

import java.util.Arrays;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindResponse;
import org.apache.directory.shared.ldap.model.message.BindResponseImpl;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindRequestImpl
extends AbstractAbandonableRequest
implements BindRequest {
    private static final Logger LOG = LoggerFactory.getLogger(BindRequestImpl.class);
    private Dn dn;
    private String name;
    private byte[] credentials;
    private int hCredentials = 0;
    private String mechanism;
    private boolean isSimple = true;
    private boolean isVersion3 = true;
    public BindResponse response;

    public BindRequestImpl() {
        super(-1, TYPE);
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public boolean getSimple() {
        return this.isSimple;
    }

    public BindRequest setSimple(boolean simple) {
        this.isSimple = simple;
        return this;
    }

    public byte[] getCredentials() {
        return this.credentials;
    }

    public BindRequest setCredentials(String credentials) {
        return this.setCredentials(Strings.getBytesUtf8((String)credentials));
    }

    public BindRequest setCredentials(byte[] credentials) {
        if (credentials != null) {
            this.credentials = new byte[credentials.length];
            System.arraycopy(credentials, 0, this.credentials, 0, credentials.length);
        } else {
            this.credentials = null;
        }
        if (credentials != null) {
            this.hCredentials = 0;
            for (byte b : credentials) {
                this.hCredentials = this.hCredentials * 31 + b;
            }
        } else {
            this.hCredentials = 0;
        }
        return this;
    }

    public String getSaslMechanism() {
        return this.mechanism;
    }

    public BindRequest setSaslMechanism(String saslMechanism) {
        this.isSimple = false;
        this.mechanism = saslMechanism;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BindRequest setName(String name) {
        this.name = name;
        try {
            this.dn = new Dn(name);
        }
        catch (LdapInvalidDnException e) {
            LOG.warn("Enable to convert the name to a DN.", (Throwable)e);
            this.dn = null;
        }
        return this;
    }

    public Dn getDn() {
        return this.dn;
    }

    public BindRequest setDn(Dn dn) {
        this.dn = dn;
        this.name = dn.getName();
        return this;
    }

    public boolean isVersion3() {
        return this.isVersion3;
    }

    public boolean getVersion3() {
        return this.isVersion3;
    }

    public BindRequest setVersion3(boolean version3) {
        this.isVersion3 = version3;
        return this;
    }

    public BindRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public BindRequest addControl(Control control) throws MessageException {
        return (BindRequest)super.addControl(control);
    }

    public BindRequest addAllControls(Control[] controls) throws MessageException {
        return (BindRequest)super.addAllControls(controls);
    }

    public BindRequest removeControl(Control control) throws MessageException {
        return (BindRequest)super.removeControl(control);
    }

    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    public BindResponse getResultResponse() {
        if (this.response == null) {
            this.response = new BindResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    public void abandon() {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04185, (Object[])new Object[0]));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BindRequest)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BindRequest req = (BindRequest)obj;
        if (req.isSimple() != this.isSimple()) {
            return false;
        }
        if (req.isVersion3() != this.isVersion3()) {
            return false;
        }
        String name1 = req.getName();
        String name2 = this.getName();
        if (Strings.isEmpty((String)name1)) {
            if (!Strings.isEmpty((String)name2)) {
                return false;
            }
        } else {
            if (Strings.isEmpty((String)name2)) {
                return false;
            }
            if (!name2.equals(name1)) {
                return false;
            }
        }
        Dn dn1 = req.getDn();
        Dn dn2 = this.getDn();
        if (Dn.isNullOrEmpty(dn1)) {
            if (!Dn.isNullOrEmpty(dn2)) {
                return false;
            }
        } else {
            if (Dn.isNullOrEmpty(dn2)) {
                return false;
            }
            if (!dn1.equals(dn2)) {
                return false;
            }
        }
        return Arrays.equals(req.getCredentials(), this.getCredentials());
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + (this.credentials == null ? 0 : this.hCredentials);
        hash = hash * 17 + (this.isSimple ? 0 : 1);
        hash = hash * 17 + (this.isVersion3 ? 0 : 1);
        hash = hash * 17 + (this.mechanism == null ? 0 : this.mechanism.hashCode());
        hash = hash * 17 + (this.name == null ? 0 : this.name.hashCode());
        hash = hash * 17 + (this.response == null ? 0 : this.response.hashCode());
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    BindRequest\n");
        sb.append("        Version : '").append(this.isVersion3 ? "3" : "2").append("'\n");
        if ((Strings.isEmpty((String)this.name) || this.dn == null || Strings.isEmpty((String)this.dn.getNormName())) && this.isSimple) {
            sb.append("        Name : anonymous\n");
        } else {
            sb.append("        Name : '").append(this.name.toString()).append("'\n");
            if (this.isSimple) {
                sb.append("        Simple authentication : '").append(Strings.utf8ToString((byte[])this.credentials)).append('/').append(Strings.dumpBytes((byte[])this.credentials)).append("'\n");
            } else {
                sb.append("        Sasl credentials\n");
                sb.append("            Mechanism :'").append(this.mechanism).append("'\n");
                if (this.credentials == null) {
                    sb.append("            Credentials : null");
                } else {
                    sb.append("            Credentials : (omitted-for-safety)");
                }
            }
        }
        return super.toString(sb.toString());
    }
}

