/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.EqualityEvaluator;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

public class EqualityCursor<V, ID extends Comparable<ID>>
extends AbstractIndexCursor<V, Entry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_714, (Object[])new Object[0]);
    private final EqualityEvaluator<V, ID> equalityEvaluator;
    private final IndexCursor<V, Entry, ID> userIdxCursor;
    private final IndexCursor<String, Entry, ID> uuidIdxCursor;

    public EqualityCursor(Store<Entry, ID> db, EqualityEvaluator<V, ID> equalityEvaluator) throws Exception {
        this.equalityEvaluator = equalityEvaluator;
        AttributeType attributeType = equalityEvaluator.getExpression().getAttributeType();
        Value value = equalityEvaluator.getExpression().getValue();
        if (db.hasIndexOn(attributeType)) {
            Index<?, Entry, ID> userIndex = db.getIndex(attributeType);
            this.userIdxCursor = userIndex.forwardCursor(value.getValue());
            this.uuidIdxCursor = null;
        } else {
            this.uuidIdxCursor = db.getEntryUuidIndex().forwardCursor();
            this.userIdxCursor = null;
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public boolean available() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.available();
        }
        return super.available();
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeValue(id, value);
        } else {
            super.beforeValue(id, value);
        }
    }

    @Override
    public void before(IndexEntry<V, ID> element) throws Exception {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.before(element);
        } else {
            super.before(element);
        }
    }

    @Override
    public void afterValue(ID id, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterValue(id, value);
        } else {
            super.afterValue(id, value);
        }
    }

    @Override
    public void after(IndexEntry<V, ID> element) throws Exception {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.after(element);
        } else {
            super.after(element);
        }
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.uuidIdxCursor.beforeFirst();
        }
        this.setAvailable(false);
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.uuidIdxCursor.afterLast();
        }
        this.setAvailable(false);
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.previous();
        }
        while (this.uuidIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.equalityEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public boolean next() throws Exception {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.next();
        }
        while (this.uuidIdxCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.equalityEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public IndexEntry<V, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            return (IndexEntry)this.userIdxCursor.get();
        }
        if (this.available()) {
            return (IndexEntry)this.uuidIdxCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() throws Exception {
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.uuidIdxCursor.close();
        }
    }
}

