/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.log.impl;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.log.impl.LogFileManager;

class DefaultLogFileManager
implements LogFileManager {
    private String logFilePath;
    private String suffix;

    DefaultLogFileManager() {
    }

    @Override
    public void init(String logFilepath, String suffix) {
        this.logFilePath = this.logFilePath;
        this.suffix = suffix;
    }

    @Override
    public LogFileReader getReaderForLogFile(long logFileNumber) throws IOException, FileNotFoundException {
        File logFile = this.makeLogFileName(logFileNumber);
        RandomAccessFile raf = new RandomAccessFile(logFile, "r");
        return new LogFileReader(raf, logFileNumber);
    }

    @Override
    public LogFileWriter getWriterForLogFile(long logFileNumber) throws IOException, FileNotFoundException {
        File logFile = this.makeLogFileName(logFileNumber);
        RandomAccessFile raf = new RandomAccessFile(logFile, "rw");
        return new LogFileWriter(raf, logFileNumber);
    }

    @Override
    public boolean createLogFile(long logFileNumber) throws IOException {
        File logFile = this.makeLogFileName(logFileNumber);
        boolean fileAlreadyExists = !logFile.createNewFile();
        return fileAlreadyExists;
    }

    @Override
    public void truncateLogFile(long logFileNumber, long size) throws IOException, FileNotFoundException {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid file size is specified for the log file: " + logFileNumber + " " + size);
        }
        File logFile = this.makeLogFileName(logFileNumber);
        RandomAccessFile raf = new RandomAccessFile(logFile, "rw");
        raf.setLength(size);
        raf.getFD().sync();
    }

    @Override
    public void deleteLogFile(long logFileNumber) throws IOException {
        File logFile = this.makeLogFileName(logFileNumber);
        if (!logFile.delete()) {
            throw new IOException(I18n.err((I18n)I18n.ERR_113_COULD_NOT_DELETE_FILE_OR_DIRECTORY, (Object[])new Object[]{logFile}));
        }
    }

    @Override
    public boolean rename(long originalLogFileNumber, long newLongFileNumber) {
        File oldLogFile = this.makeLogFileName(originalLogFileNumber);
        boolean result = oldLogFile.renameTo(this.makeLogFileName(newLongFileNumber));
        return result;
    }

    private File makeLogFileName(long logFileNumber) {
        return new File(this.logFilePath + "/" + "log_" + logFileNumber + "." + this.suffix);
    }

    static class LogFileWriter
    implements LogFileManager.LogFileWriter {
        RandomAccessFile raf;
        long logFileNumber;

        public LogFileWriter(RandomAccessFile raf, long logFileNumber) {
            this.raf = raf;
            this.logFileNumber = logFileNumber;
        }

        @Override
        public void append(byte[] buffer, int offset, int length) throws IOException {
            this.raf.write(buffer, offset, length);
        }

        @Override
        public void sync() throws IOException {
            this.raf.getFD().sync();
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }

        @Override
        public long logFileNumber() {
            return this.logFileNumber;
        }

        @Override
        public long getLength() throws IOException {
            return this.raf.length();
        }
    }

    static class LogFileReader
    implements LogFileManager.LogFileReader {
        RandomAccessFile raf;
        long logFileNumber;

        public LogFileReader(RandomAccessFile raf, long logFileNumber) {
            this.raf = raf;
            this.logFileNumber = logFileNumber;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException, EOFException {
            this.raf.readFully(buffer, offset, length);
            return length;
        }

        @Override
        public void seek(long position) throws IOException {
            this.raf.seek(position);
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }

        @Override
        public long logFileNumber() {
            return this.logFileNumber;
        }

        @Override
        public long getLength() throws IOException {
            return this.raf.length();
        }

        @Override
        public long getOffset() throws IOException {
            return this.raf.getFilePointer();
        }
    }
}

