/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.log;

import org.apache.directory.server.i18n.I18n;

public class LogAnchor {
    public static final long UNKNOWN_LSN = Long.MIN_VALUE;
    public static final long MIN_LOG_NUMBER = 0L;
    public static final long MIN_LOG_OFFSET = 0L;
    private long logFileNumber = 0L;
    private long logFileOffset = 0L;
    private long logLSN = Long.MIN_VALUE;

    public LogAnchor() {
    }

    public LogAnchor(long logFileNumber, long logFileOffset, long logLSN) {
        this.resetLogAnchor(logFileNumber, logFileOffset, logLSN);
    }

    public void resetLogAnchor(long logFileNumber, long logFileOffset, long logLSN) {
        if (logFileNumber < 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_746, (Object[])new Object[]{logFileNumber}));
        }
        if (logFileOffset < 0L) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_747, (Object[])new Object[]{logFileOffset}));
        }
        this.logFileNumber = logFileNumber;
        this.logFileOffset = logFileOffset;
        this.logLSN = logLSN;
    }

    public void resetLogAnchor(LogAnchor logAnchor) {
        this.resetLogAnchor(logAnchor.getLogFileNumber(), logAnchor.getLogFileOffset(), logAnchor.getLogLSN());
    }

    public long getLogFileNumber() {
        return this.logFileNumber;
    }

    public long getLogFileOffset() {
        return this.logFileOffset;
    }

    public long getLogLSN() {
        return this.logLSN;
    }
}

