/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import jdbm.btree.BTree;
import jdbm.helper.Serializer;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexValueSerializer
implements Serializer {
    private static final long serialVersionUID = 1L;
    private static byte LONG_VALUE = 0;
    private static byte AVL_TREE_VALUE = 0;
    private static byte BTREE_VALUE = 0;
    private static final Logger LOG = LoggerFactory.getLogger(IndexValueSerializer.class);

    public Object deserialize(byte[] serialized) throws IOException {
        return null;
    }

    public byte[] serialize(Object obj) throws IOException {
        if (obj instanceof ArrayTree) {
            LOG.debug("Serializing an AvlTree");
            return this.serialize((ArrayTree)obj);
        }
        if (obj instanceof BTree) {
            LOG.debug("Serializing a BTree");
            return this.serialize((BTree)obj);
        }
        LOG.debug("Serializing a long [{}]", obj);
        return this.serialize((Long)obj);
    }

    private byte[] serialize(Long value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.write(LONG_VALUE);
        out.writeLong(value);
        out.flush();
        if (LOG.isDebugEnabled()) {
            LOG.debug(">------------------------------------------------");
            LOG.debug("Serializes a LONG value");
        }
        return baos.toByteArray();
    }

    private byte[] serialize(BTree bTree) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.write(BTREE_VALUE);
        out.flush();
        if (LOG.isDebugEnabled()) {
            LOG.debug(">------------------------------------------------");
            LOG.debug("Serializes an BTree");
        }
        return baos.toByteArray();
    }

    private byte[] serialize(ArrayTree<?> arrayTree) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.write(AVL_TREE_VALUE);
        out.flush();
        if (LOG.isDebugEnabled()) {
            LOG.debug(">------------------------------------------------");
            LOG.debug("Serializes an AVL tree");
        }
        return baos.toByteArray();
    }
}

