/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import java.net.InetSocketAddress;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.AsyncCallback;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookkeeperInternalCallbacks {
    static final Logger LOG = LoggerFactory.getLogger(BookkeeperInternalCallbacks.class);

    public static interface Processor<T> {
        public void process(T var1, AsyncCallback.VoidCallback var2);
    }

    public static class MultiCallback
    implements AsyncCallback.VoidCallback {
        final int expected;
        final int failureRc;
        final int successRc;
        final AsyncCallback.VoidCallback cb;
        final Object context;
        final AtomicInteger done = new AtomicInteger();
        final LinkedBlockingQueue<Integer> exceptions = new LinkedBlockingQueue();

        public MultiCallback(int expected, AsyncCallback.VoidCallback cb, Object context, int successRc, int failureRc) {
            this.expected = expected;
            this.cb = cb;
            this.context = context;
            this.failureRc = failureRc;
            this.successRc = successRc;
            if (expected == 0) {
                cb.processResult(successRc, null, context);
            }
        }

        private void tick() {
            if (this.done.incrementAndGet() == this.expected) {
                if (this.exceptions.isEmpty()) {
                    this.cb.processResult(this.successRc, null, this.context);
                } else {
                    this.cb.processResult(this.failureRc, null, this.context);
                }
            }
        }

        public void processResult(int rc, String path, Object ctx) {
            if (rc != this.successRc) {
                LOG.error("Error in mutil callback : " + rc);
                this.exceptions.add(rc);
            }
            this.tick();
        }
    }

    public static interface ReadEntryCallback {
        public void readEntryComplete(int var1, long var2, long var4, ChannelBuffer var6, Object var7);
    }

    public static interface GenericCallback<T> {
        public void operationComplete(int var1, T var2);
    }

    public static interface WriteCallback {
        public void writeComplete(int var1, long var2, long var4, InetSocketAddress var6, Object var7);
    }
}

