/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.FlatLedgerManager;
import org.apache.bookkeeper.meta.HierarchicalLedgerManager;
import org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;

public class LedgerManagerFactory {
    /*
     * Unable to fully structure code
     */
    public static LedgerManager newLedgerManager(AbstractConfiguration conf, ZooKeeper zk) throws IOException, KeeperException, InterruptedException {
        lmType = conf.getLedgerManagerType();
        ledgerRootPath = conf.getZkLedgersRootPath();
        if (null == ledgerRootPath || ledgerRootPath.length() == 0) {
            throw new IOException("Empty Ledger Root Path.");
        }
        if (zk == null) {
            return new FlatLedgerManager(conf, zk, ledgerRootPath, 1);
        }
        layout = LedgerLayout.readLayout(zk, ledgerRootPath);
        if (layout == null) {
            if (lmType == null || lmType.equals("flat")) {
                layout = new LedgerLayout("flat", 1);
            } else if (lmType.equals("hierarchical")) {
                layout = new LedgerLayout("hierarchical", 1);
            } else {
                throw new IOException("Unknown ledger manager type " + lmType);
            }
            try {
                layout.store(zk, ledgerRootPath);
            }
            catch (KeeperException.NodeExistsException nee) {
                layout2 = LedgerLayout.readLayout(zk, ledgerRootPath);
                if (layout2.equals(layout)) ** GOTO lbl25
                throw new IOException("Contention writing to layout to zookeeper,  other layout " + layout2 + " is incompatible with our " + "layout " + layout);
            }
        } else if (lmType != null && !layout.getManagerType().equals(lmType)) {
            throw new IOException("Configured layout " + lmType + " does not match existing layout " + layout.getManagerType());
        }
lbl25:
        // 4 sources

        if ("flat".equals(layout.getManagerType())) {
            return new FlatLedgerManager(conf, zk, ledgerRootPath, layout.getManagerVersion());
        }
        if ("hierarchical".equals(layout.getManagerType())) {
            return new HierarchicalLedgerManager(conf, zk, ledgerRootPath, layout.getManagerVersion());
        }
        throw new IOException("Unknown ledger manager type: " + lmType);
    }
}

