/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractZkLedgerManager
implements LedgerManager {
    static Logger LOG = LoggerFactory.getLogger(AbstractZkLedgerManager.class);
    public static final String LEDGER_NODE_PREFIX = "L";
    static final String AVAILABLE_NODE = "available";
    protected final AbstractConfiguration conf;
    protected final ZooKeeper zk;
    protected final String ledgerRootPath;

    protected AbstractZkLedgerManager(AbstractConfiguration conf, ZooKeeper zk, String ledgerRootPath) {
        this.conf = conf;
        this.zk = zk;
        this.ledgerRootPath = ledgerRootPath;
    }

    protected void asyncGetLedgersInSingleNode(final String nodePath, final BookkeeperInternalCallbacks.GenericCallback<HashSet<Long>> getLedgersCallback) {
        this.zk.sync(nodePath, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sync node path " + path + " return : " + rc);
                }
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("ZK error syncing the ledgers node when getting children: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    getLedgersCallback.operationComplete(rc, null);
                    return;
                }
                AbstractZkLedgerManager.this.doAsyncGetLedgersInSingleNode(nodePath, getLedgersCallback);
            }
        }, null);
    }

    private void doAsyncGetLedgersInSingleNode(String nodePath, final BookkeeperInternalCallbacks.GenericCallback<HashSet<Long>> getLedgersCallback) {
        this.zk.getChildren(nodePath, false, new AsyncCallback.ChildrenCallback(){

            public void processResult(int rc, String path, Object ctx, List<String> ledgerNodes) {
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Error polling ZK for the available ledger nodes: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                    getLedgersCallback.operationComplete(rc, null);
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Retrieved current set of ledger nodes: " + ledgerNodes);
                }
                HashSet<Long> allActiveLedgers = new HashSet<Long>(ledgerNodes.size(), 1.0f);
                for (String ledgerNode : ledgerNodes) {
                    if (AbstractZkLedgerManager.this.isSpecialZnode(ledgerNode)) continue;
                    try {
                        allActiveLedgers.add(AbstractZkLedgerManager.this.getLedgerId(path + "/" + ledgerNode));
                    }
                    catch (IOException ie) {
                        LOG.warn("Error extracting ledgerId from ZK ledger node: " + ledgerNode);
                    }
                }
                getLedgersCallback.operationComplete(rc, allActiveLedgers);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashSet<Long> getLedgersInSingleNode(String nodePath) throws IOException, InterruptedException {
        final GetLedgersCtx ctx = new GetLedgersCtx();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try to get ledgers of node : " + nodePath);
        }
        GetLedgersCtx getLedgersCtx = ctx;
        synchronized (getLedgersCtx) {
            this.asyncGetLedgersInSingleNode(nodePath, new BookkeeperInternalCallbacks.GenericCallback<HashSet<Long>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(int rc, HashSet<Long> zkActiveLedgers) {
                    GetLedgersCtx getLedgersCtx = ctx;
                    synchronized (getLedgersCtx) {
                        if (KeeperException.Code.OK.intValue() == rc) {
                            ctx.ledgers = zkActiveLedgers;
                        }
                        ctx.rc = rc;
                        ctx.notifyAll();
                    }
                }
            });
            ctx.wait();
        }
        if (KeeperException.Code.OK.intValue() != ctx.rc && null != ctx.ledgers) {
            throw new IOException("Error on getting ledgers from node " + nodePath);
        }
        return ctx.ledgers;
    }

    protected void asyncProcessLedgersInSingleNode(String path, final BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object ctx, final int successRc, final int failureRc) {
        this.asyncGetLedgersInSingleNode(path, new BookkeeperInternalCallbacks.GenericCallback<HashSet<Long>>(){

            @Override
            public void operationComplete(int rc, HashSet<Long> zkActiveLedgers) {
                if (KeeperException.Code.OK.intValue() != rc) {
                    finalCb.processResult(failureRc, null, ctx);
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing ledgers : " + zkActiveLedgers);
                }
                if (zkActiveLedgers.size() == 0) {
                    finalCb.processResult(successRc, null, ctx);
                    return;
                }
                BookkeeperInternalCallbacks.MultiCallback mcb = new BookkeeperInternalCallbacks.MultiCallback(zkActiveLedgers.size(), finalCb, ctx, successRc, failureRc);
                for (Long ledger : zkActiveLedgers) {
                    processor.process(ledger, mcb);
                }
            }
        });
    }

    protected boolean isSpecialZnode(String znode) {
        return AVAILABLE_NODE.equals(znode) || "LAYOUT".equals(znode);
    }

    @Override
    public void close() {
    }

    private class GetLedgersCtx {
        int rc;
        HashSet<Long> ledgers = null;

        private GetLedgersCtx() {
        }
    }
}

