/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerMetadata {
    static final Logger LOG = LoggerFactory.getLogger(LedgerMetadata.class);
    private static final String closed = "CLOSED";
    private static final String lSplitter = "\n";
    private static final String tSplitter = "\t";
    public static final int NOTCLOSED = -101;
    public static final int IN_RECOVERY = -102;
    public static final int LOWEST_COMPAT_METADATA_FORMAT_VERSION = 0;
    public static final int CURRENT_METADATA_FORMAT_VERSION = 1;
    public static final String VERSION_KEY = "BookieMetadataFormatVersion";
    int metadataFormatVersion = 0;
    int ensembleSize;
    int quorumSize;
    long length;
    long close;
    private SortedMap<Long, ArrayList<InetSocketAddress>> ensembles = new TreeMap<Long, ArrayList<InetSocketAddress>>();
    ArrayList<InetSocketAddress> currentEnsemble;
    volatile int znodeVersion = -1;

    public LedgerMetadata(int ensembleSize, int quorumSize) {
        this.ensembleSize = ensembleSize;
        this.quorumSize = quorumSize;
        this.length = 0L;
        this.close = -101L;
        this.metadataFormatVersion = 1;
    }

    private LedgerMetadata() {
        this(0, 0);
    }

    public SortedMap<Long, ArrayList<InetSocketAddress>> getEnsembles() {
        return this.ensembles;
    }

    boolean isClosed() {
        return this.close != -101L && this.close != -102L;
    }

    void markLedgerInRecovery() {
        this.close = -102L;
    }

    void close(long entryId) {
        this.close = entryId;
    }

    void addEnsemble(long startEntryId, ArrayList<InetSocketAddress> ensemble) {
        assert (this.ensembles.isEmpty() || startEntryId >= this.ensembles.lastKey());
        this.ensembles.put(startEntryId, ensemble);
        this.currentEnsemble = ensemble;
    }

    ArrayList<InetSocketAddress> getEnsemble(long entryId) {
        return (ArrayList)this.ensembles.get(this.ensembles.headMap(entryId + 1L).lastKey());
    }

    long getNextEnsembleChange(long entryId) {
        SortedMap<Long, ArrayList<InetSocketAddress>> tailMap = this.ensembles.tailMap(entryId + 1L);
        if (tailMap.isEmpty()) {
            return -1L;
        }
        return tailMap.firstKey();
    }

    public byte[] serialize() {
        StringBuilder s = new StringBuilder();
        s.append(VERSION_KEY).append(tSplitter).append(this.metadataFormatVersion).append(lSplitter);
        s.append(this.quorumSize).append(lSplitter).append(this.ensembleSize).append(lSplitter).append(this.length);
        for (Map.Entry<Long, ArrayList<InetSocketAddress>> entry : this.ensembles.entrySet()) {
            s.append(lSplitter).append(entry.getKey());
            for (InetSocketAddress addr : entry.getValue()) {
                s.append(tSplitter);
                StringUtils.addrToString(s, addr);
            }
        }
        if (this.close != -101L) {
            s.append(lSplitter).append(this.close).append(tSplitter).append(closed);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serialized config: " + s.toString());
        }
        return s.toString().getBytes();
    }

    static LedgerMetadata parseConfig(byte[] bytes, int version) throws IOException {
        LedgerMetadata lc = new LedgerMetadata();
        String config = new String(bytes);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing Config: " + config);
        }
        String[] lines = config.split(lSplitter);
        try {
            String[] parts;
            int i = 0;
            if (lines[0].startsWith(VERSION_KEY)) {
                parts = lines[0].split(tSplitter);
                lc.metadataFormatVersion = new Integer(parts[1]);
                ++i;
            } else {
                lc.metadataFormatVersion = 0;
            }
            if (lc.metadataFormatVersion < 0 || lc.metadataFormatVersion > 1) {
                throw new IOException("Metadata version not compatible. Expected between 0 and 1, but got " + lc.metadataFormatVersion);
            }
            if (lines.length + i < 2) {
                throw new IOException("Quorum size or ensemble size absent from config: " + config);
            }
            lc.znodeVersion = version;
            lc.quorumSize = new Integer(lines[i++]);
            lc.ensembleSize = new Integer(lines[i++]);
            lc.length = new Long(lines[i++]);
            while (i < lines.length) {
                parts = lines[i].split(tSplitter);
                if (parts[1].equals(closed)) {
                    lc.close = new Long(parts[0]);
                    break;
                }
                ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
                for (int j = 1; j < parts.length; ++j) {
                    addrs.add(StringUtils.parseAddr(parts[j]));
                }
                lc.addEnsemble(new Long(parts[0]), addrs);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return lc;
    }

    public void updateZnodeStatus(Stat stat) {
        this.znodeVersion = stat.getVersion();
    }

    public int getZnodeVersion() {
        return this.znodeVersion;
    }
}

