/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.util.SafeRunnable;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BookieWatcher
implements Watcher,
AsyncCallback.ChildrenCallback {
    static final Logger logger = LoggerFactory.getLogger(BookieWatcher.class);
    public static final String BOOKIE_REGISTRATION_PATH = "/ledgers/available";
    static final Set<InetSocketAddress> EMPTY_SET = new HashSet<InetSocketAddress>();
    public static int ZK_CONNECT_BACKOFF_SEC = 1;
    BookKeeper bk;
    ScheduledExecutorService scheduler;
    Set<InetSocketAddress> knownBookies = new HashSet<InetSocketAddress>();
    SafeRunnable reReadTask = new SafeRunnable(){

        @Override
        public void safeRun() {
            BookieWatcher.this.readBookies();
        }
    };

    public BookieWatcher(BookKeeper bk) {
        this.bk = bk;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    public void halt() {
        this.scheduler.shutdown();
    }

    public void readBookies() {
        this.readBookies(this);
    }

    public void readBookies(AsyncCallback.ChildrenCallback callback) {
        this.bk.getZkHandle().getChildren(BOOKIE_REGISTRATION_PATH, (Watcher)this, callback, null);
    }

    public void process(WatchedEvent event) {
        this.readBookies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx, List<String> children) {
        if (rc != KeeperException.Code.OK.intValue()) {
            this.scheduler.schedule(this.reReadTask, (long)ZK_CONNECT_BACKOFF_SEC, TimeUnit.SECONDS);
            return;
        }
        HashSet<InetSocketAddress> newBookieAddrs = new HashSet<InetSocketAddress>();
        for (String bookieAddrString : children) {
            InetSocketAddress bookieAddr;
            try {
                bookieAddr = StringUtils.parseAddr(bookieAddrString);
            }
            catch (IOException e) {
                logger.error("Could not parse bookie address: " + bookieAddrString + ", ignoring this bookie");
                continue;
            }
            newBookieAddrs.add(bookieAddr);
        }
        BookieWatcher bookieWatcher = this;
        synchronized (bookieWatcher) {
            this.knownBookies = newBookieAddrs;
        }
    }

    public void readBookiesBlocking() throws InterruptedException, KeeperException {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.readBookies(new AsyncCallback.ChildrenCallback(){

            public void processResult(int rc, String path, Object ctx, List<String> children) {
                try {
                    BookieWatcher.this.processResult(rc, path, ctx, children);
                    queue.put(rc);
                }
                catch (InterruptedException e) {
                    logger.error("Interruped when trying to read bookies in a blocking fashion");
                    throw new RuntimeException(e);
                }
            }
        });
        int rc = (Integer)queue.take();
        if (rc != KeeperException.Code.OK.intValue()) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc));
        }
    }

    public ArrayList<InetSocketAddress> getNewBookies(int numBookiesNeeded) throws BKException.BKNotEnoughBookiesException {
        return this.getAdditionalBookies(EMPTY_SET, numBookiesNeeded);
    }

    public InetSocketAddress getAdditionalBookie(List<InetSocketAddress> existingBookies) throws BKException.BKNotEnoughBookiesException {
        return this.getAdditionalBookies(new HashSet<InetSocketAddress>(existingBookies), 1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<InetSocketAddress> getAdditionalBookies(Set<InetSocketAddress> existingBookies, int numAdditionalBookiesNeeded) throws BKException.BKNotEnoughBookiesException {
        ArrayList<InetSocketAddress> allBookies;
        ArrayList<InetSocketAddress> newBookies = new ArrayList<InetSocketAddress>();
        if (numAdditionalBookiesNeeded <= 0) {
            return newBookies;
        }
        BookieWatcher bookieWatcher = this;
        synchronized (bookieWatcher) {
            allBookies = new ArrayList<InetSocketAddress>(this.knownBookies);
        }
        Collections.shuffle(allBookies);
        for (InetSocketAddress bookie : allBookies) {
            if (existingBookies.contains(bookie)) continue;
            newBookies.add(bookie);
            if (--numAdditionalBookiesNeeded != 0) continue;
            return newBookies;
        }
        throw new BKException.BKNotEnoughBookiesException();
    }
}

