/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieWatcher;
import org.apache.bookkeeper.client.LedgerCreateOp;
import org.apache.bookkeeper.client.LedgerDeleteOp;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerOpenOp;
import org.apache.bookkeeper.client.SyncCounter;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeper {
    static final Logger LOG = LoggerFactory.getLogger(BookKeeper.class);
    ZooKeeper zk = null;
    boolean ownZKHandle = false;
    ClientSocketChannelFactory channelFactory;
    boolean ownChannelFactory = false;
    BookieClient bookieClient;
    BookieWatcher bookieWatcher;
    OrderedSafeExecutor callbackWorker = new OrderedSafeExecutor(Runtime.getRuntime().availableProcessors());
    OrderedSafeExecutor mainWorkerPool = new OrderedSafeExecutor(Runtime.getRuntime().availableProcessors());
    final LedgerManager ledgerManager;
    ClientConfiguration conf;

    public BookKeeper(String servers) throws IOException, InterruptedException, KeeperException {
        this(new ClientConfiguration().setZkServers(servers));
    }

    public BookKeeper(ClientConfiguration conf) throws IOException, InterruptedException, KeeperException {
        this(conf, new ZooKeeper(conf.getZkServers(), conf.getZkTimeout(), new Watcher(){

            public void process(WatchedEvent event) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Process: " + event.getType() + " " + event.getPath());
                }
            }
        }), (ClientSocketChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.ownZKHandle = true;
        this.ownChannelFactory = true;
    }

    public BookKeeper(ClientConfiguration conf, ZooKeeper zk) throws IOException, InterruptedException, KeeperException {
        this(conf, zk, (ClientSocketChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.ownChannelFactory = true;
    }

    public BookKeeper(ClientConfiguration conf, ZooKeeper zk, ClientSocketChannelFactory channelFactory) throws IOException, InterruptedException, KeeperException {
        if (zk == null || channelFactory == null) {
            throw new NullPointerException();
        }
        this.conf = conf;
        this.zk = zk;
        this.channelFactory = channelFactory;
        this.bookieWatcher = new BookieWatcher(this);
        this.bookieWatcher.readBookiesBlocking();
        this.bookieClient = new BookieClient(conf, channelFactory, this.mainWorkerPool);
        this.ledgerManager = LedgerManagerFactory.newLedgerManager(conf, zk);
    }

    LedgerManager getLedgerManager() {
        return this.ledgerManager;
    }

    ZooKeeper getZkHandle() {
        return this.zk;
    }

    protected ClientConfiguration getConf() {
        return this.conf;
    }

    BookieClient getBookieClient() {
        return this.bookieClient;
    }

    public void asyncCreateLedger(int ensSize, int qSize, DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx) {
        new LedgerCreateOp(this, ensSize, qSize, digestType, passwd, cb, ctx).initiate();
    }

    public LedgerHandle createLedger(DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        return this.createLedger(3, 2, digestType, passwd);
    }

    public LedgerHandle createLedger(int ensSize, int qSize, DigestType digestType, byte[] passwd) throws InterruptedException, BKException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncCreateLedger(ensSize, qSize, digestType, passwd, new SyncCreateCallback(), counter);
        counter.block(0);
        if (counter.getLh() == null) {
            LOG.error("ZooKeeper error: " + counter.getrc());
            throw BKException.create(-9);
        }
        return counter.getLh();
    }

    public void asyncOpenLedger(long lId, DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this, lId, digestType, passwd, cb, ctx).initiate();
    }

    public void asyncOpenLedgerNoRecovery(long lId, DigestType digestType, byte[] passwd, AsyncCallback.OpenCallback cb, Object ctx) {
        new LedgerOpenOp(this, lId, digestType, passwd, cb, ctx).initiateWithoutRecovery();
    }

    public LedgerHandle openLedger(long lId, DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncOpenLedger(lId, digestType, passwd, new SyncOpenCallback(), counter);
        counter.block(0);
        if (counter.getrc() != 0) {
            throw BKException.create(counter.getrc());
        }
        return counter.getLh();
    }

    public LedgerHandle openLedgerNoRecovery(long lId, DigestType digestType, byte[] passwd) throws BKException, InterruptedException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncOpenLedgerNoRecovery(lId, digestType, passwd, new SyncOpenCallback(), counter);
        counter.block(0);
        if (counter.getrc() != 0) {
            throw BKException.create(counter.getrc());
        }
        return counter.getLh();
    }

    public void asyncDeleteLedger(long lId, AsyncCallback.DeleteCallback cb, Object ctx) {
        new LedgerDeleteOp(this, lId, cb, ctx).initiate();
    }

    public void deleteLedger(long lId) throws InterruptedException, BKException {
        SyncCounter counter = new SyncCounter();
        counter.inc();
        this.asyncDeleteLedger(lId, new SyncDeleteCallback(), counter);
        counter.block(0);
        if (counter.getrc() != KeeperException.Code.OK.intValue()) {
            LOG.error("ZooKeeper error deleting ledger node: " + counter.getrc());
            throw BKException.create(-9);
        }
    }

    public void close() throws InterruptedException, BKException {
        this.bookieClient.close();
        this.ledgerManager.close();
        this.bookieWatcher.halt();
        if (this.ownChannelFactory) {
            this.channelFactory.releaseExternalResources();
        }
        if (this.ownZKHandle) {
            this.zk.close();
        }
        this.callbackWorker.shutdown();
        this.mainWorkerPool.shutdown();
    }

    private static class SyncDeleteCallback
    implements AsyncCallback.DeleteCallback {
        private SyncDeleteCallback() {
        }

        @Override
        public void deleteComplete(int rc, Object ctx) {
            SyncCounter counter = (SyncCounter)ctx;
            counter.setrc(rc);
            counter.dec();
        }
    }

    private static class SyncOpenCallback
    implements AsyncCallback.OpenCallback {
        private SyncOpenCallback() {
        }

        @Override
        public void openComplete(int rc, LedgerHandle lh, Object ctx) {
            SyncCounter counter = (SyncCounter)ctx;
            counter.setLh(lh);
            LOG.debug("Open complete: " + rc);
            counter.setrc(rc);
            counter.dec();
        }
    }

    private static class SyncCreateCallback
    implements AsyncCallback.CreateCallback {
        private SyncCreateCallback() {
        }

        @Override
        public void createComplete(int rc, LedgerHandle lh, Object ctx) {
            SyncCounter counter = (SyncCounter)ctx;
            counter.setLh(lh);
            counter.setrc(rc);
            counter.dec();
        }
    }

    public static enum DigestType {
        MAC,
        CRC32;

    }
}

