/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

public abstract class BKException
extends Exception {
    private int code;

    BKException(int code) {
        this.code = code;
    }

    public static BKException create(int code) {
        switch (code) {
            case -1: {
                return new BKReadException();
            }
            case -2: {
                return new BKQuorumException();
            }
            case -3: {
                return new BKBookieException();
            }
            case -4: {
                return new BKDigestNotInitializedException();
            }
            case -5: {
                return new BKDigestMatchException();
            }
            case -6: {
                return new BKNotEnoughBookiesException();
            }
            case -7: {
                return new BKNoSuchLedgerExistsException();
            }
            case -8: {
                return new BKBookieHandleNotAvailableException();
            }
            case -9: {
                return new ZKException();
            }
            case -10: {
                return new BKLedgerRecoveryException();
            }
            case -11: {
                return new BKLedgerClosedException();
            }
            case -12: {
                return new BKWriteException();
            }
            case -13: {
                return new BKNoSuchEntryException();
            }
            case -14: {
                return new BKIncorrectParameterException();
            }
            case -15: {
                return new BKInterruptedException();
            }
            case -16: {
                return new BKProtocolVersionException();
            }
            case -101: {
                return new BKLedgerFencedException();
            }
        }
        return new BKIllegalOpException();
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static String getMessage(int code) {
        switch (code) {
            case 0: {
                return "No problem";
            }
            case -1: {
                return "Error while reading ledger";
            }
            case -2: {
                return "Invalid quorum size on ensemble size";
            }
            case -3: {
                return "Invalid quorum size on ensemble size";
            }
            case -4: {
                return "Digest engine not initialized";
            }
            case -5: {
                return "Entry digest does not match";
            }
            case -6: {
                return "Not enough non-faulty bookies available";
            }
            case -7: {
                return "No such ledger exists";
            }
            case -8: {
                return "Bookie handle is not available";
            }
            case -9: {
                return "Error while using ZooKeeper";
            }
            case -10: {
                return "Error while recovering ledger";
            }
            case -11: {
                return "Attempt to write to a closed ledger";
            }
            case -12: {
                return "Write failed on bookie";
            }
            case -13: {
                return "No such entry";
            }
            case -14: {
                return "Incorrect parameter input";
            }
            case -15: {
                return "Interrupted while waiting for permit";
            }
            case -16: {
                return "Bookie protocol version on server is incompatible with client";
            }
            case -101: {
                return "Ledger has been fenced off. Some other client must have opened it to read";
            }
        }
        return "Invalid operation";
    }

    public static class BKLedgerFencedException
    extends BKException {
        public BKLedgerFencedException() {
            super(-101);
        }
    }

    public static class BKInterruptedException
    extends BKException {
        public BKInterruptedException() {
            super(-15);
        }
    }

    public static class BKIncorrectParameterException
    extends BKException {
        public BKIncorrectParameterException() {
            super(-14);
        }
    }

    public static class BKLedgerClosedException
    extends BKException {
        public BKLedgerClosedException() {
            super(-11);
        }
    }

    public static class BKLedgerRecoveryException
    extends BKException {
        public BKLedgerRecoveryException() {
            super(-10);
        }
    }

    public static class ZKException
    extends BKException {
        public ZKException() {
            super(-9);
        }
    }

    public static class BKBookieHandleNotAvailableException
    extends BKException {
        public BKBookieHandleNotAvailableException() {
            super(-8);
        }
    }

    public static class BKNoSuchLedgerExistsException
    extends BKException {
        public BKNoSuchLedgerExistsException() {
            super(-7);
        }
    }

    public static class BKProtocolVersionException
    extends BKException {
        public BKProtocolVersionException() {
            super(-16);
        }
    }

    public static class BKWriteException
    extends BKException {
        public BKWriteException() {
            super(-12);
        }
    }

    public static class BKNotEnoughBookiesException
    extends BKException {
        public BKNotEnoughBookiesException() {
            super(-6);
        }
    }

    public static class BKIllegalOpException
    extends BKException {
        public BKIllegalOpException() {
            super(-100);
        }
    }

    public static class BKDigestMatchException
    extends BKException {
        public BKDigestMatchException() {
            super(-5);
        }
    }

    public static class BKDigestNotInitializedException
    extends BKException {
        public BKDigestNotInitializedException() {
            super(-4);
        }
    }

    public static class BKBookieException
    extends BKException {
        public BKBookieException() {
            super(-3);
        }
    }

    public static class BKQuorumException
    extends BKException {
        public BKQuorumException() {
            super(-2);
        }
    }

    public static class BKNoSuchEntryException
    extends BKException {
        public BKNoSuchEntryException() {
            super(-13);
        }
    }

    public static class BKReadException
    extends BKException {
        public BKReadException() {
            super(-1);
        }
    }

    public static interface Code {
        public static final int OK = 0;
        public static final int ReadException = -1;
        public static final int QuorumException = -2;
        public static final int NoBookieAvailableException = -3;
        public static final int DigestNotInitializedException = -4;
        public static final int DigestMatchException = -5;
        public static final int NotEnoughBookiesException = -6;
        public static final int NoSuchLedgerExistsException = -7;
        public static final int BookieHandleNotAvailableException = -8;
        public static final int ZKException = -9;
        public static final int LedgerRecoveryException = -10;
        public static final int LedgerClosedException = -11;
        public static final int WriteException = -12;
        public static final int NoSuchEntryException = -13;
        public static final int IncorrectParameterException = -14;
        public static final int InterruptedException = -15;
        public static final int ProtocolVersionException = -16;
        public static final int IllegalOpException = -100;
        public static final int LedgerFencedException = -101;
    }
}

