/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.components.config.xml;

import org.activiti.engine.ProcessEngine;
import org.activiti.spring.components.registry.ActivitiStateHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class StateHandlerAnnotationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private ProcessEngine processEngine;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    private void configureDefaultActivitiRegistry(String registryBeanName, BeanDefinitionRegistry registry) {
        if (!this.beanAlreadyConfigured(registry, registryBeanName, ActivitiStateHandlerRegistry.class)) {
            String registryName = ActivitiStateHandlerRegistry.class.getName();
            this.log.info("registering a {} instance under bean name {}.", (Object)registryName, (Object)"activitiComponentRegistry");
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
            rootBeanDefinition.setBeanClassName(registryName);
            rootBeanDefinition.getPropertyValues().addPropertyValue("processEngine", (Object)this.processEngine);
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)rootBeanDefinition, registryBeanName);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            this.configureDefaultActivitiRegistry("activitiComponentRegistry", registry);
        } else {
            this.log.info("BeanFactory is not a BeanDefinitionRegistry. The default '{}' cannot be configured.", (Object)"activitiComponentRegistry");
        }
    }

    private boolean beanAlreadyConfigured(BeanDefinitionRegistry registry, String beanName, Class clz) {
        if (registry.isBeanNameInUse(beanName)) {
            BeanDefinition bDef = registry.getBeanDefinition(beanName);
            if (bDef.getBeanClassName().equals(clz.getName())) {
                return true;
            }
            throw new IllegalStateException("The bean name '" + beanName + "' is reserved.");
        }
        return false;
    }
}

