/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison;

abstract class StackUtils {
    StackUtils() {
    }

    public static Class<?> getCallingClass(Class<?> ... alsoSkippable) {
        Class<?> sourceClass;
        StackTraceElement callingStackTraceElement = StackUtils.getCallingStackTraceElement(alsoSkippable);
        try {
            sourceClass = Class.forName(callingStackTraceElement.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load resources for test class: " + callingStackTraceElement.getClassName(), e);
        }
        return sourceClass;
    }

    public static StackTraceElement getCallingStackTraceElement(Class<?> ... alsoSkippable) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = 0;
        while (StackUtils.isSkippable(stackTrace[i], alsoSkippable)) {
            ++i;
        }
        ++i;
        while (StackUtils.isSkippable(stackTrace[i], alsoSkippable)) {
            ++i;
        }
        StackTraceElement callingStackTraceElement = stackTrace[i];
        return callingStackTraceElement;
    }

    private static boolean isSkippable(StackTraceElement stackTraceElement, Class<?> ... alsoSkippable) {
        if (stackTraceElement.getClassName().equals(Thread.class.getCanonicalName())) {
            return true;
        }
        if (stackTraceElement.getClassName().equals(StackUtils.class.getCanonicalName())) {
            return true;
        }
        for (Class<?> skippable : alsoSkippable) {
            if (!stackTraceElement.getClassName().equals(skippable.getCanonicalName())) continue;
            return true;
        }
        return false;
    }
}

