/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.avh4.util.imagecomparison.ImageComparison;
import net.avh4.util.imagecomparison.Matchers;
import net.avh4.util.imagecomparison.StackUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class LooksLikeMatcher
extends BaseMatcher<Object> {
    private final String filename;
    private final BufferedImage referenceImage;
    private final Dimension referenceImageSize;
    private final Class<?> sourceClass = StackUtils.getCallingClass(Matchers.class);

    public LooksLikeMatcher(String filename) throws IOException {
        this.filename = filename;
        URL resource = this.sourceClass.getResource(filename);
        if (resource == null) {
            this.referenceImage = null;
            this.referenceImageSize = null;
        } else {
            this.referenceImage = ImageIO.read(resource);
            this.referenceImageSize = new Dimension(this.referenceImage.getWidth(), this.referenceImage.getHeight());
        }
    }

    public boolean matches(Object item) {
        return ImageComparison.matches(item, this.referenceImage, this.filename);
    }

    public void describeTo(Description description) {
        if (this.referenceImage == null) {
            description.appendText(String.format("reference image \"%s\" to exist in %s", this.filename, this.sourceClass.getPackage().getName()));
        } else {
            description.appendText(String.format("something that looks like %s (%dx%d)", this.filename, this.referenceImageSize.width, this.referenceImageSize.height));
        }
    }
}

