/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class ImageDiffView
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final BufferedImage image1;
    private final BufferedImage image2;

    public ImageDiffView(String file1, String file2) throws IOException {
        this.image1 = ImageIO.read(new File(file1));
        this.image2 = ImageIO.read(new File(file2));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.image1.getWidth() + this.image2.getWidth(), Math.max(this.image1.getHeight(), this.image2.getHeight()));
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w1 = this.image1.getWidth();
        int w2 = this.image2.getWidth();
        int h1 = this.image1.getHeight();
        int h2 = this.image2.getHeight();
        g.drawImage(this.image1, 0, 0, null);
        g.drawImage(this.image2, w1, 0, null);
        g.setColor(Color.RED);
        for (int x = 0; x < Math.min(w1, w2); ++x) {
            for (int y = 0; y < Math.min(h1, h2); ++y) {
                if (this.image1.getRGB(x, y) == this.image2.getRGB(x, y)) continue;
                g.drawLine(x, y, x, y);
            }
        }
    }
}

