/*
 * Decompiled with CFR 0.152.
 */
package net.avh4.util.imagecomparison;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class ImageComparison {
    public static boolean matchesImage(BufferedImage itemImage, BufferedImage referenceImage, String filename) {
        if (itemImage.getWidth() != referenceImage.getWidth() || itemImage.getHeight() != referenceImage.getHeight()) {
            ImageComparison.writeImage(itemImage, filename);
            return false;
        }
        Raster itemRaster = itemImage.getData();
        Raster referenceRaster = referenceImage.getData();
        int width = itemRaster.getWidth();
        int height = itemRaster.getHeight();
        for (int y = 0; y < height; ++y) {
            int[] itemPixels = new int[4 * width];
            int[] referencePixels = new int[4 * width];
            itemRaster.getPixels(0, y, width, 1, itemPixels);
            referenceRaster.getPixels(0, y, width, 1, referencePixels);
            for (int i = 0; i < 4 * width; ++i) {
                if (itemPixels[i] == referencePixels[i]) continue;
                ImageComparison.writeImage(itemImage, filename);
                return false;
            }
        }
        return true;
    }

    private static void writeImage(BufferedImage itemImage, String filename) {
        try {
            ImageIO.write((RenderedImage)itemImage, "png", new File(filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean matches(Object item, String referenceFilename, String outputFilename) {
        BufferedImage expectedImage = null;
        try {
            expectedImage = ImageIO.read(new File(referenceFilename));
        }
        catch (IOException e) {
            // empty catch block
        }
        return ImageComparison.matches(item, expectedImage, outputFilename);
    }

    public static boolean matches(Object actual, BufferedImage expectedImage, String outputFilename) {
        BufferedImage actualImage = ImageComparison.getImage(actual);
        if (actualImage == null) {
            return false;
        }
        if (expectedImage == null) {
            ImageComparison.writeImage(actualImage, outputFilename);
            return false;
        }
        return ImageComparison.matchesImage(actualImage, expectedImage, outputFilename);
    }

    private static BufferedImage drawComponent(Component c) {
        ImageComparison.validateComponent(c);
        BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        c.paint(g);
        g.dispose();
        return image;
    }

    private static void validateComponent(Component c) {
        if (!c.isValid()) {
            if (c instanceof Window) {
                Window c1 = (Window)c;
                c1.pack();
            } else {
                c.setSize(c.getPreferredSize());
            }
        }
    }

    private static BufferedImage getImage(Object item) {
        if (item instanceof JFrame) {
            return ImageComparison.drawComponent(((JFrame)item).getContentPane());
        }
        if (item instanceof Component) {
            return ImageComparison.drawComponent((Component)item);
        }
        if (item instanceof BufferedImage) {
            return (BufferedImage)item;
        }
        throw new RuntimeException("Don't know how to make an image of " + item);
    }
}

