/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import zipkin.storage.mysql.DSLContexts;
import zipkin.storage.mysql.internal.generated.tables.ZipkinDependencies;

final class HasErrorCount {
    private static final Logger LOG = Logger.getLogger(HasErrorCount.class.getName());

    HasErrorCount() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean test(DataSource datasource, DSLContexts context) {
        try (Connection conn = datasource.getConnection();){
            DSLContext dsl = context.get(conn);
            dsl.select(ZipkinDependencies.ZIPKIN_DEPENDENCIES.ERROR_COUNT).from((TableLike)ZipkinDependencies.ZIPKIN_DEPENDENCIES).limit(1).fetchAny();
            boolean bl = true;
            return bl;
        }
        catch (DataAccessException e) {
            if (e.sqlState().equals("42S22")) {
                LOG.warning("zipkin_dependencies.error_count doesn't exist, so DependencyLink.errorCount is not supported. Execute: alter table zipkin_dependencies add `error_count` BIGINT");
                return false;
            }
            HasErrorCount.problemReading((Exception)((Object)e));
            return false;
        }
        catch (RuntimeException | SQLException e) {
            HasErrorCount.problemReading(e);
        }
        return false;
    }

    static void problemReading(Exception e) {
        LOG.log(Level.WARNING, "problem reading zipkin_dependencies.error_count", e);
    }
}

