/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.parser;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.antlr.parser.SQLAST;
import io.shardingsphere.core.parsing.antlr.parser.impl.SQLParserFactory;
import io.shardingsphere.core.parsing.antlr.rule.registry.ParsingRuleRegistry;
import io.shardingsphere.core.parsing.antlr.rule.registry.statement.SQLStatementRule;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingUnsupportedException;
import java.beans.ConstructorProperties;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;

public final class SQLParserEngine {
    private final ParsingRuleRegistry parsingRuleRegistry = ParsingRuleRegistry.getInstance();
    private final DatabaseType databaseType;
    private final String sql;

    public SQLAST parse() {
        ParseTree parseTree = SQLParserFactory.newInstance(this.databaseType, this.sql).execute().getChild(0);
        if (parseTree instanceof ErrorNode) {
            throw new SQLParsingUnsupportedException(String.format("Unsupported SQL of `%s`", this.sql));
        }
        Optional<SQLStatementRule> sqlStatementRule = this.parsingRuleRegistry.findSQLStatementRule(this.databaseType, parseTree.getClass().getSimpleName());
        if (!sqlStatementRule.isPresent()) {
            throw new SQLParsingUnsupportedException(String.format("Unsupported SQL of `%s`", this.sql));
        }
        return new SQLAST((ParserRuleContext)parseTree, (SQLStatementRule)sqlStatementRule.get());
    }

    @ConstructorProperties(value={"databaseType", "sql"})
    public SQLParserEngine(DatabaseType databaseType, String sql) {
        this.databaseType = databaseType;
        this.sql = sql;
    }
}

