/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl.dql;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.item.ColumnNameOrderByItemSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.item.ExpressionOrderByItemSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.item.IndexOrderByItemSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.order.item.OrderByItemSegment;
import io.shardingsphere.core.parsing.parser.context.orderby.OrderItem;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.util.SQLUtil;
import java.beans.ConstructorProperties;
import java.util.List;

public final class OrderItemBuilder {
    private final SelectStatement selectStatement;
    private final OrderByItemSegment orderByItemSegment;

    public OrderItem createOrderItem() {
        if (this.orderByItemSegment instanceof IndexOrderByItemSegment) {
            return this.createOrderItem((IndexOrderByItemSegment)this.orderByItemSegment);
        }
        if (this.orderByItemSegment instanceof ColumnNameOrderByItemSegment) {
            OrderItem result = this.createOrderItem(this.selectStatement, (ColumnNameOrderByItemSegment)this.orderByItemSegment);
            if (result.getOwner().isPresent() && this.selectStatement.getTables().getTableNames().contains(result.getOwner().get())) {
                this.selectStatement.addSQLToken(new TableToken(((ColumnNameOrderByItemSegment)this.orderByItemSegment).getBeginPosition(), 0, (String)result.getOwner().get()));
            }
            return result;
        }
        if (this.orderByItemSegment instanceof ExpressionOrderByItemSegment) {
            return this.createOrderItem(this.selectStatement, (ExpressionOrderByItemSegment)this.orderByItemSegment);
        }
        throw new UnsupportedOperationException();
    }

    private OrderItem createOrderItem(IndexOrderByItemSegment indexOrderByItemSegment) {
        return new OrderItem(indexOrderByItemSegment.getIndex(), indexOrderByItemSegment.getOrderDirection(), indexOrderByItemSegment.getNullOrderDirection());
    }

    private OrderItem createOrderItem(SelectStatement selectStatement, ColumnNameOrderByItemSegment columnNameOrderByItemSegment) {
        OrderItem result;
        String columnName = SQLUtil.getExactlyValue(columnNameOrderByItemSegment.getColumnName());
        if (columnName.contains(".")) {
            List values = Splitter.on((String)".").splitToList((CharSequence)columnName);
            result = new OrderItem((String)values.get(0), (String)values.get(1), columnNameOrderByItemSegment.getOrderDirection(), columnNameOrderByItemSegment.getNullOrderDirection());
        } else {
            result = new OrderItem(columnName, columnNameOrderByItemSegment.getOrderDirection(), columnNameOrderByItemSegment.getNullOrderDirection());
        }
        Optional<String> alias = selectStatement.getAlias(columnName);
        if (alias.isPresent()) {
            result.setAlias((String)alias.get());
        }
        return result;
    }

    private OrderItem createOrderItem(SelectStatement selectStatement, ExpressionOrderByItemSegment expressionOrderByItemSegment) {
        OrderItem result = new OrderItem(expressionOrderByItemSegment.getExpression(), expressionOrderByItemSegment.getOrderDirection(), expressionOrderByItemSegment.getNullOrderDirection());
        Optional<String> alias = selectStatement.getAlias(expressionOrderByItemSegment.getExpression());
        if (alias.isPresent()) {
            result.setAlias((String)alias.get());
        }
        return result;
    }

    @ConstructorProperties(value={"selectStatement", "orderByItemSegment"})
    public OrderItemBuilder(SelectStatement selectStatement, OrderByItemSegment orderByItemSegment) {
        this.selectStatement = selectStatement;
        this.orderByItemSegment = orderByItemSegment;
    }
}

