/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.AggregationType;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.dql.SubqueryFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.CommonExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.FunctionExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.PropertyExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.StarExpressionSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SubquerySegment;
import io.shardingsphere.core.parsing.parser.constant.DerivedAlias;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationDistinctSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.CommonSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.StarSelectItem;
import io.shardingsphere.core.parsing.parser.context.table.Table;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.AggregationDistinctToken;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.rule.ShardingRule;

public final class ExpressionFiller
implements SQLStatementFiller {
    public void fill(SQLSegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        if (!(sqlStatement instanceof SelectStatement)) {
            return;
        }
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        if (sqlSegment instanceof PropertyExpressionSegment) {
            this.fillPropertyExpression((PropertyExpressionSegment)sqlSegment, selectStatement, sql);
            return;
        }
        if (sqlSegment instanceof CommonExpressionSegment) {
            CommonExpressionSegment commonSegment = (CommonExpressionSegment)sqlSegment;
            String expression = sql.substring(commonSegment.getStartPosition(), commonSegment.getEndPosition() + 1);
            selectStatement.getItems().add(new CommonSelectItem(expression, commonSegment.getAlias()));
            return;
        }
        if (sqlSegment instanceof StarExpressionSegment) {
            this.fillStarExpression((StarExpressionSegment)sqlSegment, selectStatement);
            return;
        }
        if (sqlSegment instanceof FunctionExpressionSegment) {
            this.fillFunctionExpression((FunctionExpressionSegment)sqlSegment, selectStatement, sql);
            return;
        }
        if (sqlSegment instanceof SubquerySegment) {
            SubquerySegment subquerySegment = (SubquerySegment)sqlSegment;
            new SubqueryFiller().fill(subquerySegment, sqlStatement, sql, shardingRule, shardingTableMetaData);
        }
    }

    private void fillStarExpression(StarExpressionSegment starSegment, SelectStatement selectStatement) {
        selectStatement.setContainStar(true);
        Optional<String> owner = starSegment.getOwner();
        selectStatement.getItems().add(new StarSelectItem((String)owner.orNull()));
        if (!owner.isPresent()) {
            return;
        }
        Optional<Table> table = selectStatement.getTables().find((String)owner.get());
        if (table.isPresent() && !((Table)table.get()).getAlias().isPresent()) {
            selectStatement.addSQLToken(new TableToken(starSegment.getStartPosition(), 0, (String)owner.get()));
        }
    }

    private void fillPropertyExpression(PropertyExpressionSegment propertySegment, SelectStatement selectStatement, String sql) {
        Optional<String> owner = propertySegment.getOwner();
        if (owner.isPresent() && selectStatement.getTables().getTableNames().contains(owner.get())) {
            selectStatement.addSQLToken(new TableToken(propertySegment.getStartPosition(), 0, (String)owner.get()));
        }
        String expression = sql.substring(propertySegment.getStartPosition(), propertySegment.getEndPosition() + 1);
        selectStatement.getItems().add(new CommonSelectItem(expression, propertySegment.getAlias()));
    }

    private void fillFunctionExpression(FunctionExpressionSegment functionSegment, SelectStatement selectStatement, String sql) {
        AggregationType aggregationType = null;
        for (AggregationType eachType : AggregationType.values()) {
            if (!eachType.name().equalsIgnoreCase(functionSegment.getFunctionName())) continue;
            aggregationType = eachType;
            break;
        }
        String innerExpression = sql.substring(functionSegment.getInnerExpressionStartIndex(), functionSegment.getInnerExpressionEndIndex() + 1);
        String functionExpression = sql.substring(functionSegment.getFunctionStartIndex(), functionSegment.getInnerExpressionEndIndex() + 1);
        if (null != aggregationType) {
            if (functionSegment.hasDistinct()) {
                String columnName = sql.substring(functionSegment.getDistinctColumnNameStartPosition(), functionSegment.getInnerExpressionEndIndex());
                selectStatement.getItems().add(new AggregationDistinctSelectItem(aggregationType, innerExpression, functionSegment.getAlias(), columnName));
                Optional autoAlias = Optional.absent();
                if (DerivedAlias.isDerivedAlias((String)functionSegment.getAlias().get())) {
                    autoAlias = Optional.of((Object)functionSegment.getAlias().get());
                }
                selectStatement.getSQLTokens().add(new AggregationDistinctToken(functionSegment.getFunctionStartIndex(), functionExpression, columnName, (Optional<String>)autoAlias));
            } else {
                selectStatement.getItems().add(new AggregationSelectItem(aggregationType, innerExpression, functionSegment.getAlias()));
            }
        } else {
            selectStatement.getItems().add(new CommonSelectItem(functionExpression, functionSegment.getAlias()));
        }
    }
}

