/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller;

import io.datafx.controller.FxmlLoadException;
import io.datafx.controller.ViewConfiguration;
import io.datafx.controller.ViewController;
import io.datafx.controller.ViewNode;
import io.datafx.controller.ViewProperty;
import io.datafx.controller.context.ViewContext;
import io.datafx.controller.context.ViewMetadata;
import io.datafx.controller.context.event.ContextPostConstructListener;
import io.datafx.controller.util.NullNode;
import io.datafx.core.DataFXUtils;
import io.datafx.core.ExceptionHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.ServiceLoader;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import javax.annotation.PostConstruct;

public class ViewFactory {
    private static ViewFactory instance;

    private ViewFactory() {
    }

    public static synchronized ViewFactory getInstance() {
        if (instance == null) {
            instance = new ViewFactory();
        }
        return instance;
    }

    public <T> ViewContext<T> createByController(Class<T> controllerClass) throws FxmlLoadException {
        return this.createByController(controllerClass, null);
    }

    public <T> ViewContext<T> createByController(Class<T> controllerClass, String fxmlName) throws FxmlLoadException {
        return this.createByController(controllerClass, fxmlName, new ViewConfiguration(), new Object[0]);
    }

    public <T> ViewContext<T> createByController(Class<T> controllerClass, String fxmlName, ViewConfiguration viewConfiguration, Object ... viewContextResources) throws FxmlLoadException {
        try {
            T controller = controllerClass.newInstance();
            ViewMetadata metadata = new ViewMetadata();
            ViewController controllerAnnotation = controllerClass.getAnnotation(ViewController.class);
            if (controllerAnnotation != null && !controllerAnnotation.title().isEmpty()) {
                metadata.setTitle(controllerAnnotation.title());
            }
            if (controllerAnnotation != null && !controllerAnnotation.iconPath().isEmpty()) {
                metadata.setGraphic((Node)new ImageView(controllerClass.getResource(controllerAnnotation.iconPath()).toExternalForm()));
            }
            Node viewNode = null;
            if (controllerAnnotation != null && controllerAnnotation.root() != null && !controllerAnnotation.root().equals(NullNode.class)) {
                viewNode = controllerAnnotation.root().newInstance();
                this.injectNodeIDs(viewNode);
            } else {
                FXMLLoader loader = this.createLoader(controller, fxmlName, viewConfiguration);
                viewNode = (Node)loader.load();
            }
            this.injectFXMLNodes(controller, viewNode);
            ViewContext<T> context = new ViewContext<T>(viewNode, controller, metadata, viewConfiguration, viewContextResources);
            context.getResolver().injectResources(controller);
            ServiceLoader<ContextPostConstructListener> postConstructLoader = ServiceLoader.load(ContextPostConstructListener.class);
            for (ContextPostConstructListener listener : postConstructLoader) {
                listener.postConstruct(context);
            }
            for (Method method : DataFXUtils.getInheritedDeclaredMethods(controller.getClass())) {
                if (!method.isAnnotationPresent(PostConstruct.class)) continue;
                DataFXUtils.callPrivileged((Method)method, controller, (Object[])new Object[0]);
            }
            return context;
        }
        catch (Exception e) {
            throw new FxmlLoadException("Can't create controller for class " + controllerClass, e);
        }
    }

    public void showInStage(Stage stage, Class<?> controllerClass) throws FxmlLoadException {
        Scene myScene = new Scene((Parent)this.createByController(controllerClass).getRootNode());
        stage.setScene(myScene);
        stage.show();
    }

    private FXMLLoader createLoader(Object controller, String fxmlName, ViewConfiguration viewConfiguration) throws FxmlLoadException {
        Class<?> controllerClass = controller.getClass();
        String foundFxmlName = this.getFxmlName(controllerClass);
        if (fxmlName != null) {
            foundFxmlName = fxmlName;
        }
        if (foundFxmlName == null) {
            throw new FxmlLoadException("No FXML File specified!");
        }
        URL fxmlUrl = controllerClass.getResource(foundFxmlName);
        if (fxmlUrl == null) {
            throw new FxmlLoadException("Can't find FXML file for controller " + controller.getClass());
        }
        FXMLLoader fxmlLoader = new FXMLLoader(fxmlUrl);
        fxmlLoader.setBuilderFactory(viewConfiguration.getBuilderFactory());
        fxmlLoader.setCharset(viewConfiguration.getCharset());
        fxmlLoader.setResources(viewConfiguration.getResources());
        fxmlLoader.setController(controller);
        fxmlLoader.setControllerFactory(c -> controller);
        return fxmlLoader;
    }

    private String getFxmlName(Class<?> controllerClass) {
        ViewController controllerAnnotation;
        String nameByController;
        String foundFxmlName = null;
        if (controllerClass.getSimpleName().endsWith("Controller") && DataFXUtils.canAccess(controllerClass, (String)(nameByController = controllerClass.getSimpleName().substring(0, controllerClass.getSimpleName().length() - "Controller".length()) + ".fxml"))) {
            foundFxmlName = nameByController;
        }
        if ((controllerAnnotation = controllerClass.getAnnotation(ViewController.class)) != null && !controllerAnnotation.value().isEmpty()) {
            foundFxmlName = controllerAnnotation.value();
        }
        return foundFxmlName;
    }

    public <T> Tab createTab(Class<T> controllerClass) throws FxmlLoadException {
        return this.createTab(this.createByController(controllerClass));
    }

    public <T> Tab createTab(Class<T> controllerClass, ExceptionHandler exceptionHandler) throws FxmlLoadException {
        return this.createTab(this.createByController(controllerClass), exceptionHandler);
    }

    public <T> Tab createTab(ViewContext<T> context) {
        return this.createTab(context, ExceptionHandler.getDefaultInstance());
    }

    public <T> Tab createTab(ViewContext<T> context, ExceptionHandler exceptionHandler) {
        Tab tab = new Tab();
        tab.textProperty().bind((ObservableValue)context.getMetadata().titleProperty());
        tab.graphicProperty().bind(context.getMetadata().graphicsProperty());
        tab.setOnClosed(e -> {
            try {
                context.destroy();
            }
            catch (Exception exception) {
                exceptionHandler.setException((Throwable)exception);
            }
        });
        tab.setContent(context.getRootNode());
        return tab;
    }

    private <T> void injectFXMLNodes(T controller, Node root) {
        List fields = DataFXUtils.getInheritedDeclaredFields(controller.getClass());
        for (Field field : fields) {
            Node toInject;
            Node toInject2;
            if (field.getAnnotation(FXML.class) != null && DataFXUtils.getPrivileged((Field)field, controller) == null && Node.class.isAssignableFrom(field.getType()) && (toInject2 = root.lookup("#" + field.getName())) != null) {
                DataFXUtils.setPrivileged((Field)field, controller, (Object)toInject2);
            }
            if (field.getAnnotation(ViewNode.class) == null) continue;
            String id = field.getName();
            if (field.getAnnotation(ViewNode.class).value() != null && !field.getAnnotation(ViewNode.class).value().isEmpty()) {
                id = field.getAnnotation(ViewNode.class).value();
            }
            if (DataFXUtils.getPrivileged((Field)field, controller) != null || !Node.class.isAssignableFrom(field.getType()) || (toInject = root.lookup("#" + id)) == null) continue;
            DataFXUtils.setPrivileged((Field)field, controller, (Object)toInject);
        }
    }

    private void injectNodeIDs(Node root) {
        List fields = DataFXUtils.getInheritedDeclaredFields(root.getClass());
        for (Field field : fields) {
            if (!Node.class.isAssignableFrom(field.getType()) || field.getAnnotation(ViewNode.class) == null) continue;
            String id = field.getName();
            if (field.getAnnotation(ViewNode.class).value() != null && !field.getAnnotation(ViewNode.class).value().isEmpty()) {
                id = field.getAnnotation(ViewNode.class).value();
            }
            Node child = (Node)DataFXUtils.getPrivileged((Field)field, (Object)root);
            child.setId(id);
        }
    }

    private <T> void injectProperties(T controller, Node root) {
        List fields = DataFXUtils.getInheritedDeclaredFields(controller.getClass());
        for (Field field : fields) {
            if (field.getAnnotation(ViewProperty.class) == null || !ObservableValue.class.isAssignableFrom(field.getType())) continue;
            String id = field.getAnnotation(ViewProperty.class).value();
            String[] splitted = id.split(".");
            Node baseNode = root.lookup("#" + splitted[0]);
            Object foundProperty = null;
            ObservableValue toInject = (ObservableValue)DataFXUtils.getPrivileged((Field)field, controller);
            if (toInject == null) {
                toInject = new SimpleObjectProperty();
                DataFXUtils.setPrivileged((Field)field, controller, (Object)toInject);
            }
            if (Property.class.isAssignableFrom(field.getType())) {
                if (foundProperty instanceof Property) {
                    ((Property)toInject).bindBidirectional((Property)foundProperty);
                    continue;
                }
                if (!(foundProperty instanceof ObservableValue)) continue;
                ((Property)toInject).bind((ObservableValue)foundProperty);
                continue;
            }
            if (!(foundProperty instanceof Property)) continue;
            ((Property)toInject).bind((ObservableValue)foundProperty);
        }
    }
}

