/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.util;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.io.PrivateKeyCredentialReader;
import edu.vt.middleware.crypt.io.PublicKeyCredentialReader;
import edu.vt.middleware.crypt.io.SecretKeyCredentialReader;
import edu.vt.middleware.crypt.io.X509CertificateCredentialReader;
import edu.vt.middleware.crypt.io.X509CertificatesCredentialReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;

public class CryptReader {
    public static final String DEFAULT_CERTIFICATE_TYPE = "X.509";

    protected CryptReader() {
    }

    public static SecretKey readSecretKey(File keyFile, String algorithm) throws CryptException, IOException {
        return new SecretKeyCredentialReader(algorithm).read(keyFile);
    }

    public static SecretKey readSecretKey(InputStream keyStream, String algorithm) throws CryptException, IOException {
        return new SecretKeyCredentialReader(algorithm).read(keyStream);
    }

    public static PrivateKey readPrivateKey(File keyFile) throws CryptException, IOException {
        return (PrivateKey)new PrivateKeyCredentialReader().read(keyFile);
    }

    public static PrivateKey readPrivateKey(InputStream keyStream) throws CryptException, IOException {
        return (PrivateKey)new PrivateKeyCredentialReader().read(keyStream);
    }

    public static PrivateKey readPrivateKey(File keyFile, char[] password) throws CryptException, IOException {
        return new PrivateKeyCredentialReader().read(keyFile, password);
    }

    public static PrivateKey readPrivateKey(InputStream keyStream, char[] password) throws CryptException, IOException {
        return new PrivateKeyCredentialReader().read(keyStream, password);
    }

    public static PublicKey readPublicKey(File keyFile) throws CryptException, IOException {
        return (PublicKey)new PublicKeyCredentialReader().read(keyFile);
    }

    public static PublicKey readPublicKey(InputStream keyStream) throws CryptException, IOException {
        return (PublicKey)new PublicKeyCredentialReader().read(keyStream);
    }

    public static Certificate readCertificate(File certFile) throws CryptException, IOException {
        return CryptReader.readCertificate(certFile, DEFAULT_CERTIFICATE_TYPE);
    }

    public static Certificate readCertificate(File certFile, String type) throws CryptException, IOException {
        if (!DEFAULT_CERTIFICATE_TYPE.equals(type)) {
            throw new UnsupportedOperationException(type + " not supported.");
        }
        return new X509CertificateCredentialReader().read(certFile);
    }

    public static Certificate readCertificate(InputStream certStream) throws CryptException, IOException {
        return CryptReader.readCertificate(certStream, DEFAULT_CERTIFICATE_TYPE);
    }

    public static Certificate readCertificate(InputStream certStream, String type) throws CryptException, IOException {
        if (!DEFAULT_CERTIFICATE_TYPE.equals(type)) {
            throw new UnsupportedOperationException(type + " not supported.");
        }
        return new X509CertificateCredentialReader().read(certStream);
    }

    public static Certificate[] readCertificateChain(File chainFile) throws CryptException, IOException {
        return CryptReader.readCertificateChain(chainFile, DEFAULT_CERTIFICATE_TYPE);
    }

    public static Certificate[] readCertificateChain(File chainFile, String type) throws CryptException, IOException {
        return CryptReader.readCertificateChain(new BufferedInputStream(new FileInputStream(chainFile)));
    }

    public static Certificate[] readCertificateChain(InputStream chainStream) throws CryptException, IOException {
        return CryptReader.readCertificateChain(chainStream, DEFAULT_CERTIFICATE_TYPE);
    }

    public static Certificate[] readCertificateChain(InputStream chainStream, String type) throws CryptException, IOException {
        if (!DEFAULT_CERTIFICATE_TYPE.equals(type)) {
            throw new UnsupportedOperationException(type + " not supported.");
        }
        return new X509CertificatesCredentialReader().read(chainStream);
    }
}

