/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.symmetric;

import edu.vt.middleware.crypt.AbstractEncryptionAlgorithm;
import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.CryptProvider;
import edu.vt.middleware.crypt.symmetric.AES;
import edu.vt.middleware.crypt.symmetric.AlgorithmSpec;
import edu.vt.middleware.crypt.symmetric.Blowfish;
import edu.vt.middleware.crypt.symmetric.CAST5;
import edu.vt.middleware.crypt.symmetric.CAST6;
import edu.vt.middleware.crypt.symmetric.DES;
import edu.vt.middleware.crypt.symmetric.DESede;
import edu.vt.middleware.crypt.symmetric.RC2;
import edu.vt.middleware.crypt.symmetric.RC4;
import edu.vt.middleware.crypt.symmetric.RC5;
import edu.vt.middleware.crypt.symmetric.RC6;
import edu.vt.middleware.crypt.symmetric.Rijndael;
import edu.vt.middleware.crypt.symmetric.Serpent;
import edu.vt.middleware.crypt.symmetric.Skipjack;
import edu.vt.middleware.crypt.symmetric.Twofish;
import java.lang.reflect.Constructor;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SymmetricAlgorithm
extends AbstractEncryptionAlgorithm {
    public static final String DEFAULT_MODE = "CBC";
    public static final String DEFAULT_PADDING = "PKCS5Padding";
    private static final int COMMON_BLOCK_SIZE = 16;
    private static final int CHUNK_SIZE = 2048;
    private static final Map<String, Class<? extends SymmetricAlgorithm>> NAME_CLASS_MAP = new HashMap<String, Class<? extends SymmetricAlgorithm>>();
    protected byte[] iv;
    protected AlgorithmParameterSpec paramSpec;

    protected SymmetricAlgorithm(String cipherAlgorithm, String cipherModeName, String cipherPadding) {
        super(cipherAlgorithm, cipherModeName, cipherPadding);
    }

    public static SymmetricAlgorithm newInstance(String cipherAlgorithm) {
        return SymmetricAlgorithm.newInstance(cipherAlgorithm, DEFAULT_MODE, DEFAULT_PADDING);
    }

    public static SymmetricAlgorithm newInstance(AlgorithmSpec spec) {
        return SymmetricAlgorithm.newInstance(spec.getName(), spec.getMode() != null ? spec.getMode() : DEFAULT_MODE, spec.getPadding() == null ? spec.getPadding() : DEFAULT_PADDING);
    }

    public static SymmetricAlgorithm newInstance(String cipherAlgorithm, String cipherModeName, String cipherPadding) {
        Class<? extends SymmetricAlgorithm> clazz = NAME_CLASS_MAP.get(cipherAlgorithm.toUpperCase());
        if (clazz != null) {
            try {
                Constructor<? extends SymmetricAlgorithm> cons = clazz.getConstructor(String.class, String.class);
                return cons.newInstance(cipherModeName, cipherPadding);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(String.format("Invalid cipher %s/%s/%s", cipherAlgorithm, cipherModeName, cipherPadding), ex);
            }
        }
        return new SymmetricAlgorithm(cipherAlgorithm, cipherModeName, cipherPadding);
    }

    public static SymmetricAlgorithm newInstance(AlgorithmSpec spec, AlgorithmParameterSpec cipherSpec) {
        SymmetricAlgorithm cipher = SymmetricAlgorithm.newInstance(spec);
        cipher.paramSpec = cipherSpec;
        return cipher;
    }

    public static SecretKey generateKey(String algorithm, int bitLength, SecureRandom random) throws CryptException {
        if (random == null) {
            throw new CryptException("Source of random data cannot be null.");
        }
        KeyGenerator keyGen = CryptProvider.getKeyGenerator(algorithm);
        keyGen.init(bitLength, random);
        try {
            return keyGen.generateKey();
        }
        catch (Exception ex) {
            throw new CryptException("Error generating key for " + algorithm, ex);
        }
    }

    public SecretKey generateKey() throws CryptException {
        return this.generateKey(this.getDefaultKeyLength());
    }

    public SecretKey generateKey(int bitLength) throws CryptException {
        if (this.randomProvider != null) {
            return SymmetricAlgorithm.generateKey(this.algorithm, bitLength, this.randomProvider);
        }
        return SymmetricAlgorithm.generateKey(this.algorithm, bitLength, new SecureRandom());
    }

    public void setIV(byte[] ivBytes) {
        if (ivBytes == null) {
            throw new IllegalArgumentException("IV cannot be null.");
        }
        if (ivBytes.length != this.getBlockSize()) {
            throw new IllegalArgumentException(String.format("IV length (%s) is not equal to block size (%s).", ivBytes.length, this.getBlockSize()));
        }
        this.iv = ivBytes;
    }

    public boolean hasIV() {
        return this.iv != null && this.iv.length > 0;
    }

    public byte[] getRandomIV() {
        if (this.cipher == null) {
            throw new IllegalStateException("Cipher not initialized.");
        }
        return this.getRandomData(this.getBlockSize());
    }

    public int[] getAllowedKeyLengths() {
        throw new UnsupportedOperationException("Available key lengths are not known.");
    }

    public int getDefaultKeyLength() {
        throw new UnsupportedOperationException("Default key length is not known.");
    }

    public int getMinKeyLength() {
        return this.getAllowedKeyLengths()[this.getAllowedKeyLengths().length - 1];
    }

    public int getMaxKeyLength() {
        return this.getAllowedKeyLengths()[0];
    }

    public boolean isValidKeyLength(int bitLength) {
        int[] sizes = this.getAllowedKeyLengths();
        for (int i = 0; i < sizes.length; ++i) {
            if (bitLength != sizes[0]) continue;
            return true;
        }
        return false;
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec() {
        AlgorithmParameterSpec spec;
        if (this.paramSpec != null) {
            spec = this.paramSpec;
        } else if (this.iv != null) {
            spec = new IvParameterSpec(this.iv);
        } else {
            if (DEFAULT_MODE.equals(this.mode)) {
                throw new IllegalStateException("CBC mode requires an IV.");
            }
            return null;
        }
        return spec;
    }

    protected int getChunkSize() {
        return 2048;
    }

    static {
        NAME_CLASS_MAP.put("AES", AES.class);
        NAME_CLASS_MAP.put("BLOWFISH", Blowfish.class);
        NAME_CLASS_MAP.put("CAST5", CAST5.class);
        NAME_CLASS_MAP.put("CAST6", CAST6.class);
        NAME_CLASS_MAP.put("DES", DES.class);
        NAME_CLASS_MAP.put("DESEDE", DESede.class);
        NAME_CLASS_MAP.put("RC2", RC2.class);
        NAME_CLASS_MAP.put("RC4", RC4.class);
        NAME_CLASS_MAP.put("RC5", RC5.class);
        NAME_CLASS_MAP.put("RC6", RC6.class);
        NAME_CLASS_MAP.put("RIJNDAEL", Rijndael.class);
        NAME_CLASS_MAP.put("SERPENT", Serpent.class);
        NAME_CLASS_MAP.put("SKIPJACK", Skipjack.class);
        NAME_CLASS_MAP.put("TWOFISH", Twofish.class);
    }
}

