/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.parser;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.runtime.ANTLRStringStream;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;

public class ExpressionTree {
    private TreeNode root = null;
    private final Stack<TreeNode> nodeStack = new Stack();

    private static String makeFilterForEquals(String keyName, String value, String paramName, Map<String, Object> params, int keyPos, int keyCount) throws MetaException {
        HashMap<String, String> partKeyToVal = new HashMap<String, String>();
        partKeyToVal.put(keyName, value);
        String escapedNameFragment = Warehouse.makePartName(partKeyToVal, false);
        StringBuilder fltr = new StringBuilder();
        if (keyCount == 1) {
            params.put(paramName, escapedNameFragment);
            fltr.append("partitionName == ").append(paramName);
        } else if (keyPos + 1 == keyCount) {
            params.put(paramName, "/" + escapedNameFragment);
            fltr.append("partitionName.endsWith(").append(paramName).append(')');
        } else if (keyPos == 0) {
            params.put(paramName, escapedNameFragment + "/");
            fltr.append("partitionName.startsWith(").append(paramName).append(')');
        } else {
            params.put(paramName, "/" + escapedNameFragment + "/");
            fltr.append("partitionName.indexOf(").append(paramName).append(") >= 0");
        }
        return fltr.toString();
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void addIntermediateNode(LogicalOperator andOr) {
        TreeNode rhs = this.nodeStack.pop();
        TreeNode lhs = this.nodeStack.pop();
        TreeNode newNode = new TreeNode(lhs, andOr, rhs);
        this.nodeStack.push(newNode);
        this.root = newNode;
    }

    public void addLeafNode(LeafNode newNode) {
        if (this.root == null) {
            this.root = newNode;
        }
        this.nodeStack.push(newNode);
    }

    public String generateJDOFilter(Table table, Map<String, Object> params) throws MetaException {
        if (this.root == null) {
            return "";
        }
        return this.root.generateJDOFilter(table, params);
    }

    public static class ANTLRNoCaseStringStream
    extends ANTLRStringStream {
        public ANTLRNoCaseStringStream(String input) {
            super(input);
        }

        public int LA(int i) {
            int returnChar = super.LA(i);
            if (returnChar == -1) {
                return returnChar;
            }
            if (returnChar == 0) {
                return returnChar;
            }
            return Character.toUpperCase((char)returnChar);
        }
    }

    public static class LeafNode
    extends TreeNode {
        public String keyName;
        public Operator operator;
        public Object value;
        public boolean isReverseOrder = false;
        private static final String PARAM_PREFIX = "hive_filter_param_";
        private static final Set<Operator> TABLE_FILTER_OPS = Sets.newHashSet((Object[])new Operator[]{Operator.EQUALS, Operator.NOTEQUALS, Operator.NOTEQUALS2});

        @Override
        public void accept(TreeVisitor visitor) throws MetaException {
            visitor.visit(this);
        }

        @Override
        public String generateJDOFilter(Table table, Map<String, Object> params) throws MetaException {
            if (table != null) {
                return this.generateJDOFilterOverPartitions(table, params);
            }
            return this.generateJDOFilterOverTables(params);
        }

        private String generateJDOFilterOverTables(Map<String, Object> params) throws MetaException {
            if (this.keyName.equals("hive_filter_field_owner__")) {
                this.keyName = "this.owner";
            } else if (this.keyName.equals("hive_filter_field_last_access__")) {
                if (this.operator == Operator.LIKE) {
                    throw new MetaException("Like is not supported for HIVE_FILTER_FIELD_LAST_ACCESS");
                }
                this.keyName = "this.lastAccessTime";
            } else if (this.keyName.startsWith("hive_filter_field_params__")) {
                if (!TABLE_FILTER_OPS.contains((Object)this.operator)) {
                    throw new MetaException("Only " + TABLE_FILTER_OPS + " are supported " + "operators for HIVE_FILTER_FIELD_PARAMS");
                }
                String paramKeyName = this.keyName.substring("hive_filter_field_params__".length());
                this.keyName = "this.parameters.get(\"" + paramKeyName + "\")";
                this.value = this.value.toString();
            } else {
                throw new MetaException("Invalid key name in filter.  Use constants from org.apache.hadoop.hive.metastore.api");
            }
            return this.generateJDOFilterGeneral(params);
        }

        private String generateJDOFilterGeneral(Map<String, Object> params) throws MetaException {
            String filter;
            String paramName = PARAM_PREFIX + params.size();
            params.put(paramName, this.value);
            if (this.isReverseOrder) {
                if (this.operator == Operator.LIKE) {
                    throw new MetaException("Value should be on the RHS for LIKE operator : Key <" + this.keyName + ">");
                }
                filter = paramName + " " + this.operator.getJdoOp() + " " + this.keyName;
            } else {
                filter = this.operator == Operator.LIKE ? " " + this.keyName + "." + this.operator.getJdoOp() + "(" + paramName + ") " : " " + this.keyName + " " + this.operator.getJdoOp() + " " + paramName;
            }
            return filter;
        }

        private String generateJDOFilterOverPartitions(Table table, Map<String, Object> params) throws MetaException {
            String filter;
            int partitionColumnCount = table.getPartitionKeys().size();
            int partitionColumnIndex = this.getPartColIndexForFilter(table);
            String valueAsString = this.getFilterPushdownParam(table, partitionColumnIndex);
            String paramName = PARAM_PREFIX + params.size();
            params.put(paramName, valueAsString);
            String keyEqual = FileUtils.escapePathName((String)this.keyName) + "=";
            int keyEqualLength = keyEqual.length();
            String valString = partitionColumnIndex == partitionColumnCount - 1 ? "partitionName.substring(partitionName.indexOf(\"" + keyEqual + "\")+" + keyEqualLength + ")" : "partitionName.substring(partitionName.indexOf(\"" + keyEqual + "\")+" + keyEqualLength + ").substring(0, partitionName.substring(partitionName.indexOf(\"" + keyEqual + "\")+" + keyEqualLength + ").indexOf(\"/\"))";
            if (this.isReverseOrder) {
                if (this.operator == Operator.LIKE) {
                    throw new MetaException("Value should be on the RHS for LIKE operator : Key <" + this.keyName + ">");
                }
                filter = this.operator == Operator.EQUALS ? ExpressionTree.makeFilterForEquals(this.keyName, valueAsString, paramName, params, partitionColumnIndex, partitionColumnCount) : paramName + " " + this.operator.getJdoOp() + " " + valString;
            } else {
                filter = this.operator == Operator.LIKE ? " " + valString + "." + this.operator.getJdoOp() + "(" + paramName + ") " : (this.operator == Operator.EQUALS ? ExpressionTree.makeFilterForEquals(this.keyName, valueAsString, paramName, params, partitionColumnIndex, partitionColumnCount) : " " + valString + " " + this.operator.getJdoOp() + " " + paramName);
            }
            return filter;
        }

        private static boolean doesOperatorSupportIntegral(Operator operator) {
            return operator == Operator.EQUALS || operator == Operator.NOTEQUALS || operator == Operator.NOTEQUALS2;
        }

        private static boolean isIntegralType(String type) {
            return type.equals("tinyint") || type.equals("smallint") || type.equals("int") || type.equals("bigint");
        }

        public int getPartColIndexForFilter(Table table) throws MetaException {
            int partitionColumnIndex;
            assert (table.getPartitionKeys().size() > 0);
            for (partitionColumnIndex = 0; partitionColumnIndex < table.getPartitionKeys().size() && !table.getPartitionKeys().get(partitionColumnIndex).getName().equalsIgnoreCase(this.keyName); ++partitionColumnIndex) {
            }
            if (partitionColumnIndex == table.getPartitionKeys().size()) {
                throw new MetaException("Specified key <" + this.keyName + "> is not a partitioning key for the table");
            }
            return partitionColumnIndex;
        }

        public String getFilterPushdownParam(Table table, int partColIndex) throws MetaException {
            boolean isIntegralSupported = LeafNode.doesOperatorSupportIntegral(this.operator);
            String colType = table.getPartitionKeys().get(partColIndex).getType();
            if (!(colType.equals("string") || isIntegralSupported && LeafNode.isIntegralType(colType))) {
                throw new MetaException("Filtering is supported only on partition keys of type string" + (isIntegralSupported ? ", or integral types" : ""));
            }
            boolean isStringValue = this.value instanceof String;
            if (!(isStringValue || isIntegralSupported && this.value instanceof Long)) {
                throw new MetaException("Filtering is supported only on partition keys of type string" + (isIntegralSupported ? ", or integral types" : ""));
            }
            return isStringValue ? (String)this.value : Long.toString((Long)this.value);
        }
    }

    public static class TreeNode {
        private TreeNode lhs;
        private LogicalOperator andOr;
        private TreeNode rhs;

        public TreeNode() {
        }

        public TreeNode(TreeNode lhs, LogicalOperator andOr, TreeNode rhs) {
            this.lhs = lhs;
            this.andOr = andOr;
            this.rhs = rhs;
        }

        public TreeNode getLhs() {
            return this.lhs;
        }

        public LogicalOperator getAndOr() {
            return this.andOr;
        }

        public TreeNode getRhs() {
            return this.rhs;
        }

        public void accept(TreeVisitor visitor) throws MetaException {
            visitor.visit(this);
        }

        public String generateJDOFilter(Table table, Map<String, Object> params) throws MetaException {
            StringBuilder filterBuffer = new StringBuilder();
            if (this.lhs != null) {
                filterBuffer.append(" (");
                filterBuffer.append(this.lhs.generateJDOFilter(table, params));
                if (this.rhs != null) {
                    if (this.andOr == LogicalOperator.AND) {
                        filterBuffer.append(" && ");
                    } else {
                        filterBuffer.append(" || ");
                    }
                    filterBuffer.append(this.rhs.generateJDOFilter(table, params));
                }
                filterBuffer.append(") ");
            }
            return filterBuffer.toString();
        }
    }

    public static interface TreeVisitor {
        public void visit(TreeNode var1) throws MetaException;

        public void visit(LeafNode var1) throws MetaException;
    }

    public static enum Operator {
        EQUALS("=", "==", "="),
        GREATERTHAN(">"),
        LESSTHAN("<"),
        LESSTHANOREQUALTO("<="),
        GREATERTHANOREQUALTO(">="),
        LIKE("LIKE", "matches", "like"),
        NOTEQUALS2("!=", "!=", "<>"),
        NOTEQUALS("<>", "!=", "<>");

        private final String op;
        private final String jdoOp;
        private final String sqlOp;

        private Operator(String op) {
            this.op = op;
            this.jdoOp = op;
            this.sqlOp = op;
        }

        private Operator(String op, String jdoOp, String sqlOp) {
            this.op = op;
            this.jdoOp = jdoOp;
            this.sqlOp = sqlOp;
        }

        public String getOp() {
            return this.op;
        }

        public String getJdoOp() {
            return this.jdoOp;
        }

        public String getSqlOp() {
            return this.sqlOp;
        }

        public static Operator fromString(String inputOperator) {
            for (Operator op : Operator.values()) {
                if (!op.getOp().equals(inputOperator)) continue;
                return op;
            }
            throw new Error("Invalid value " + inputOperator + " for " + Operator.class.getSimpleName());
        }

        public String toString() {
            return this.op;
        }
    }

    public static enum LogicalOperator {
        AND,
        OR;

    }
}

