/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.SkewedValueList;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.parser.FilterParser;

class MetaStoreDirectSql {
    private static final Log LOG = LogFactory.getLog(MetaStoreDirectSql.class);
    private final PersistenceManager pm;

    public MetaStoreDirectSql(PersistenceManager pm) {
        this.pm = pm;
    }

    public List<Partition> getPartitionsViaSqlFilter(String dbName, String tblName, List<String> partNames) throws MetaException {
        String list = StringUtils.repeat((String)",?", (int)partNames.size()).substring(1);
        return this.getPartitionsViaSqlFilterInternal(dbName, tblName, "and \"PARTITIONS\".\"PART_NAME\" in (" + list + ")", partNames, new ArrayList<String>());
    }

    public List<Partition> getPartitionsViaSqlFilter(Table table, String dbName, String tblName, FilterParser parser) throws MetaException {
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<String> joins = new ArrayList<String>();
        String sqlFilter = parser == null ? null : PartitionFilterGenerator.generateSqlFilter(table, parser.tree, params, joins);
        return this.getPartitionsViaSqlFilterInternal(dbName, tblName, sqlFilter, params, joins);
    }

    private List<Partition> getPartitionsViaSqlFilterInternal(String dbName, String tblName, String sqlFilter, List<String> paramsForFilter, List<String> joinsForFilter) throws MetaException {
        boolean hasSkewedColumns;
        boolean doTrace = LOG.isDebugEnabled();
        String queryText = "select \"PARTITIONS\".\"PART_ID\" from \"PARTITIONS\"  inner join \"TBLS\" on \"PARTITIONS\".\"TBL_ID\" = \"TBLS\".\"TBL_ID\"   inner join \"DBS\" on \"TBLS\".\"DB_ID\" = \"DBS\".\"DB_ID\" " + StringUtils.join(joinsForFilter, (char)' ') + " where \"TBLS\".\"TBL_NAME\" = ? and \"DBS\".\"NAME\" = ?" + (sqlFilter == null ? "" : " " + sqlFilter);
        Object[] params = new Object[paramsForFilter.size() + 2];
        params[0] = tblName;
        params[1] = dbName;
        for (int i = 0; i < paramsForFilter.size(); ++i) {
            params[i + 2] = paramsForFilter.get(i);
        }
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        List sqlResult = (List)query.executeWithArray(params);
        if (sqlResult.isEmpty()) {
            return new ArrayList<Partition>();
        }
        long queryTime = doTrace ? System.nanoTime() : 0L;
        int sbCapacity = sqlResult.size() * 7;
        StringBuilder partSb = new StringBuilder(sbCapacity);
        for (Object partitionId : sqlResult) {
            partSb.append((Long)partitionId).append(",");
        }
        String partIds = MetaStoreDirectSql.trimCommaList(partSb);
        if (doTrace) {
            LOG.debug((Object)("Direct SQL query in " + (double)(queryTime - start) / 1000000.0 + "ms + " + (double)(System.nanoTime() - queryTime) / 1000000.0 + "ms, the query is [ " + queryText + "]"));
        }
        queryText = "select \"PARTITIONS\".\"PART_ID\", \"SDS\".\"SD_ID\", \"SDS\".\"CD_ID\", \"SERDES\".\"SERDE_ID\",   \"PARTITIONS\".\"CREATE_TIME\", \"PARTITIONS\".\"LAST_ACCESS_TIME\", \"SDS\".\"INPUT_FORMAT\",   \"SDS\".\"IS_COMPRESSED\", \"SDS\".\"IS_STOREDASSUBDIRECTORIES\", \"SDS\".\"LOCATION\",  \"SDS\".\"NUM_BUCKETS\",   \"SDS\".\"OUTPUT_FORMAT\", \"SERDES\".\"NAME\", \"SERDES\".\"SLIB\" from \"PARTITIONS\"  left outer join \"SDS\" on \"PARTITIONS\".\"SD_ID\" = \"SDS\".\"SD_ID\"   left outer join \"SERDES\" on \"SDS\".\"SERDE_ID\" = \"SERDES\".\"SERDE_ID\" where \"PART_ID\" in (" + partIds + ") order by \"PART_NAME\" asc";
        start = doTrace ? System.nanoTime() : 0L;
        query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        List sqlResult2 = (List)query.executeWithArray(params);
        queryTime = doTrace ? System.nanoTime() : 0L;
        TreeMap<Long, Partition> partitions = new TreeMap<Long, Partition>();
        TreeMap<Long, StorageDescriptor> sds = new TreeMap<Long, StorageDescriptor>();
        TreeMap<Long, SerDeInfo> serdes = new TreeMap<Long, SerDeInfo>();
        TreeMap colss = new TreeMap();
        ArrayList<Partition> orderedResult = new ArrayList<Partition>(sqlResult.size());
        StringBuilder sdSb = new StringBuilder(sbCapacity);
        StringBuilder serdeSb = new StringBuilder(sbCapacity);
        StringBuilder colsSb = new StringBuilder(7);
        tblName = tblName.toLowerCase();
        dbName = dbName.toLowerCase();
        for (Object[] fields : sqlResult2) {
            long partitionId = (Long)fields[0];
            Long sdId = (Long)fields[1];
            Long colId = (Long)fields[2];
            Long serdeId = (Long)fields[3];
            if (sdId == null || colId == null || serdeId == null) {
                throw new MetaException("Unexpected null for one of the IDs, SD " + sdId + ", column " + colId + ", serde " + serdeId);
            }
            Partition part = new Partition();
            orderedResult.add(part);
            part.setParameters(new HashMap<String, String>());
            part.setValues(new ArrayList<String>());
            part.setDbName(dbName);
            part.setTableName(tblName);
            if (fields[4] != null) {
                part.setCreateTime((Integer)fields[4]);
            }
            if (fields[5] != null) {
                part.setLastAccessTime((Integer)fields[5]);
            }
            partitions.put(partitionId, part);
            StorageDescriptor sd = new StorageDescriptor();
            StorageDescriptor oldSd = sds.put(sdId, sd);
            if (oldSd != null) {
                throw new MetaException("Partitions reuse SDs; we don't expect that");
            }
            sd.setSortCols(new ArrayList<Order>());
            sd.setBucketCols(new ArrayList<String>());
            sd.setParameters(new HashMap<String, String>());
            sd.setSkewedInfo(new SkewedInfo(new ArrayList<String>(), new ArrayList<List<String>>(), new HashMap<SkewedValueList, String>()));
            sd.setInputFormat((String)fields[6]);
            Boolean tmpBoolean = MetaStoreDirectSql.extractSqlBoolean(fields[7]);
            if (tmpBoolean != null) {
                sd.setCompressed(tmpBoolean);
            }
            if ((tmpBoolean = MetaStoreDirectSql.extractSqlBoolean(fields[8])) != null) {
                sd.setStoredAsSubDirectories(tmpBoolean);
            }
            sd.setLocation((String)fields[9]);
            if (fields[10] != null) {
                sd.setNumBuckets((Integer)fields[10]);
            }
            sd.setOutputFormat((String)fields[11]);
            sdSb.append(sdId).append(",");
            part.setSd(sd);
            ArrayList cols = (ArrayList)colss.get(colId);
            if (cols == null) {
                cols = new ArrayList();
                colss.put(colId, cols);
                colsSb.append(colId).append(",");
            }
            sd.setCols(cols);
            SerDeInfo serde = new SerDeInfo();
            SerDeInfo oldSerde = serdes.put(serdeId, serde);
            if (oldSerde != null) {
                throw new MetaException("SDs reuse serdes; we don't expect that");
            }
            serde.setParameters(new HashMap<String, String>());
            serde.setName((String)fields[12]);
            serde.setSerializationLib((String)fields[13]);
            serdeSb.append(serdeId).append(",");
            sd.setSerdeInfo(serde);
        }
        query.closeAll();
        if (doTrace) {
            LOG.debug((Object)("Direct SQL query in " + (double)(queryTime - start) / 1000000.0 + "ms + " + (double)(System.nanoTime() - queryTime) / 1000000.0 + "ms, the query is [ " + queryText + "]"));
        }
        String sdIds = MetaStoreDirectSql.trimCommaList(sdSb);
        String serdeIds = MetaStoreDirectSql.trimCommaList(serdeSb);
        String colIds = MetaStoreDirectSql.trimCommaList(colsSb);
        queryText = "select \"PART_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from \"PARTITION_PARAMS\" where \"PART_ID\" in (" + partIds + ") and \"PARAM_KEY\" is not null order by \"PART_ID\" asc";
        this.loopJoinOrderedResult(partitions, queryText, 0, new ApplyFunc<Partition>(){

            @Override
            public void apply(Partition t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        queryText = "select \"PART_ID\", \"PART_KEY_VAL\" from \"PARTITION_KEY_VALS\" where \"PART_ID\" in (" + partIds + ") and \"INTEGER_IDX\" >= 0 order by \"PART_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(partitions, queryText, 0, new ApplyFunc<Partition>(){

            @Override
            public void apply(Partition t, Object[] fields) {
                t.addToValues((String)fields[1]);
            }
        });
        queryText = "select \"SD_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from \"SD_PARAMS\" where \"SD_ID\" in (" + sdIds + ") and \"PARAM_KEY\" is not null order by \"SD_ID\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        queryText = "select \"SD_ID\", \"COLUMN_NAME\", \"SORT_COLS\".* from \"SORT_COLS\" where \"SD_ID\" in (" + sdIds + ") and \"INTEGER_IDX\" >= 0 order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                if (fields[4] == null) {
                    return;
                }
                t.addToSortCols(new Order((String)fields[1], (Integer)fields[4]));
            }
        });
        queryText = "select \"SD_ID\", \"BUCKET_COL_NAME\" from \"BUCKETING_COLS\" where \"SD_ID\" in (" + sdIds + ") and \"INTEGER_IDX\" >= 0 order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                t.addToBucketCols((String)fields[1]);
            }
        });
        queryText = "select \"SD_ID\", \"SKEWED_COL_NAME\" from \"SKEWED_COL_NAMES\" where \"SD_ID\" in (" + sdIds + ") and \"INTEGER_IDX\" >= 0 order by \"SD_ID\" asc, \"INTEGER_IDX\" asc";
        boolean bl = hasSkewedColumns = this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){

            @Override
            public void apply(StorageDescriptor t, Object[] fields) {
                if (!t.isSetSkewedInfo()) {
                    t.setSkewedInfo(new SkewedInfo());
                }
                t.getSkewedInfo().addToSkewedColNames((String)fields[1]);
            }
        }) > 0;
        if (hasSkewedColumns) {
            queryText = "select \"SKEWED_VALUES\".\"SD_ID_OID\", \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\",   \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_VALUE\" from \"SKEWED_VALUES\"   left outer join \"SKEWED_STRING_LIST_VALUES\" on     \"SKEWED_VALUES\".\"STRING_LIST_ID_EID\" = \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\" where \"SKEWED_VALUES\".\"SD_ID_OID\" in (" + sdIds + ") " + "  and \"SKEWED_VALUES\".\"STRING_LIST_ID_EID\" is not null " + "  and \"SKEWED_VALUES\".\"INTEGER_IDX\" >= 0 " + "order by \"SKEWED_VALUES\".\"SD_ID_OID\" asc, \"SKEWED_VALUES\".\"INTEGER_IDX\" asc, " + "  \"SKEWED_STRING_LIST_VALUES\".\"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){
                private Long currentListId;
                private List<String> currentList;

                @Override
                public void apply(StorageDescriptor t, Object[] fields) {
                    if (!t.isSetSkewedInfo()) {
                        t.setSkewedInfo(new SkewedInfo());
                    }
                    if (fields[1] == null) {
                        this.currentList = null;
                        this.currentListId = null;
                        t.getSkewedInfo().addToSkewedColValues(new ArrayList<String>());
                    } else {
                        long fieldsListId = (Long)fields[1];
                        if (this.currentListId == null || fieldsListId != this.currentListId) {
                            this.currentList = new ArrayList<String>();
                            this.currentListId = fieldsListId;
                            t.getSkewedInfo().addToSkewedColValues(this.currentList);
                        }
                        this.currentList.add((String)fields[2]);
                    }
                }
            });
            queryText = "select \"SKEWED_COL_VALUE_LOC_MAP\".\"SD_ID\", \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\",  \"SKEWED_COL_VALUE_LOC_MAP\".\"LOCATION\", \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_VALUE\" from \"SKEWED_COL_VALUE_LOC_MAP\"  left outer join \"SKEWED_STRING_LIST_VALUES\" on \"SKEWED_COL_VALUE_LOC_MAP\".\"STRING_LIST_ID_KID\" = \"SKEWED_STRING_LIST_VALUES\".\"STRING_LIST_ID\" where \"SKEWED_COL_VALUE_LOC_MAP\".\"SD_ID\" in (" + sdIds + ")" + "  and \"SKEWED_COL_VALUE_LOC_MAP\".\"STRING_LIST_ID_KID\" is not null " + "order by \"SKEWED_COL_VALUE_LOC_MAP\".\"SD_ID\" asc," + "  \"SKEWED_STRING_LIST_VALUES\".\"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(sds, queryText, 0, new ApplyFunc<StorageDescriptor>(){
                private Long currentListId;
                private SkewedValueList currentList;

                @Override
                public void apply(StorageDescriptor t, Object[] fields) {
                    if (!t.isSetSkewedInfo()) {
                        t.setSkewedInfo(new SkewedInfo());
                    }
                    if (fields[1] == null) {
                        this.currentList = null;
                        this.currentListId = null;
                        t.getSkewedInfo().putToSkewedColValueLocationMaps(new SkewedValueList(), (String)fields[2]);
                    } else {
                        long fieldsListId = (Long)fields[1];
                        if (this.currentListId == null || fieldsListId != this.currentListId) {
                            this.currentList = new SkewedValueList();
                            this.currentListId = fieldsListId;
                            t.getSkewedInfo().putToSkewedColValueLocationMaps(this.currentList, (String)fields[2]);
                        }
                        this.currentList.addToSkewedValueList((String)fields[3]);
                    }
                }
            });
        }
        if (!colss.isEmpty()) {
            queryText = "select \"CD_ID\", \"COMMENT\", \"COLUMN_NAME\", \"TYPE_NAME\" from \"COLUMNS_V2\" where \"CD_ID\" in (" + colIds + ") and \"INTEGER_IDX\" >= 0 order by \"CD_ID\" asc, \"INTEGER_IDX\" asc";
            this.loopJoinOrderedResult(colss, queryText, 0, new ApplyFunc<List<FieldSchema>>(){

                @Override
                public void apply(List<FieldSchema> t, Object[] fields) {
                    t.add(new FieldSchema((String)fields[2], (String)fields[3], (String)fields[1]));
                }
            });
        }
        queryText = "select \"SERDE_ID\", \"PARAM_KEY\", \"PARAM_VALUE\" from \"SERDE_PARAMS\" where \"SERDE_ID\" in (" + serdeIds + ") and \"PARAM_KEY\" is not null order by \"SERDE_ID\" asc";
        this.loopJoinOrderedResult(serdes, queryText, 0, new ApplyFunc<SerDeInfo>(){

            @Override
            public void apply(SerDeInfo t, Object[] fields) {
                t.putToParameters((String)fields[1], (String)fields[2]);
            }
        });
        return orderedResult;
    }

    private static Boolean extractSqlBoolean(Object value) throws MetaException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        Character c = null;
        if (value instanceof String && ((String)value).length() == 1) {
            c = Character.valueOf(((String)value).charAt(0));
        }
        if (c.charValue() == 'Y') {
            return true;
        }
        if (c.charValue() == 'N') {
            return false;
        }
        throw new MetaException("Cannot extrace boolean from column value " + value);
    }

    private static String trimCommaList(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private <T> int loopJoinOrderedResult(TreeMap<Long, T> tree, String queryText, int keyIndex, ApplyFunc<T> func) throws MetaException {
        long queryTime;
        boolean doTrace = LOG.isDebugEnabled();
        long start = doTrace ? System.nanoTime() : 0L;
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
        Object result = query.execute();
        long l = queryTime = doTrace ? System.nanoTime() : 0L;
        if (result == null) {
            query.closeAll();
            return 0;
        }
        if (!(result instanceof List)) {
            throw new MetaException("Wrong result type " + result.getClass());
        }
        List list = (List)result;
        Iterator iter = list.iterator();
        Object[] fields = null;
        block0: for (Map.Entry<Long, T> entry : tree.entrySet()) {
            if (fields == null && !iter.hasNext()) break;
            long id = entry.getKey();
            while (fields != null || iter.hasNext()) {
                long nestedId;
                if (fields == null) {
                    fields = (Object[])iter.next();
                }
                if ((nestedId = ((Long)fields[keyIndex]).longValue()) < id) {
                    throw new MetaException("Found entries for unknown ID " + nestedId);
                }
                if (nestedId > id) continue block0;
                func.apply(entry.getValue(), fields);
                fields = null;
            }
        }
        int rv = list.size();
        query.closeAll();
        if (doTrace) {
            LOG.debug((Object)("Direct SQL query in " + (double)(queryTime - start) / 1000000.0 + "ms + " + (double)(System.nanoTime() - queryTime) / 1000000.0 + "ms, the query is [" + queryText + "]"));
        }
        return rv;
    }

    private static class PartitionFilterGenerator
    implements ExpressionTree.TreeVisitor {
        private final Table table;
        private final StringBuilder filterBuffer;
        private final List<String> params;
        private final List<String> joins;

        private PartitionFilterGenerator(Table table, List<String> params, List<String> joins) {
            this.table = table;
            this.params = params;
            this.joins = joins;
            this.filterBuffer = new StringBuilder();
        }

        public static String generateSqlFilter(Table table, ExpressionTree tree, List<String> params, List<String> joins) throws MetaException {
            assert (table != null);
            if (tree.getRoot() == null) {
                return "";
            }
            PartitionFilterGenerator visitor = new PartitionFilterGenerator(table, params, joins);
            tree.getRoot().accept(visitor);
            for (int i = 0; i < joins.size(); ++i) {
                if (joins.get(i) != null) continue;
                joins.remove(i--);
            }
            return "and (" + visitor.filterBuffer.toString() + ")";
        }

        @Override
        public void visit(ExpressionTree.TreeNode node) throws MetaException {
            assert (node != null && node.getLhs() != null && node.getRhs() != null);
            this.filterBuffer.append(" (");
            node.getLhs().accept(this);
            this.filterBuffer.append(node.getAndOr() == ExpressionTree.LogicalOperator.AND ? " and " : " or ");
            node.getRhs().accept(this);
            this.filterBuffer.append(") ");
        }

        @Override
        public void visit(ExpressionTree.LeafNode node) throws MetaException {
            if (node.operator == ExpressionTree.Operator.LIKE) {
                throw new MetaException("LIKE is not supported for SQL filter pushdown");
            }
            int partColCount = this.table.getPartitionKeys().size();
            int partColIndex = node.getPartColIndexForFilter(this.table);
            String valueAsString = node.getFilterPushdownParam(this.table, partColIndex);
            this.params.add(valueAsString);
            if (this.joins.isEmpty()) {
                for (int i = 0; i < partColCount; ++i) {
                    this.joins.add(null);
                }
            }
            if (this.joins.get(partColIndex) == null) {
                this.joins.set(partColIndex, "inner join \"PARTITION_KEY_VALS\" as \"FILTER" + partColIndex + "\" on \"FILTER" + partColIndex + "\".\"PART_ID\" = \"PARTITIONS\".\"PART_ID\" and \"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex);
            }
            String tableValue = "\"FILTER" + partColIndex + "\".\"PART_KEY_VAL\"";
            this.filterBuffer.append(node.isReverseOrder ? "(? " + node.operator.getSqlOp() + " " + tableValue + ")" : "(" + tableValue + " " + node.operator.getSqlOp() + " ?)");
        }
    }

    private abstract class ApplyFunc<Target> {
        private ApplyFunc() {
        }

        public abstract void apply(Target var1, Object[] var2);
    }
}

