/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DataSourceConnectionProvider;
import com.samskivert.util.Config;
import com.samskivert.util.MissingPropertyException;
import com.samskivert.util.PropertiesUtil;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.postgresql.jdbc2.optional.PoolingDataSource;

public class PostgresUtil {
    public static ConnectionProvider createPoolingProvider(Config config, String projectId) {
        return PostgresUtil.createPoolingProvider(config, projectId, "db");
    }

    public static ConnectionProvider createPoolingProvider(Config config, String projectId, String prefix) {
        final DataSource[] sources = new DataSource[2];
        String[] modes = new String[]{"readonly", "readwrite"};
        String defPrefix = prefix + ".default";
        for (int ii = 0; ii < sources.length; ++ii) {
            String modePrefix = prefix + "." + modes[ii];
            try {
                Properties props = config.getSubProperties(defPrefix);
                config.getSubProperties(modePrefix, props);
                PoolingDataSource source = new PoolingDataSource();
                source.setDataSourceName(projectId + "." + modes[ii]);
                source.setServerName(PropertiesUtil.requireProperty((Properties)props, (String)"server"));
                source.setDatabaseName(PropertiesUtil.requireProperty((Properties)props, (String)"database"));
                source.setPortNumber(Integer.parseInt(PropertiesUtil.requireProperty((Properties)props, (String)"port")));
                source.setUser(PropertiesUtil.requireProperty((Properties)props, (String)"username"));
                source.setPassword(PropertiesUtil.requireProperty((Properties)props, (String)"password"));
                source.setMaxConnections(Integer.parseInt(props.getProperty("maxconns", "1")));
                sources[ii] = source;
                continue;
            }
            catch (MissingPropertyException mpe) {
                String key = mpe.getKey();
                throw new MissingPropertyException(key, "Unable to locate required property '" + key + "' as '" + defPrefix + "." + key + "' or '" + modePrefix + "." + key + "'.");
            }
        }
        return new DataSourceConnectionProvider("jdbc:postgresql", sources[0], sources[1]){
            protected AtomicBoolean _shutdown;
            {
                super(x0, x1, x2);
                this._shutdown = new AtomicBoolean();
            }

            public void shutdown() {
                if (this._shutdown.getAndSet(true)) {
                    return;
                }
                for (DataSource source : sources) {
                    ((PoolingDataSource)source).close();
                }
            }
        };
    }
}

