/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.StaticConnectionProvider;
import com.samskivert.util.Config;
import com.threerings.util.PostgresUtil;
import java.util.Properties;

public class ConnectionProviderUtil {
    public static ConnectionProvider createProvider(Config config, String ident) {
        return ConnectionProviderUtil.createProvider(config, ident, "db");
    }

    public static ConnectionProvider createProvider(Config config, String ident, String prefix) {
        DB type = DB.valueOf(config.getValue(prefix + ".type", "postgres"));
        switch (type) {
            case postgres: {
                return PostgresUtil.createPoolingProvider(config, ident, prefix);
            }
            case hsqldb: {
                Properties sub = config.getSubProperties(prefix);
                ConnectionProviderUtil.putIfNotPresent(sub, "default.driver", "org.hsqldb.jdbcDriver");
                ConnectionProviderUtil.putIfNotPresent(sub, "default.url", "jdbc:hsqldb:mem:.");
                ConnectionProviderUtil.putIfNotPresent(sub, "default.username", "sa");
                ConnectionProviderUtil.putIfNotPresent(sub, "default.password", "");
                return new StaticConnectionProvider(sub);
            }
        }
        throw new IllegalArgumentException("Unknown db type " + config.getValue(prefix + ".type", (String)null));
    }

    protected static void putIfNotPresent(Properties props, String key, String value) {
        if (!props.containsKey(key)) {
            props.put(key, value);
        }
    }

    public static enum DB {
        postgres,
        hsqldb;

    }
}

