/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.servlet.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Tuple;
import com.threerings.servlet.util.Parameters;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class QueryBuilder {
    protected final Multimap<String, String> _params = ArrayListMultimap.create();

    public String getOnly(String key) {
        return this.getOnly(key, null);
    }

    public String getOnly(String key, String defaultValue) {
        return (String)Iterables.getOnlyElement(this.get(key), (Object)defaultValue);
    }

    public String getFirst(String key) {
        Collection<String> values = this.get(key);
        return values.isEmpty() ? null : values.iterator().next();
    }

    public Collection<String> get(String key) {
        return this._params.get((Object)key);
    }

    public QueryBuilder add(String key, Object val) {
        this._params.put((Object)key, (Object)String.valueOf(val));
        return this;
    }

    public QueryBuilder addAll(HttpServletRequest req) {
        for (Tuple<String, String> entry : new Parameters((ServletRequest)req).entries()) {
            this.add((String)entry.left, entry.right);
        }
        return this;
    }

    public String toUrl(StringBuilder base) {
        return this._params.isEmpty() ? base.toString() : QueryBuilder.encode(base.append('?'), this._params.entries());
    }

    public String toUrl(String base) {
        return this.toUrl(new StringBuilder(base));
    }

    public String toString() {
        return QueryBuilder.encode(new StringBuilder(), this._params.entries());
    }

    protected static String encode(StringBuilder out, Iterable<Map.Entry<String, String>> entries) {
        boolean appended = false;
        for (Map.Entry<String, String> entry : entries) {
            out.append(StringUtil.encode((String)entry.getKey())).append('=').append(StringUtil.encode((String)entry.getValue())).append('&');
            appended = true;
        }
        if (appended) {
            out.setLength(out.length() - 1);
        }
        return out.toString();
    }
}

