/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.facebook.servlet;

import com.samskivert.servlet.util.CookieUtil;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Tuple;
import com.threerings.app.client.ServiceException;
import com.threerings.app.server.ServletAuthUtil;
import com.threerings.app.server.ServletLogic;
import com.threerings.facebook.Log;
import com.threerings.facebook.SignedRequest;
import com.threerings.facebook.servlet.FacebookConfig;
import com.threerings.servlet.util.Parameters;
import com.threerings.servlet.util.QueryBuilder;
import com.threerings.user.ExternalAuther;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Swizzler {
    protected final FacebookConfig _fbconf;
    protected final boolean _swizzled;
    protected final boolean _nakedAppURL;
    protected final boolean _allowGuests;
    protected final Parameters _params;
    protected final SignedRequest _fbsig;
    protected final HttpServletResponse _rsp;
    protected final HttpServletRequest _req;
    protected final String _appURL;
    protected final String _indexPath;
    protected final ServletLogic _servletLogic;

    public Swizzler(HttpServletRequest req, HttpServletResponse rsp, FacebookConfig fbconf, ServletLogic logic, String indexUrl, boolean allowGuests, boolean nakedAppURL) throws IOException {
        this._fbconf = fbconf;
        this._servletLogic = logic;
        this._req = req;
        this._rsp = rsp;
        this._indexPath = indexUrl;
        this._allowGuests = allowGuests;
        this._nakedAppURL = nakedAppURL;
        this._appURL = this._fbconf.getFacebookAppURL(this._req);
        this._params = new Parameters((ServletRequest)this._req);
        this._fbsig = new SignedRequest(this._params, this._fbconf.getFacebookSecret());
        this._swizzled = this.swizzle();
    }

    public boolean inFacebook() {
        return this._fbsig.isPresent();
    }

    public boolean isGuest() {
        return !this._fbsig.isAuthorized();
    }

    public boolean isSwizzled() {
        return this._swizzled;
    }

    protected boolean swizzle() throws IOException {
        if (this.inFacebook()) {
            if (!this.isGuest()) {
                return this.doAddedAuth();
            }
            if (this._allowGuests) {
                return this.doGuestAuth();
            }
            QueryBuilder qb = new QueryBuilder().add("client_id", (Object)this._fbconf.getFacebookAppId()).add("redirect_uri", (Object)this.makeCleanQuery().toUrl(this._appURL));
            this.writeFrameRedirect(qb.toUrl("https://www.facebook.com/dialog/oauth"));
            return false;
        }
        String authtok = this._params.get("swizzle");
        if (StringUtil.isBlank((String)authtok)) {
            Log.log.warning((Object)"We don't seem to be in Facebook or swizzling. WTF?", new Object[]{"req", this._req.getRequestURI()});
            this._rsp.sendError(500);
            return false;
        }
        if (!this._allowGuests && this._servletLogic.getUser(authtok) == null) {
            Log.log.warning((Object)"Requested to swizzle with invalid auth token", new Object[]{"req", this._req.getRequestURI(), "authtok", authtok});
            this._rsp.sendError(500);
            return false;
        }
        this.addCookie("auth", authtok);
        if (this._nakedAppURL) {
            QueryBuilder qb = this.makeCleanQuery().add("timestamp", (Object)System.currentTimeMillis());
            this.addCookie("params", qb.toString());
            this._rsp.sendRedirect(this._appURL);
        } else {
            this._rsp.sendRedirect(this.makeCleanQuery().toUrl(this._appURL));
        }
        return false;
    }

    protected boolean doGuestAuth() throws IOException {
        if (this.shouldSwizzleGuest()) {
            String tok = "" + System.currentTimeMillis() + Math.random();
            return this.swizzle(StringUtil.md5hex((String)tok));
        }
        return this.handleSwizzledUser();
    }

    protected boolean doAddedAuth() throws IOException {
        if (!this._servletLogic.refreshExternalSession(ExternalAuther.FACEBOOK, this._fbsig.getUserId(), this._fbsig.getToken(), this._req, this._rsp)) {
            String authTok;
            try {
                authTok = this._servletLogic.externalLogon(ExternalAuther.FACEBOOK, this._fbsig.getUserId(), this._fbsig.getToken());
            }
            catch (ServiceException se) {
                Log.log.warning((Object)"Failed to auth Facebook user", new Object[]{"uri", this._req.getRequestURI(), "cause", se.getMessage()});
                this._rsp.sendError(500);
                return false;
            }
            ServletAuthUtil.addAuthCookie((HttpServletRequest)this._req, (HttpServletResponse)this._rsp, (String)authTok, (int)-1);
            return this.swizzle(authTok);
        }
        return this.handleSwizzledUser();
    }

    protected boolean handleSwizzledUser() throws IOException {
        if (this._nakedAppURL) {
            for (String name : this._params.names()) {
                if (name.equals("signed_request")) continue;
                return this.swizzle(CookieUtil.getCookieValue((HttpServletRequest)this._req, (String)"auth"));
            }
        }
        String url = this._params.has("token") ? this._indexPath + "#" + this._params.get("token") : this._indexPath;
        this._rsp.sendRedirect(url);
        return true;
    }

    protected boolean shouldSwizzleGuest() {
        if (this._servletLogic.getUser(this._req) != null) {
            return true;
        }
        return StringUtil.isBlank((String)CookieUtil.getCookieValue((HttpServletRequest)this._req, (String)"auth"));
    }

    protected boolean swizzle(String authTok) throws IOException {
        this._rsp.addHeader("Connection", "close");
        this.writeFrameRedirect(this.makeCleanQuery().add("swizzle", (Object)authTok).toUrl(this._req.getRequestURI()));
        return false;
    }

    public void writeFrameRedirect(String url) throws IOException {
        PrintWriter out = this._rsp.getWriter();
        out.println("<html><head><script language=\"JavaScript\">");
        out.println("window.top.location = '" + url + "';");
        out.println("</script></head></html>");
        out.close();
    }

    protected QueryBuilder makeCleanQuery() {
        QueryBuilder qb = new QueryBuilder();
        for (Tuple entry : this._params.entries()) {
            if (((String)entry.left).equals("swizzle") || ((String)entry.left).equals("signed_request")) continue;
            qb.add((String)entry.left, entry.right);
        }
        return qb;
    }

    protected void addCookie(String key, Object value) {
        Cookie cookie = new Cookie(key, String.valueOf(value));
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        if (!this._req.getServerName().equals("localhost")) {
            cookie.setDomain("." + this._req.getServerName());
        }
        this._rsp.addCookie(cookie);
    }
}

