/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.facebook;

import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.FacebookJaxbRestClient;
import com.google.code.facebookapi.schema.FqlQueryResponse;
import com.threerings.facebook.FQL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class FQLQuery
implements FQL.Exp {
    protected String _table;
    protected List<FQL.Field> _fields;
    protected FQL.Clause _clause;

    public FQLQuery(String table, FQL.Field[] fields, FQL.Clause clause) {
        this._table = table;
        this._fields = Arrays.asList(fields);
        this._clause = clause;
    }

    public Iterable<Record> run(FacebookJaxbRestClient client) throws FacebookException {
        StringBuilder query = new StringBuilder();
        this.append(query);
        return new ResultSet((FqlQueryResponse)client.fql_query((CharSequence)query));
    }

    @Override
    public void append(StringBuilder query) {
        query.append("select ");
        FQL.join(this._fields, query);
        query.append(" from ").append(this._table).append(" ");
        this._clause.append(query);
    }

    protected int getFieldIdx(FQL.Field field) {
        int ll = this._fields.size();
        for (int ii = 0; ii < ll; ++ii) {
            if (this._fields.get(ii) != field) continue;
            return ii;
        }
        throw new NoSuchElementException();
    }

    protected class ResultSet
    implements Iterable<Record> {
        protected List<Object> _results;

        public ResultSet(FqlQueryResponse response) {
            this._results = response.getResults();
        }

        @Override
        public Iterator<Record> iterator() {
            return new Iterator<Record>(){
                protected int _pos;

                @Override
                public Record next() {
                    return ResultSet.this.getRecord(this._pos++);
                }

                @Override
                public boolean hasNext() {
                    return this._pos < ResultSet.this._results.size();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected Record getRecord(int idx) {
            final Node node = (Node)this._results.get(idx);
            return new Record(){

                @Override
                public String getField(FQL.Field field) {
                    Node fieldNode = node.getChildNodes().item(FQLQuery.this.getFieldIdx(field));
                    Text textContent = (Text)fieldNode.getFirstChild();
                    return textContent == null ? null : textContent.getData();
                }
            };
        }
    }

    public static interface Record {
        public String getField(FQL.Field var1);
    }
}

