/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.google.common.collect.Lists;
import com.threerings.openal.BlankSound;
import com.threerings.openal.ClipBuffer;
import com.threerings.openal.ClipProvider;
import com.threerings.openal.Log;
import com.threerings.openal.Sound;
import com.threerings.openal.SoundManager;
import com.threerings.openal.Source;
import java.util.ArrayList;
import org.lwjgl.openal.AL10;

public class SoundGroup {
    protected SoundManager _manager;
    protected ClipProvider _provider;
    protected ArrayList<PooledSource> _sources = Lists.newArrayList();
    protected float _baseGain = -1.0f;

    public void setBaseGain(float gain) {
        if (this._baseGain != gain) {
            this._baseGain = gain;
            this.baseGainChanged();
        }
    }

    public float getBaseGain() {
        return this._baseGain;
    }

    public void preloadClip(String path) {
        if (this._manager.isInitialized()) {
            this._manager.getClip(this._provider, path);
        }
    }

    public Sound getSound(String path) {
        ClipBuffer buffer = null;
        if (this._manager.isInitialized()) {
            buffer = this._manager.getClip(this._provider, path);
        }
        return buffer == null ? new BlankSound() : new Sound(this, buffer);
    }

    public void dispose() {
        this.reclaimAll();
        for (PooledSource pooled : this._sources) {
            pooled.source.delete();
        }
        this._sources.clear();
        this._manager.removeGroup(this);
    }

    public void reclaimAll() {
        for (PooledSource pooled : this._sources) {
            if (pooled.holder == null) continue;
            pooled.holder.stop();
            pooled.holder.reclaim();
            pooled.holder = null;
        }
    }

    protected SoundGroup(SoundManager manager, ClipProvider provider, int sources) {
        this._manager = manager;
        this._provider = provider;
        this._manager.addGroup(this);
        if (!this._manager.isInitialized()) {
            return;
        }
        for (int ii = 0; ii < sources; ++ii) {
            AL10.alGetError();
            PooledSource pooled = new PooledSource();
            pooled.source = new Source(manager);
            int errno = AL10.alGetError();
            if (errno != 0) {
                Log.log.warning((Object)("Failed to create sources [cprov=" + provider + ", sources=" + sources + ", errno=" + errno + "]."), new Object[0]);
                return;
            }
            this._sources.add(pooled);
        }
    }

    protected Source acquireSource(Sound acquirer) {
        int ll = this._sources.size();
        for (int ii = 0; ii < ll; ++ii) {
            PooledSource pooled = this._sources.get(ii);
            if (pooled.holder != null && !pooled.holder.reclaim()) continue;
            pooled.holder = acquirer;
            this._sources.remove(ii);
            this._sources.add(pooled);
            return pooled.source;
        }
        return null;
    }

    protected float getInheritedBaseGain() {
        return this._baseGain < 0.0f ? this._manager.getBaseGain() : this._baseGain;
    }

    protected void baseGainChanged() {
        int nn = this._sources.size();
        for (int ii = 0; ii < nn; ++ii) {
            Sound holder = this._sources.get((int)ii).holder;
            if (holder == null) continue;
            holder.updateSourceGain();
        }
    }

    protected static class PooledSource {
        public Source source;
        public Sound holder;

        protected PooledSource() {
        }
    }
}

