/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.util;

import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.threerings.miso.Log;
import com.threerings.miso.data.ObjectInfo;
import java.util.Arrays;
import java.util.Comparator;

public class ObjectSet {
    protected Object[] _objs = new Object[16];
    protected int _size;
    protected static final Comparator<Object> INFO_COMP = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            ObjectInfo do1 = (ObjectInfo)o1;
            ObjectInfo do2 = (ObjectInfo)o2;
            if (do1.tileId == do2.tileId) {
                return (do1.x << 16) + do1.y - ((do2.x << 16) + do2.y);
            }
            return do1.tileId - do2.tileId;
        }
    };
    protected static final int DEFAULT_SIZE = 16;

    public boolean insert(ObjectInfo info) {
        int ipos = this.indexOf(info);
        if (ipos >= 0) {
            Log.log.warning((Object)("Requested to add an object to a set that already contains such an object [ninfo=" + info + ", oinfo=" + this._objs[ipos] + "]."), new Object[]{new Exception()});
            return false;
        }
        ipos = -(ipos + 1);
        this._objs = ListUtil.insert((Object[])this._objs, (int)ipos, (Object)info);
        ++this._size;
        return true;
    }

    public boolean contains(ObjectInfo info) {
        return this.indexOf(info) >= 0;
    }

    public int size() {
        return this._size;
    }

    public ObjectInfo get(int index) {
        return (ObjectInfo)this._objs[index];
    }

    public void remove(int index) {
        ListUtil.remove((Object[])this._objs, (int)index);
        --this._size;
    }

    public boolean remove(ObjectInfo info) {
        int opos = this.indexOf(info);
        if (opos >= 0) {
            this.remove(opos);
            return true;
        }
        return false;
    }

    public void clear() {
        this._size = 0;
        Arrays.fill(this._objs, null);
    }

    public ObjectInfo[] toArray() {
        ObjectInfo[] info = new ObjectInfo[this._size];
        System.arraycopy(this._objs, 0, info, 0, this._size);
        return info;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (int ii = 0; ii < this._size; ++ii) {
            if (ii > 0) {
                buf.append(", ");
            }
            buf.append(this._objs[ii]);
        }
        return buf.append("]").toString();
    }

    protected final int indexOf(ObjectInfo info) {
        return ArrayUtil.binarySearch((Object[])this._objs, (int)0, (int)this._size, (Object)info, INFO_COMP);
    }
}

