/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.threerings.media.sprite.Sprite;
import com.threerings.media.util.LineSegmentPath;
import com.threerings.media.util.MathUtil;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import java.awt.Point;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilePath
extends LineSegmentPath {
    protected Point _last;
    protected int _estimPixels;

    public TilePath(MisoSceneMetrics metrics, Sprite sprite, List<Point> tiles, int destx, int desty) {
        int dir;
        Point fpos = new Point();
        MisoUtil.screenToFull(metrics, destx, desty, fpos);
        int sx = sprite.getX();
        int sy = sprite.getY();
        Point ipos = MisoUtil.screenToTile(metrics, sx, sy, new Point());
        this.addNode(sx, sy, 3);
        Point prev = new Point(ipos.x, ipos.y);
        Point spos = new Point();
        int size = tiles.size();
        for (int ii = 1; ii < size - 1; ++ii) {
            Point next = tiles.get(ii);
            dir = MisoUtil.getIsoDirection(prev.x, prev.y, next.x, next.y);
            MisoUtil.tileToScreen(metrics, next.x, next.y, spos);
            int dsx = spos.x + metrics.tilehwid;
            int dsy = spos.y + metrics.tilehhei;
            this.addNode(dsx, dsy, dir);
            prev = next;
        }
        MisoUtil.fullToScreen(metrics, fpos.x, fpos.y, spos);
        int tdestx = MisoUtil.fullToTile(fpos.x);
        int tdesty = MisoUtil.fullToTile(fpos.y);
        dir = prev.x == ipos.x && prev.y == ipos.y ? MisoUtil.getDirection(metrics, sx, sy, spos.x, spos.y) : MisoUtil.getIsoDirection(prev.x, prev.y, tdestx, tdesty);
        this.addNode(spos.x, spos.y, dir);
    }

    public long getEstimTravelTime() {
        return (long)((float)this._estimPixels / this._vel);
    }

    @Override
    public void addNode(int x, int y, int dir) {
        super.addNode(x, y, dir);
        if (this._last == null) {
            this._last = new Point();
        } else {
            this._estimPixels = (int)((float)this._estimPixels + MathUtil.distance(this._last.x, this._last.y, x, y));
        }
        this._last.setLocation(x, y);
    }
}

