/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.google.common.collect.Maps;
import com.samskivert.util.IntTuple;
import com.threerings.media.util.MathUtil;
import com.threerings.miso.client.MisoScenePanel;
import com.threerings.miso.client.SceneBlock;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import javax.swing.JPanel;

public class ResolutionView
extends JPanel {
    protected MisoScenePanel _panel;
    protected MisoSceneMetrics _metrics;
    protected HashMap<IntTuple, BlockGlyph> _blocks = Maps.newHashMap();
    protected static final int TILE_SIZE = 10;
    protected static final int MAX_WIDTH = 30;
    protected static final int MAX_HEIGHT = 30;

    public ResolutionView(MisoScenePanel panel) {
        this._panel = panel;
        this._metrics = panel.getSceneMetrics();
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    public synchronized void queuedBlock(SceneBlock block) {
        this.assignColor(block, Color.yellow);
        this.repaint();
    }

    public synchronized void resolvingBlock(SceneBlock block) {
        IntTuple key = this.blockKey(block);
        if (this._blocks.containsKey(key)) {
            this.assignColor(block, Color.red);
            this.repaint();
        }
    }

    public synchronized void resolvedBlock(SceneBlock block) {
        IntTuple key = this.blockKey(block);
        if (this._blocks.containsKey(key)) {
            this.assignColor(block, Color.green);
            this.repaint();
        }
    }

    public synchronized void blockCleared(SceneBlock block) {
        this._blocks.remove(this.blockKey(block));
        this.repaint();
    }

    public synchronized void newScene() {
        this._blocks.clear();
        this.repaint();
    }

    protected void assignColor(SceneBlock block, Color color) {
        IntTuple key = this.blockKey(block);
        BlockGlyph glyph = this._blocks.get(key);
        if (glyph == null) {
            glyph = new BlockGlyph(this._metrics, key.left, key.right);
            this._blocks.put(key, glyph);
        }
        glyph.color = color;
    }

    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gfx = (Graphics2D)g;
        Rectangle vbounds = this._panel.getViewBounds();
        gfx.translate((this.getWidth() - vbounds.width / 16) / 2 - vbounds.x / 16, (this.getHeight() - vbounds.height / 16) / 2 - vbounds.y / 16);
        AffineTransform xform = gfx.getTransform();
        gfx.scale(0.25, 0.25);
        for (BlockGlyph blockGlyph : this._blocks.values()) {
            blockGlyph.paint(gfx);
        }
        gfx.scale(0.25, 0.25);
        gfx.draw(vbounds);
        gfx.setColor(Color.red);
        gfx.draw(this._panel.getInfluentialBounds());
        gfx.setTransform(xform);
    }

    protected final IntTuple blockKey(SceneBlock block) {
        Rectangle bounds = block.getBounds();
        return new IntTuple(MathUtil.floorDiv(bounds.x, bounds.width), MathUtil.floorDiv(bounds.y, bounds.height));
    }

    protected static class BlockGlyph {
        public Color color;
        protected Polygon _bpoly;

        public BlockGlyph(MisoSceneMetrics metrics, int bx, int by) {
            this._bpoly = MisoUtil.getTilePolygon(metrics, bx, by);
        }

        public void paint(Graphics2D gfx) {
            gfx.setColor(this.color);
            gfx.fill(this._bpoly);
            gfx.setColor(Color.black);
            gfx.draw(this._bpoly);
        }
    }
}

